/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PasswordUtility {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String HASHING_ALGORITHM = "PBKDF2WithHmacSHA512";
    private static final String DELIMITER = "{E}";
    private static final String SALT_DELIMITER = "{S}";
    private static final int ITERATIONS = 20000;
    private static final int HASH_SIZE = 64;

    public static boolean isPasswordCorrect(String string, byte[] byArray) {
        try {
            String string2 = new String(byArray, CHARSET);
            int n = string2.indexOf(SALT_DELIMITER);
            byte[] byArray2 = Base64.getDecoder().decode(string2.substring(0, n));
            byte[] byArray3 = Base64.getDecoder().decode(string2.substring(n + SALT_DELIMITER.length(), string2.indexOf(DELIMITER)));
            return Arrays.equals(byArray3, PasswordUtility.getHashedPassword(string, byArray2));
        }
        catch (Exception exception) {
            System.err.println("Reading password hash failed" + exception);
            return false;
        }
    }

    public static String getRoleInHash(byte[] byArray) {
        String string = new String(byArray, CHARSET);
        int n = string.indexOf(DELIMITER);
        return string.substring(n + DELIMITER.length());
    }

    public static byte[] encryptPassword(String string, String string2) {
        byte[] byArray = new byte[64];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray);
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(Base64.getEncoder().encodeToString(byArray));
        stringBuilder.append(SALT_DELIMITER);
        byte[] byArray2 = PasswordUtility.getHashedPassword(string, byArray);
        stringBuilder.append(Base64.getEncoder().encodeToString(byArray2));
        stringBuilder.append(DELIMITER);
        stringBuilder.append(string2);
        return stringBuilder.toString().getBytes(CHARSET);
    }

    private static byte[] getHashedPassword(String string, byte[] byArray) {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), byArray, 20000, 512);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(HASHING_ALGORITHM);
            return secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            System.err.println("Could not find hashing algorithm" + generalSecurityException);
            return null;
        }
    }

    public static byte[] calcSMD5(byte[] byArray, byte[] byArray2) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return new byte[0];
        }
        messageDigest.reset();
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        byte[] byArray3 = messageDigest.digest();
        byte[] byArray4 = new byte[byArray3.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        byte[] byArray5 = Base64.getEncoder().encodeToString(byArray4).getBytes(CHARSET);
        return byArray5;
    }
}

