/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import at.jta.Regor;
import com.agfa.pacs.base.util.Product;
import java.util.Locale;

public class ProcessorUtilities {
    private static final int MAXIMUM_NUMBER_OF_PARALELL_THREADS = 6;
    private static String processorName = null;

    public static boolean hasOnePhysicalCore() {
        return Runtime.getRuntime().availableProcessors() == 1;
    }

    public static String getProcessorName() {
        if (processorName != null) {
            return processorName;
        }
        try {
            Regor regor = new Regor();
            int n = regor.openKey(-2147483646, "Hardware\\Description\\System\\CentralProcessor\\0");
            byte[] byArray = regor.readValue(n, "ProcessorNameString");
            regor.closeKey(n);
            processorName = Regor.parseValue((byte[])byArray);
        }
        catch (Exception exception) {
            return "";
        }
        return processorName;
    }

    public static boolean isAmd64onWindows() {
        String string = System.getProperty("os.arch");
        if (string.equalsIgnoreCase("amd64")) {
            return ProcessorUtilities.isWindows();
        }
        return false;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toUpperCase(Locale.ENGLISH).contains("WIN");
    }

    private static int getNumberOfPhysicalCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int getNumberOfParallelThreads2Run() {
        int n = ProcessorUtilities.getNumberOfPhysicalCores() - 1;
        if (Product.isCDViewer()) {
            n = 1;
        }
        if (Product.isReducedVersion()) {
            n = 2;
        }
        if (n < 1) {
            n = 1;
        }
        if (n > 6) {
            n = 6;
        }
        return n;
    }
}

