/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.tce;

import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.base.util.FileServiceUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.dicom.lw.datainfo.AbstractDicomDataInfoNode;
import com.agfa.pacs.data.export.tce.ITeachingFileConfig;
import com.agfa.pacs.data.export.tce.TCEProviderFactory;
import com.agfa.pacs.data.export.tce.TeachingFileProperty;
import com.agfa.pacs.data.export.tce.keyword.IKeywordProvider;
import com.agfa.pacs.data.export.tce.property.TeachingFileConfigProperties;
import com.agfa.pacs.data.export.tce.property.TeachingFileConfigProperty;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.impaxee.tce.SimpleTeachingFileNode;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import com.agfa.pacs.listtext.lta.util.Modality;
import com.agfa.pacs.logging.ALogger;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.net.Connection;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TeachingFileConfig
implements ITeachingFileConfig {
    private static final ALogger log = ALogger.getLogger(TeachingFileConfig.class);
    private static final String RootPath = "listtext.lta.teachingfile";
    private static final String NodePath = "listtext.lta.teachingfile.nodesXML";
    public static final String PropertiesPath = "listtext.lta.teachingfile.propertiesXML";
    public static final String AutoQueryPath = "listtext.lta.teachingfile.autoQuery";
    public static final String AutoQueryAgeEnabledPath = "listtext.lta.teachingfile.autoQueryAgeEnabled";
    public static final String AutoQueryAgePath = "listtext.lta.teachingfile.autoQueryAge";
    public static final String CurrentUserAuthorPath = "listtext.lta.teachingfile.authorCurrentUser";
    private static final String KeywordProvidersPath = "listtext.lta.teachingfile.keywordProvidersXML";
    private static final String AuditHostPath = "listtext.lta.teachingfile.audit.syslog.host";
    private static final String AuditPortPath = "listtext.lta.teachingfile.audit.syslog.port";
    private static final String AuditProtocolPath = "listtext.lta.teachingfile.audit.syslog.protocol";
    private static final String AuditApplicationNamePath = "listtext.lta.teachingfile.audit.syslog.applicationName";
    private static final String AuditEnabledPath = "listtext.lta.teachingfile.audit.enabled";
    private static final String EthnicGroupsPath = "listtext.lta.teachingfile.ethnicGroups";
    private static TeachingFileConfig runtimeInstance;
    private IConfigurationProvider rootCp;
    private List<SimpleTeachingFileNode> nodes;
    private TeachingFileConfigProperties properties;
    private boolean isAutoQueryEnabled;
    private boolean isCurrentUserAuthor;
    private boolean isAutoQueryAgeEnabled;
    private ITeachingFileConfig.TeachingFileAge autoQueryAge;
    private boolean auditEnabled;
    private String auditApplicationName;
    private String auditHost;
    private String auditProtocol;
    private int auditPort;
    private Map<TeachingFileProperty<? extends Object>, KeywordProviderItem> keywordProviders;
    private List<String> ethnicGroups;

    public TeachingFileConfig() {
        this(ConfigurationProviderFactory.getConfig());
        runtimeInstance = this;
    }

    private TeachingFileConfig(IConfigurationProvider iConfigurationProvider) {
        this.rootCp = iConfigurationProvider;
        this.init();
    }

    private void initKeywordProvider() {
        if (this.keywordProviders == null) {
            this.keywordProviders = this.readKeywordProviders(this.rootCp, KeywordProvidersPath);
        }
    }

    public static TeachingFileConfig getRuntimeInstance() {
        if (runtimeInstance == null) {
            runtimeInstance = new TeachingFileConfig();
        }
        return runtimeInstance;
    }

    public static TeachingFileConfig createInstance(IConfigurationProvider iConfigurationProvider) {
        if (iConfigurationProvider == ConfigurationProviderFactory.getConfig()) {
            return TeachingFileConfig.getRuntimeInstance();
        }
        return new TeachingFileConfig(iConfigurationProvider);
    }

    public final IConfigurationProvider getConfigProvider() {
        return this.rootCp;
    }

    public boolean isAutoQueryEnabled() {
        return this.isAutoQueryEnabled;
    }

    public boolean isAutoQueryAgeEnabled() {
        return this.isAutoQueryAgeEnabled;
    }

    public ITeachingFileConfig.TeachingFileAge getAutoQueryAge() {
        return this.autoQueryAge;
    }

    public void setAutoQueryAge(ITeachingFileConfig.TeachingFileAge teachingFileAge) {
        if (teachingFileAge != null) {
            this.autoQueryAge = teachingFileAge;
        }
    }

    public List<AbstractDicomDataInfoNode> getSourceNodes() {
        ArrayList<AbstractDicomDataInfoNode> arrayList = new ArrayList<AbstractDicomDataInfoNode>();
        for (SimpleTeachingFileNode simpleTeachingFileNode : this.nodes) {
            try {
                if (!simpleTeachingFileNode.isEnabled()) continue;
                arrayList.add((AbstractDicomDataInfoNode)DicomUtils.createDataInfoNode((String)simpleTeachingFileNode.toString(), (IDicomNode)simpleTeachingFileNode));
            }
            catch (Exception exception) {
                log.error("Could not create an appropriate source node", (Throwable)exception);
            }
        }
        return arrayList;
    }

    public List<SimpleTeachingFileNode> getTCENodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public void addTCENode(SimpleTeachingFileNode simpleTeachingFileNode) {
        this.nodes.add(simpleTeachingFileNode);
    }

    public void removeTCENode(SimpleTeachingFileNode simpleTeachingFileNode) {
        this.nodes.remove((Object)simpleTeachingFileNode);
    }

    public List<IDicomNode> getTargetNodes() {
        ArrayList<IDicomNode> arrayList = new ArrayList<IDicomNode>();
        for (SimpleTeachingFileNode simpleTeachingFileNode : this.nodes) {
            if (!simpleTeachingFileNode.isEnabled()) continue;
            arrayList.add((IDicomNode)simpleTeachingFileNode);
        }
        return arrayList;
    }

    public boolean isCurrentUserAuthor() {
        return this.isCurrentUserAuthor;
    }

    public TeachingFileConfigProperties getProperties() {
        return this.properties;
    }

    public boolean isAuditingEnabled() {
        return this.auditEnabled;
    }

    public void setAuditingEnabled(boolean bl) {
        this.auditEnabled = bl;
    }

    public String getAuditHost() {
        return this.auditHost;
    }

    public int getAuditPort() {
        return this.auditPort;
    }

    public Connection.Protocol getAuditProtocol() {
        return this.auditProtocol.equalsIgnoreCase("UDP") ? Connection.Protocol.SYSLOG_UDP : Connection.Protocol.SYSLOG_TLS;
    }

    public String getAuditApplicationName() {
        return this.auditApplicationName;
    }

    public void setAuditHost(String string) {
        if (string == null) {
            string = "";
        }
        this.auditHost = string;
    }

    public void setAuditPort(int n) {
        this.auditPort = n;
    }

    public void setAuditProtocol(String string) {
        if (string == null) {
            string = "UDP";
        }
        this.auditProtocol = string;
    }

    public IKeywordProvider getKeywordProvider(TeachingFileProperty<? extends Object> teachingFileProperty) {
        this.initKeywordProvider();
        KeywordProviderItem keywordProviderItem = this.keywordProviders.get(teachingFileProperty);
        return keywordProviderItem != null ? keywordProviderItem.getProvider() : null;
    }

    public boolean isKeywordProviderExclusive(TeachingFileProperty<? extends Object> teachingFileProperty) {
        this.initKeywordProvider();
        KeywordProviderItem keywordProviderItem = this.keywordProviders.get(teachingFileProperty);
        return keywordProviderItem != null ? keywordProviderItem.isExclusive() : false;
    }

    public void setKeywordProvider(TeachingFileProperty<? extends Object> teachingFileProperty, IKeywordProvider iKeywordProvider) {
        this.initKeywordProvider();
        KeywordProviderItem keywordProviderItem = this.keywordProviders.get(teachingFileProperty);
        this.setKeywordProvider(teachingFileProperty, iKeywordProvider, keywordProviderItem != null ? keywordProviderItem.isExclusive() : true);
    }

    public void setKeywordProvider(TeachingFileProperty<? extends Object> teachingFileProperty, IKeywordProvider iKeywordProvider, boolean bl) {
        IKeywordProvider iKeywordProvider2;
        this.initKeywordProvider();
        KeywordProviderItem keywordProviderItem = this.keywordProviders.get(teachingFileProperty);
        IKeywordProvider iKeywordProvider3 = iKeywordProvider2 = keywordProviderItem != null ? keywordProviderItem.getProvider() : null;
        if (iKeywordProvider2 != iKeywordProvider) {
            if (iKeywordProvider == null) {
                this.keywordProviders.remove(teachingFileProperty);
            } else if (keywordProviderItem != null) {
                keywordProviderItem.setProvider(iKeywordProvider);
                keywordProviderItem.setExclusive(bl);
            } else {
                this.keywordProviders.put(teachingFileProperty, new KeywordProviderItem(iKeywordProvider, bl));
            }
            TeachingFileConfigProperty teachingFileConfigProperty = this.properties.find(teachingFileProperty);
            if (teachingFileConfigProperty != null) {
                teachingFileConfigProperty.setUseInExport(false);
                teachingFileConfigProperty.setUseInQuery(false);
                teachingFileConfigProperty.getPropertyValue().setEmptyValue();
            }
        } else if (keywordProviderItem != null) {
            keywordProviderItem.setExclusive(bl);
        }
    }

    public List<String> getEthnicGroups() {
        return Collections.unmodifiableList(this.ethnicGroups);
    }

    public String getEthnicGroupsAsString() {
        return TeachingFileConfig.toOptionString(this.ethnicGroups);
    }

    public void setEthnicGroupsAsString(String string) {
        this.ethnicGroups = TeachingFileConfig.fromOptionString(string);
    }

    public void setEthnicGroups(List<String> list) {
        this.ethnicGroups = list;
    }

    public void resetPropertiesToRole() {
        if (this.rootCp.exists(PropertiesPath)) {
            this.rootCp.removeValue(PropertiesPath);
        }
        this.rootCp.storeAllConfiguration();
        this.rootCp.updateCache(PropertiesPath);
        this.properties = this.readProperties(this.rootCp, PropertiesPath);
    }

    public void save() {
        String string;
        boolean bl;
        if (this.properties.isModified()) {
            this.writeProperties(this.properties, this.rootCp, PropertiesPath);
            this.properties.resetModified();
        }
        boolean bl2 = bl = (string = this.rootCp.getRole()) != null && string.indexOf(47) < 0;
        if (bl) {
            this.rootCp.setBoolean(AuditEnabledPath, this.auditEnabled);
            this.rootCp.setString(AuditHostPath, this.auditHost);
            this.rootCp.setString(AuditProtocolPath, this.auditProtocol);
            this.rootCp.setLong(AuditPortPath, (long)this.auditPort);
            this.rootCp.setString(EthnicGroupsPath, TeachingFileConfig.toOptionString(this.ethnicGroups));
            this.writeNodes(this.rootCp, NodePath);
            if (this.keywordProviders != null) {
                this.writeKeywordProviders(this.keywordProviders, this.rootCp, KeywordProvidersPath);
            }
        } else {
            if (this.rootCp.exists(AuditEnabledPath)) {
                this.rootCp.removeValue(AuditEnabledPath);
            }
            if (this.rootCp.exists(AuditHostPath)) {
                this.rootCp.removeValue(AuditHostPath);
            }
            if (this.rootCp.exists(AuditProtocolPath)) {
                this.rootCp.removeValue(AuditProtocolPath);
            }
            if (this.rootCp.exists(AuditPortPath)) {
                this.rootCp.removeValue(AuditPortPath);
            }
            if (this.rootCp.exists(EthnicGroupsPath)) {
                this.rootCp.removeValue(EthnicGroupsPath);
            }
            if (this.rootCp.exists(NodePath)) {
                this.rootCp.removeValue(NodePath);
            }
            if (this.rootCp.exists(KeywordProvidersPath)) {
                this.rootCp.removeValue(KeywordProvidersPath);
            }
        }
    }

    public void init() {
        this.nodes = TeachingFileConfig.readNodes(this.rootCp, NodePath);
        this.properties = this.readProperties(this.rootCp, PropertiesPath);
        this.ethnicGroups = TeachingFileConfig.fromOptionString(this.rootCp.getString(EthnicGroupsPath));
        this.isAutoQueryEnabled = this.rootCp.getBoolean(AutoQueryPath);
        this.isCurrentUserAuthor = this.rootCp.getBoolean(CurrentUserAuthorPath);
        this.isAutoQueryAgeEnabled = this.rootCp.getBoolean(AutoQueryAgeEnabledPath);
        this.autoQueryAge = ITeachingFileConfig.TeachingFileAge.valueOf((String)this.rootCp.getString(AutoQueryAgePath));
        this.auditApplicationName = this.rootCp.getString(AuditApplicationNamePath);
        this.auditHost = this.rootCp.getString(AuditHostPath);
        this.auditProtocol = this.rootCp.getString(AuditProtocolPath);
        this.auditPort = (int)this.rootCp.getLong(AuditPortPath);
        this.auditEnabled = this.rootCp.getBoolean(AuditEnabledPath);
    }

    private static List<SimpleTeachingFileNode> readNodes(IConfigurationProvider iConfigurationProvider, String string) {
        ArrayList<SimpleTeachingFileNode> arrayList = new ArrayList<SimpleTeachingFileNode>();
        if (iConfigurationProvider.exists(string)) {
            try {
                Document document = ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)iConfigurationProvider, (String)string);
                NodeList nodeList = document.getElementsByTagName("node");
                int n = 0;
                while (n < nodeList.getLength()) {
                    try {
                        NamedNodeMap namedNodeMap = nodeList.item(n).getAttributes();
                        String string2 = namedNodeMap.getNamedItem("type").getTextContent();
                        if (!string2.equalsIgnoreCase("IMPAXEE")) {
                            log.debug("Unknown TCE Archive type:" + string2);
                        } else {
                            arrayList.add(TeachingFileConfig.create(nodeList.item(n).getFirstChild()));
                        }
                    }
                    catch (Exception exception) {
                        log.error("Creating teaching-file node failed!", (Throwable)exception);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                log.error("Reading teaching-file nodes from configuration failed!", (Throwable)exception);
            }
        }
        return arrayList;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="Null pointer infeasible at that point")
    private static SimpleTeachingFileNode create(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem("id") != null ? namedNodeMap.getNamedItem("name").getTextContent() : null;
        String string2 = namedNodeMap.getNamedItem("host") != null ? namedNodeMap.getNamedItem("host").getTextContent() : null;
        int n = namedNodeMap.getNamedItem("port") != null ? Integer.valueOf(namedNodeMap.getNamedItem("port").getTextContent()) : -1;
        String string3 = namedNodeMap.getNamedItem("called-aet") != null ? namedNodeMap.getNamedItem("called-aet").getTextContent() : null;
        String string4 = namedNodeMap.getNamedItem("calling-aet") != null ? namedNodeMap.getNamedItem("calling-aet").getTextContent() : null;
        boolean bl = namedNodeMap.getNamedItem("enabled") != null ? Boolean.valueOf(namedNodeMap.getNamedItem("enabled").getTextContent()) : null;
        return new SimpleTeachingFileNode(string, string2, n, string3, string4, bl);
    }

    private TeachingFileConfigProperties readProperties(IConfigurationProvider iConfigurationProvider, String string) {
        ArrayList<TeachingFileConfigProperty> arrayList;
        block6: {
            arrayList = new ArrayList<TeachingFileConfigProperty>();
            if (iConfigurationProvider.exists(string)) {
                try {
                    Document document = ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)iConfigurationProvider, (String)string);
                    NodeList nodeList = document.getElementsByTagName("property");
                    if (nodeList == null) break block6;
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        try {
                            arrayList.add(TeachingFileConfigProperty.create((Node)nodeList.item(n)));
                        }
                        catch (Exception exception) {
                            log.warn("Can't read property value! Skipped...", (Throwable)exception);
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    log.error("Can't read property values for config key '" + string + "'");
                }
            }
        }
        return new TeachingFileConfigProperties(arrayList);
    }

    private Map<TeachingFileProperty<? extends Object>, KeywordProviderItem> readKeywordProviders(IConfigurationProvider iConfigurationProvider, String string) {
        HashMap<TeachingFileProperty<? extends Object>, KeywordProviderItem> hashMap;
        block7: {
            hashMap = new HashMap<TeachingFileProperty<? extends Object>, KeywordProviderItem>();
            if (iConfigurationProvider.exists(string)) {
                try {
                    Document document = ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)iConfigurationProvider, (String)string);
                    NodeList nodeList = document.getElementsByTagName("keyword-mapping");
                    if (nodeList == null) break block7;
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        try {
                            Node node = nodeList.item(n);
                            NamedNodeMap namedNodeMap = node.getAttributes();
                            TeachingFileProperty teachingFileProperty = TeachingFileProperty.valueOf((String)namedNodeMap.getNamedItem("property-name").getTextContent());
                            IKeywordProvider iKeywordProvider = TCEProviderFactory.getInstance().getKeywordProvider(namedNodeMap.getNamedItem("keyword-provider").getTextContent());
                            if (teachingFileProperty != null && iKeywordProvider != null) {
                                boolean bl = namedNodeMap.getNamedItem("exclusive") != null ? Boolean.valueOf(namedNodeMap.getNamedItem("exclusive").getNodeValue()) : true;
                                hashMap.put((TeachingFileProperty<? extends Object>)teachingFileProperty, new KeywordProviderItem(iKeywordProvider, bl));
                            }
                        }
                        catch (Exception exception) {
                            log.error("Can't create/initialize keyword provider!", (Throwable)exception);
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    log.error("Can't initiate keyword provider mapping!", (Throwable)exception);
                }
            }
        }
        return hashMap;
    }

    private void writeNodes(IConfigurationProvider iConfigurationProvider, String string) {
        try {
            boolean bl;
            String string2 = iConfigurationProvider.getRole();
            boolean bl2 = bl = string2 != null && string2.indexOf(47) < 0;
            if (!bl) {
                if (iConfigurationProvider.exists(string)) {
                    iConfigurationProvider.removeValue(string);
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<nodes>");
                for (SimpleTeachingFileNode simpleTeachingFileNode : this.nodes) {
                    stringBuilder.append("<node type=\"IMPAXEE\">");
                    stringBuilder.append(this.toXML(simpleTeachingFileNode));
                    stringBuilder.append("</node>");
                }
                stringBuilder.append("</nodes>");
                ConfigUtilities.saveToConfigAsXML_UTF16((IConfigurationProvider)iConfigurationProvider, (String)string, (String)stringBuilder.toString());
            }
        }
        catch (Exception exception) {
            log.error("Saving teaching-file nodes to configuration failed!", (Throwable)exception);
        }
    }

    private String toXML(SimpleTeachingFileNode simpleTeachingFileNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<attrs");
        stringBuilder.append(" type=\"IMPAXEE\"");
        stringBuilder.append(" id=\"1\"");
        stringBuilder.append(" name=\"" + simpleTeachingFileNode.toString() + "\"");
        stringBuilder.append(" host=\"" + simpleTeachingFileNode.getHost() + "\"");
        stringBuilder.append(" port=\"" + simpleTeachingFileNode.getPort() + "\"");
        stringBuilder.append(" called-aet=\"" + simpleTeachingFileNode.getCalledAET() + "\"");
        if (simpleTeachingFileNode.getCallingAET() != null && !simpleTeachingFileNode.getCallingAET().isEmpty()) {
            stringBuilder.append(" calling-aet=\"" + simpleTeachingFileNode.getCallingAET() + "\"");
        }
        stringBuilder.append(" enabled=\"" + simpleTeachingFileNode.isEnabled() + "\"");
        stringBuilder.append(" ihetceCompatibility=\"true\"");
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }

    private void writeProperties(TeachingFileConfigProperties teachingFileConfigProperties, IConfigurationProvider iConfigurationProvider, String string) {
        try {
            ConfigUtilities.saveToConfigAsXML_UTF16((IConfigurationProvider)iConfigurationProvider, (String)string, (String)teachingFileConfigProperties.toXML());
        }
        catch (Exception exception) {
            log.error("Saving properties failed for config key '" + string + "'");
        }
    }

    private void writeKeywordProviders(Map<TeachingFileProperty<? extends Object>, KeywordProviderItem> map, IConfigurationProvider iConfigurationProvider, String string) {
        try {
            boolean bl;
            String string2 = iConfigurationProvider.getRole();
            boolean bl2 = bl = string2 != null && string2.indexOf(47) < 0;
            if (!bl) {
                if (iConfigurationProvider.exists(string)) {
                    iConfigurationProvider.removeValue(string);
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<keyword-mappings>");
                if (map != null && !map.isEmpty()) {
                    for (Map.Entry<TeachingFileProperty<? extends Object>, KeywordProviderItem> entry : map.entrySet()) {
                        stringBuilder.append("<keyword-mapping");
                        stringBuilder.append(" property-name=\"" + entry.getKey().name() + "\"");
                        stringBuilder.append(" keyword-provider=\"" + entry.getValue().getProvider().getId() + "\"");
                        stringBuilder.append(" exclusive=\"" + Boolean.toString(entry.getValue().isExclusive()) + "\"");
                        stringBuilder.append("/>");
                    }
                }
                stringBuilder.append("</keyword-mappings>");
                ConfigUtilities.saveToConfigAsXML_UTF16((IConfigurationProvider)iConfigurationProvider, (String)string, (String)stringBuilder.toString());
            }
        }
        catch (Exception exception) {
            log.error("Saving keyword-mappings to configuration failed!", (Throwable)exception);
        }
    }

    private static List<String> fromOptionString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && !string.trim().isEmpty()) {
            arrayList.addAll(Arrays.asList(string.trim().split("\n")));
        }
        return arrayList;
    }

    private static String toOptionString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            stringBuilder.append(list.get(0));
            int n = 1;
            while (n < list.size()) {
                stringBuilder.append("\n").append(list.get(n));
                ++n;
            }
        }
        return stringBuilder.toString();
    }

    public Collection<String> getXMLKeywordProviderNames() {
        try {
            if (!Product.isCDViewer()) {
                return CodingSystemsFileServiceUtil.getInstance().getCodingSystemFileNames(".*\\.xml");
            }
        }
        catch (Exception exception) {
            log.error("Could not retrieve XML catalogs", (Throwable)exception);
        }
        return Collections.emptyList();
    }

    public InputStream getXMLKeyProviderStream(String string) throws Exception {
        return CodingSystemsFileServiceUtil.getInstance().getCodingSystemFile(string);
    }

    public String[] getAvailableModalities() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Modality[] modalityArray = Modality.valuesNonRetired();
        int n = modalityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Modality modality = modalityArray[n2];
            arrayList.add(modality.dicom());
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getLocalizedTagName(int n) {
        return DicomTagDictionaryFactory.getLocaleDictionary().getNameForTag(n);
    }

    private static class CodingSystemsFileServiceUtil
    extends FileServiceUtil {
        private static CodingSystemsFileServiceUtil instance;

        private CodingSystemsFileServiceUtil() {
            super("coding-systems");
        }

        public static synchronized CodingSystemsFileServiceUtil getInstance() {
            if (instance == null) {
                instance = new CodingSystemsFileServiceUtil();
            }
            return instance;
        }

        public Collection<String> getCodingSystemFileNames(String string) throws Exception {
            return this.getFileNames(null, string);
        }

        public InputStream getCodingSystemFile(String string) throws Exception {
            return this.getDataStream(null, string);
        }
    }

    private static class KeywordProviderItem {
        private IKeywordProvider prov;
        private boolean exclusive;

        public KeywordProviderItem(IKeywordProvider iKeywordProvider, boolean bl) {
            this.prov = iKeywordProvider;
            this.exclusive = bl;
        }

        public IKeywordProvider getProvider() {
            return this.prov;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        public void setProvider(IKeywordProvider iKeywordProvider) {
            if (this.prov == null && iKeywordProvider != null) {
                this.exclusive = true;
            } else if (this.prov != null && iKeywordProvider == null) {
                this.exclusive = false;
            }
            this.prov = iKeywordProvider;
        }

        public void setExclusive(boolean bl) {
            this.exclusive = bl;
        }
    }
}

