/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.tce;

import com.agfa.pacs.data.dicom.lw.datainfo.AbstractDicomDataInfoNode;
import com.agfa.pacs.data.export.tce.TeachingFile;
import com.agfa.pacs.data.export.tce.TeachingFileAuditManager;
import com.agfa.pacs.data.export.tce.TeachingFileProperty;
import com.agfa.pacs.data.export.tce.property.TeachingFileConfigProperty;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.SingleObjectDataListener;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.cycling.CycleListProviderFactory;
import com.agfa.pacs.listtext.cycling.CycleListProviderListenerAdapter;
import com.agfa.pacs.listtext.cycling.ICycleListProvider;
import com.agfa.pacs.listtext.cycling.ICycleListProviderListener;
import com.agfa.pacs.listtext.lta.util.DataFinderUtilities;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcm4che3.data.Attributes;

public class TeachingFileUtilities2 {
    private static final ALogger log = ALogger.getLogger(TeachingFileUtilities2.class);
    private static CycleListProviderListener cyclelistListener;

    public static List<IObjectInfo> queryReferencedObjects(TeachingFile<TeachingFile.ObjectReference> teachingFile) throws Exception {
        List list = teachingFile.getReferencedObjects();
        if (list != null && !list.isEmpty()) {
            Object object;
            TeachingFile.ObjectReference objectReference2;
            AbstractDicomDataInfoNode abstractDicomDataInfoNode = teachingFile.getSourceNode();
            HashMap hashMap = new HashMap();
            for (TeachingFile.ObjectReference objectReference2 : list) {
                String string = objectReference2.instanceUID;
                object = objectReference2.retrieveAET;
                Object object2 = null;
                object2 = object == null || ((String)object).equals(abstractDicomDataInfoNode.getSourceAET()) ? abstractDicomDataInfoNode : Base.getConfiguredDataInfoNodeByAET((String)object);
                if (object2 != null) {
                    ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(object2);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                        hashMap.put((AbstractDicomDataInfoNode)object2, arrayList);
                    }
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                    continue;
                }
                log.warn("Couldn't query for referenced object: Retrieve AET (" + (String)object + ") not configured!");
            }
            objectReference2 = new ArrayList();
            for (Map.Entry entry : hashMap.entrySet()) {
                object = DataFinderUtilities.findObjects((IDataInfoSource)((IDataInfoSource)entry.getKey()), (Collection)((Collection)entry.getValue()));
                objectReference2.addAll(object);
            }
            return objectReference2;
        }
        return Collections.emptyList();
    }

    public static TeachingFile<TeachingFile.ObjectReference> retrieveTeachingFile(TeachingFile<TeachingFile.ObjectReference> teachingFile) throws Exception {
        Boolean bl = (Boolean)teachingFile.getClientProperty(TeachingFile.ClientProperty.RETRIEVED);
        if (bl == null || Boolean.FALSE.equals(bl)) {
            List list = DataFinderUtilities.findObjects((IDataInfoSource)teachingFile.getSourceNode(), Collections.singletonList(teachingFile.getClientProperty(TeachingFile.ClientProperty.ATFI_IUID).toString()));
            SingleObjectDataListener singleObjectDataListener = new SingleObjectDataListener(((IObjectInfo)list.get(0)).getSOPInstanceUID());
            IDicomDataRequest iDicomDataRequest = DicomDataRequester.getInstance().createDicomDataRequest((IObjectInfo)list.get(0), (byte)0);
            iDicomDataRequest.setListener((IDicomDataListener)singleObjectDataListener);
            iDicomDataRequest.setFromCache(false);
            DicomDataRequester.getInstance().addRequest(iDicomDataRequest);
            iDicomDataRequest.waitUntilFinished();
            teachingFile = TeachingFile.fromDataset((Attributes)singleObjectDataListener.getDataset(), (AbstractDicomDataInfoNode)teachingFile.getSourceNode());
            teachingFile.putClientProperty(TeachingFile.ClientProperty.RETRIEVED, (Object)Boolean.TRUE);
        }
        return teachingFile;
    }

    public static TeachingFile<IObjectInfo> retrieveReferences(TeachingFile<TeachingFile.ObjectReference> teachingFile) throws Exception {
        TeachingFile<TeachingFile.ObjectReference> teachingFile2 = TeachingFileUtilities2.retrieveTeachingFile(teachingFile);
        List<IObjectInfo> list = TeachingFileUtilities2.queryReferencedObjects(teachingFile2);
        return TeachingFile.createResolvedTeachingFile(teachingFile2, list);
    }

    public static void openTeachingFileInImageArea(IStudyInfo iStudyInfo, TeachingFile<TeachingFile.ObjectReference> teachingFile) throws Exception {
        ICycleListProvider iCycleListProvider = CycleListProviderFactory.getInstance().getCycleListProvider();
        if (iCycleListProvider == null) {
            throw new UnsupportedOperationException();
        }
        TeachingFile<IObjectInfo> teachingFile2 = TeachingFileUtilities2.retrieveReferences(teachingFile);
        List list = teachingFile2.getReferencedObjects();
        if (list != null && !list.isEmpty()) {
            if (cyclelistListener == null) {
                cyclelistListener = new CycleListProviderListener();
                iCycleListProvider.addCycleListProviderListener((ICycleListProviderListener)cyclelistListener);
            }
            List list2 = DataInfoUtilities.getLevel((Collection)list, IStudyInfo.class);
            if (iStudyInfo == null || DataInfoUtilities.findEqual((Collection)list2, (IDataInfo)iStudyInfo) != null) {
                cyclelistListener.tfOpened(teachingFile2, list2);
                iCycleListProvider.addToCycleListAndDisplay(list, false);
            } else {
                IStudyInfo[] iStudyInfoArray = iCycleListProvider.getDisplayedStudies();
                boolean bl = false;
                if (iStudyInfoArray != null) {
                    IStudyInfo[] iStudyInfoArray2 = iStudyInfoArray;
                    int n = iStudyInfoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStudyInfo iStudyInfo2 = iStudyInfoArray2[n2];
                        if (iStudyInfo2.getKey().equals(iStudyInfo.getKey())) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!bl) {
                    list2.add(0, iStudyInfo);
                }
                cyclelistListener.tfOpened(teachingFile2, list2);
                iCycleListProvider.mergePatientsAndDisplay(iStudyInfo.getPatient(), list2);
            }
        } else {
            log.warn("Opening teaching-file discarded: No referenced objects found!");
        }
    }

    public static List<IStudyInfo> getLastOpenedInImageArea() {
        if (cyclelistListener != null) {
            return cyclelistListener.getLastAdded();
        }
        return Collections.emptyList();
    }

    public static List<TeachingFileProperty<?>> extractProperties(Collection<TeachingFileConfigProperty> collection) {
        if (collection != null && !collection.isEmpty()) {
            ArrayList arrayList = new ArrayList(collection.size());
            for (TeachingFileConfigProperty teachingFileConfigProperty : collection) {
                arrayList.add(teachingFileConfigProperty.getProperty());
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static TeachingFile<TeachingFile.ObjectReference> createAndInit(Attributes attributes) {
        TeachingFile teachingFile = TeachingFile.fromDataset((Attributes)attributes, null);
        return teachingFile;
    }

    private static class CycleListProviderListener
    extends CycleListProviderListenerAdapter {
        private TeachingFile<IObjectInfo> tf = null;
        private List<IStudyInfo> lastAdded = new ArrayList<IStudyInfo>(2);

        private CycleListProviderListener() {
        }

        public void tfOpened(TeachingFile<IObjectInfo> teachingFile, List<IStudyInfo> list) {
            this.tf = teachingFile;
            this.lastAdded.clear();
            if (list != null && !list.isEmpty()) {
                this.lastAdded.addAll(list);
            }
        }

        public void displayedStudiesChanged(IStudyInfo iStudyInfo, IStudyInfo[] iStudyInfoArray, Set<String> set, String string, boolean bl) {
            if (this.tf != null && !this.lastAdded.isEmpty() && iStudyInfoArray != null) {
                IStudyInfo[] iStudyInfoArray2 = iStudyInfoArray;
                int n = iStudyInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStudyInfo iStudyInfo2 = iStudyInfoArray2[n2];
                    IStudyInfo iStudyInfo3 = (IStudyInfo)DataInfoUtilities.findEqual(this.lastAdded, (IDataInfo)iStudyInfo2);
                    if (iStudyInfo3 != null) {
                        TeachingFileAuditManager.getInstance().logTFImagesViewed(this.tf);
                        this.lastAdded.clear();
                        break;
                    }
                    ++n2;
                }
            }
        }

        public void patientRemoved(IPatientInfo iPatientInfo, IStudyInfo[] iStudyInfoArray, boolean bl) {
            this.tf = null;
            this.lastAdded.clear();
        }

        public List<IStudyInfo> getLastAdded() {
            return this.lastAdded;
        }
    }
}

