/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.tce.keyword;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.data.export.tce.keyword.IKeyword;
import com.agfa.pacs.impaxee.tce.Messages;
import com.agfa.pacs.impaxee.tce.keyword.SearchableKeywordListModel;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SearchableKeywordListPanel
extends JPanel {
    private static final ALogger log = ALogger.getLogger(SearchableKeywordListPanel.class);
    private JLabel searchLabel;
    private JLabel infoLabel;
    private JTextField searchField;
    private JList<IKeyword> list;
    private JScrollPane scrollPane;

    public SearchableKeywordListPanel(Collection<? extends IKeyword> collection) {
        this.createComponents(collection);
        this.installLayout();
    }

    public IKeyword getSelectedKeyword() {
        return this.list.getSelectedValue();
    }

    public void setSelectedKeyword(IKeyword iKeyword) {
        this.searchField.setText(null);
        this.searchField.requestFocusInWindow();
        if (iKeyword == null) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedValue(iKeyword, true);
        }
    }

    private void createComponents(Collection<? extends IKeyword> collection) {
        this.list = SwingUtilities2.createList((ListModel)new SearchableKeywordListModel(collection));
        this.scrollPane = SwingUtilities2.createScrollPane(this.list, (Integer)20, (Integer)30, (Boolean)false, (Boolean)true);
        this.infoLabel = SwingUtilities2.createLabel((String)Messages.getString("TeachingFileSearchableKeywordView.Info.Text"), null, null, null);
        this.searchLabel = SwingUtilities2.createLabel((String)Messages.getString("TeachingFileSearchableKeywordView.Search.Text"), null, null, null);
        this.searchField = SwingUtilities2.createTextField(null, null, null);
        this.searchField.getDocument().addDocumentListener(new SearchFieldListener((SearchableKeywordListModel)this.list.getModel()));
        this.searchField.setPreferredSize(new Dimension(GUI.getScaledInt((int)280), this.searchField.getPreferredSize().height));
        this.scrollPane.setPreferredSize(GUI.getScaledDimension((int)280, (int)400));
    }

    private void installLayout() {
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -1.0}, new double[]{-2.0, -2.0, GUI.getScaledInt((int)15), -1.0});
        tableLayout.setHGap(GUI.getScaledInt((int)5));
        this.setLayout((LayoutManager)tableLayout);
        this.add((Component)this.searchField, "1,0");
        this.add((Component)this.searchLabel, "0,0");
        this.add((Component)this.infoLabel, "1,1");
        this.add((Component)this.scrollPane, "0,3,1,3");
    }

    private class SearchFieldListener
    implements DocumentListener {
        private SearchableKeywordListModel listModel;

        public SearchFieldListener(SearchableKeywordListModel searchableKeywordListModel) {
            this.listModel = searchableKeywordListModel;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textChanged(documentEvent.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textChanged(documentEvent.getDocument());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.textChanged(documentEvent.getDocument());
        }

        public void textChanged(Document document) {
            try {
                String string = document.getText(0, document.getLength());
                if (string == null || string.length() < 3) {
                    this.listModel.reset();
                } else {
                    this.listModel.qualify(string);
                    if (this.listModel.getSize() > 0) {
                        SearchableKeywordListPanel.this.list.setSelectedIndex(0);
                    }
                }
            }
            catch (Exception exception) {
                log.error(null, (Throwable)exception);
            }
        }
    }
}

