/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.tce.keyword;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.data.export.tce.keyword.GenericKeyword;
import com.agfa.pacs.data.export.tce.keyword.GenericKeywordNode;
import com.agfa.pacs.impaxee.tce.Messages;
import com.agfa.pacs.impaxee.tce.keyword.SearchableKeywordListPanel;
import com.agfa.pacs.impaxee.tce.keyword.SearchableKeywordTreeModel;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SearchableKeywordTreePanel
extends JPanel {
    private static final ALogger log = ALogger.getLogger(SearchableKeywordListPanel.class);
    private JLabel searchLabel;
    private JLabel infoLabel;
    private JTextField searchField;
    private JTree tree;
    private JScrollPane scrollPane;

    public SearchableKeywordTreePanel(GenericKeywordNode genericKeywordNode) {
        this.createComponents(genericKeywordNode);
        this.installLayout();
    }

    public GenericKeyword getSelectedKeyword() {
        return this.tree.getSelectionCount() > 0 ? ((GenericKeywordNode)this.tree.getSelectionPath().getLastPathComponent()).getKeyword() : null;
    }

    public void setSelectedKeyword(GenericKeyword genericKeyword) {
        this.searchField.setText(null);
        this.searchField.requestFocusInWindow();
        GenericKeywordNode genericKeywordNode = ((SearchableKeywordTreeModel)this.tree.getModel()).findNode(genericKeyword);
        if (genericKeywordNode != null) {
            this.tree.setSelectionPath(genericKeywordNode.getTreePath());
        }
    }

    private void createComponents(GenericKeywordNode genericKeywordNode) {
        this.tree = new JTree(new SearchableKeywordTreeModel(genericKeywordNode));
        this.tree.setRootVisible(false);
        this.tree.setAutoscrolls(true);
        this.tree.setExpandsSelectedPaths(true);
        this.scrollPane = SwingUtilities2.createScrollPane((Component)this.tree, (Integer)20, (Integer)30, (Boolean)false, (Boolean)true);
        this.infoLabel = SwingUtilities2.createLabel((String)Messages.getString("TeachingFileSearchableKeywordView.Info.Text"), null, null, null);
        this.searchLabel = SwingUtilities2.createLabel((String)Messages.getString("TeachingFileSearchableKeywordView.Search.Text"), null, null, null);
        this.searchField = SwingUtilities2.createTextField(null, null, null);
        this.searchField.getDocument().addDocumentListener(new SearchFieldListener((SearchableKeywordTreeModel)this.tree.getModel()));
        this.searchField.setPreferredSize(new Dimension(GUI.getScaledInt((int)280), this.searchField.getPreferredSize().height));
        this.scrollPane.setPreferredSize(GUI.getScaledDimension((int)280, (int)400));
    }

    private void installLayout() {
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -1.0}, new double[]{-2.0, -2.0, GUI.getScaledInt((int)15), -1.0});
        tableLayout.setHGap(GUI.getScaledInt((int)5));
        this.setLayout((LayoutManager)tableLayout);
        this.add((Component)this.searchField, "1,0");
        this.add((Component)this.searchLabel, "0,0");
        this.add((Component)this.infoLabel, "1,1");
        this.add((Component)this.scrollPane, "0,3,1,3");
    }

    private class SearchFieldListener
    implements DocumentListener {
        private SearchableKeywordTreeModel treeModel;

        public SearchFieldListener(SearchableKeywordTreeModel searchableKeywordTreeModel) {
            this.treeModel = searchableKeywordTreeModel;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textChanged(documentEvent.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textChanged(documentEvent.getDocument());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.textChanged(documentEvent.getDocument());
        }

        public void textChanged(Document document) {
            try {
                String string = document.getText(0, document.getLength());
                if (string == null || string.length() < 3) {
                    this.treeModel.reset();
                } else {
                    this.treeModel.qualify(string);
                    GenericKeywordNode genericKeywordNode = this.treeModel.getFirstMatchingNode();
                    if (genericKeywordNode != null) {
                        SearchableKeywordTreePanel.this.tree.expandPath(genericKeywordNode.getParent().getTreePath());
                        int n = SearchableKeywordTreePanel.this.tree.getRowForPath(genericKeywordNode.getTreePath());
                        SearchableKeywordTreePanel.this.tree.setSelectionRow(n);
                    } else {
                        SearchableKeywordTreePanel.this.tree.setSelectionRow(0);
                    }
                }
            }
            catch (Exception exception) {
                log.error("Something went wrong", (Throwable)exception);
            }
        }
    }
}

