/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.tce.report;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.export.tce.TeachingFile;
import com.agfa.pacs.data.export.tce.TeachingFileProperty;
import com.agfa.pacs.data.export.tce.keyword.IKeyword;
import com.agfa.pacs.impaxee.tce.Messages;
import com.agfa.pacs.listtext.swingx.controls.JSeparator2;
import com.agfa.pacs.listtext.swingx.layout.RowLayout;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class TeachingFilesTextAreaPanel
extends JPanel {
    private static final Color tabBg = UIManager.getColor("color.primary.1");
    private Collection<TeachingFileProperty<?>> props;
    private Map<TeachingFileProperty<?>, JLabel> labels;
    private JTabbedPane tabbedPane;
    private JPanel tabPanel;
    private JLabel emptyLabel;
    private JLabel numberOfImagesKeyLabel;
    private JLabel numberOfImagesValueLabel;
    private JLabel titleLabel;
    private JLabel createdOnLabel;
    private JLabel purposeLabel;
    private JLabel anatomyLabel;
    private JLabel pathologyLabel;
    private JLabel categoryLabel;
    private JLabel levelLabel;
    private JLabel modalitiesLabel;
    private JLabel patientSexLabel;
    private JLabel patientAgeLabel;
    private JLabel patientRaceLabel;
    private JLabel authorNameLabel;
    private JLabel authorAffiliationLabel;
    private JLabel diagnosisLabel;
    private JLabel diagnosisConfirmedLabel;
    private JLabel diffDiagnosisLabel;
    private JLabel findingsLabel;
    private JLabel organSystemsLabel;
    private JTextArea keywordsArea;
    private JTextArea authorContactArea;
    private JTextArea abstractArea;
    private JTextArea diagnosisArea;
    private JTextArea diffDiagnosisArea;
    private JTextArea findingsArea;
    private JTextArea organSystemsArea;
    private JTextArea discussionArea;
    private JTextArea historyArea;
    private JList<?> bibliographyList;
    private JComponent generalTab;
    private JComponent historyTab;
    private JComponent discussionTab;
    private JComponent diagnosisTab;
    private JComponent diffDiagnosisTab;
    private JComponent findingsTab;
    private JComponent organSystemsTab;
    private JComponent biblioTab;

    public TeachingFilesTextAreaPanel(Collection<TeachingFileProperty<?>> collection) {
        this.props = collection;
        this.createComponents();
        this.installLayout();
    }

    private void createComponents() {
        this.labels = new HashMap();
        for (TeachingFileProperty teachingFileProperty : TeachingFileProperty.properties()) {
            this.labels.put(teachingFileProperty, this.createKeyLabel(teachingFileProperty));
        }
        this.bibliographyList = SwingUtilities2.createList(new DefaultListModel());
        this.tabbedPane = SwingUtilities2.createTabbedPane((Integer)4, (Integer)0, (Boolean)true, (Boolean)false);
        this.tabPanel = SwingUtilities2.createPanel((Boolean)false, null);
        this.emptyLabel = SwingUtilities2.createLabel((String)Messages.getString("TeachingFileTextAreaView.Empty.Text"), null, null, null);
        this.titleLabel = SwingUtilities2.createLabel(null, null, null, null);
        this.numberOfImagesKeyLabel = this.createKeyLabel(Messages.getString("TeachingFileTextAreaView.NumberOfImages.Text"));
        this.numberOfImagesValueLabel = this.createValueLabel();
        this.createdOnLabel = this.createValueLabel();
        this.purposeLabel = this.createValueLabel();
        this.anatomyLabel = this.createValueLabel();
        this.pathologyLabel = this.createValueLabel();
        this.categoryLabel = this.createValueLabel();
        this.levelLabel = this.createValueLabel();
        this.modalitiesLabel = this.createValueLabel();
        this.patientSexLabel = this.createValueLabel();
        this.patientAgeLabel = this.createValueLabel();
        this.patientRaceLabel = this.createValueLabel();
        this.authorNameLabel = this.createValueLabel();
        this.authorAffiliationLabel = this.createValueLabel();
        this.diagnosisLabel = this.createValueLabel();
        this.diagnosisConfirmedLabel = this.createValueLabel();
        this.diffDiagnosisLabel = this.createValueLabel();
        this.findingsLabel = this.createValueLabel();
        this.organSystemsLabel = this.createValueLabel();
        this.abstractArea = this.createValueArea(tabBg, false);
        this.diagnosisArea = this.createValueArea(tabBg, true);
        this.diffDiagnosisArea = this.createValueArea(tabBg, true);
        this.findingsArea = this.createValueArea(tabBg, true);
        this.organSystemsArea = this.createValueArea(tabBg, true);
        this.discussionArea = this.createValueArea(tabBg, true);
        this.historyArea = this.createValueArea(tabBg, true);
        this.authorContactArea = this.createValueArea(tabBg, false);
        this.keywordsArea = this.createValueArea(tabBg, false);
        this.titleLabel.setVerticalAlignment(0);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, GUI.getScaledInt((int)20), 0, 0));
        this.emptyLabel.setFont(this.emptyLabel.getFont().deriveFont(2));
        this.emptyLabel.setHorizontalAlignment(0);
        this.bibliographyList.setCellRenderer(new BibliographyListCellRenderer());
        this.bibliographyList.setBackground(tabBg);
    }

    private void installLayout() {
        this.generalTab = this.createGeneralTab();
        this.historyTab = this.createHistoryTab();
        this.organSystemsTab = this.createOrganSystemsTab();
        this.diagnosisTab = this.createDiagnosisTab();
        this.diffDiagnosisTab = this.createDifferentialDiagnosisTab();
        this.findingsTab = this.createFindingsTab();
        this.discussionTab = this.createDiscussionTab();
        this.biblioTab = this.createBibliographyTab();
        this.tabPanel.setLayout(new BorderLayout());
        TableLayout tableLayout = new TableLayout(new double[]{-1.0, -2.0, -2.0}, new double[]{-2.0, GUI.getScaledInt((int)16), -1.0});
        tableLayout.setHGap(GUI.getScaledInt((int)10));
        this.setBorder(BorderFactory.createEmptyBorder(GUI.getScaledInt((int)5), 0, 0, 0));
        this.setLayout((LayoutManager)tableLayout);
        this.add((Component)this.titleLabel, "0,0");
        this.add((Component)SwingUtilities2.createSeparator((JSeparator2.SeparatorOrientation)JSeparator2.SeparatorOrientation.HORIZONTAL, (JSeparator2.SeparatorType)JSeparator2.SeparatorType.LINE, null), "0,1,2,1");
        this.add((Component)this.tabPanel, "0,2,2,2");
    }

    public void initComponents(TeachingFile<TeachingFile.ObjectReference> teachingFile) {
        int n;
        String[] stringArray;
        this.tabPanel.removeAll();
        this.tabbedPane.removeAll();
        this.createdOnLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.CreatedOn));
        this.purposeLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.Purpose));
        this.anatomyLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.Anatomy));
        this.pathologyLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.Pathology));
        this.categoryLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.Category));
        this.levelLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.Level));
        this.keywordsArea.setText(this.getTextValue(teachingFile, TeachingFileProperty.Keywords));
        this.modalitiesLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.AcquisitionModalities));
        this.patientSexLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.PatientSex));
        this.patientAgeLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.PatientAge));
        this.patientRaceLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.PatientSpecies));
        this.authorNameLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.AuthorName));
        this.authorAffiliationLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.AuthorAffiliation));
        this.authorContactArea.setText(this.getTextValue(teachingFile, TeachingFileProperty.AuthorContact));
        this.diagnosisLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.Diagnosis));
        this.diagnosisConfirmedLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.DiagnosisConfirmed));
        this.diffDiagnosisLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.DifferentialDiagnosis));
        this.findingsLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.Findings));
        this.organSystemsLabel.setText(this.getTextValue(teachingFile, TeachingFileProperty.OrganSystems));
        this.abstractArea.setText(this.getTextValue(teachingFile, TeachingFileProperty.Abstract));
        this.diagnosisArea.setText(this.getTextValue(teachingFile, TeachingFileProperty.Diagnosis));
        this.diffDiagnosisArea.setText(this.getTextValue(teachingFile, TeachingFileProperty.DifferentialDiagnosis));
        this.findingsArea.setText(this.getTextValue(teachingFile, TeachingFileProperty.Findings));
        this.organSystemsArea.setText(this.getTextValue(teachingFile, TeachingFileProperty.OrganSystems));
        this.discussionArea.setText(this.getTextValue(teachingFile, TeachingFileProperty.Discussion));
        this.historyArea.setText(this.getTextValue(teachingFile, TeachingFileProperty.History));
        List list = teachingFile != null ? teachingFile.getReferencedObjects() : null;
        int n2 = list != null ? list.size() : 0;
        this.numberOfImagesValueLabel.setText(Integer.toString(n2));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><b>");
        stringBuilder.append(this.getTextValue(teachingFile, TeachingFileProperty.Title));
        stringBuilder.append("</b>   [");
        stringBuilder.append(n2);
        stringBuilder.append(" ");
        stringBuilder.append(Messages.getString("TeachingFileTextAreaView.Images.Text"));
        stringBuilder.append("]</html>");
        this.titleLabel.setText(stringBuilder.toString());
        ((DefaultListModel)this.bibliographyList.getModel()).removeAllElements();
        String[] stringArray2 = stringArray = teachingFile != null ? (String[])teachingFile.getValues(TeachingFileProperty.BibliographicReferences) : null;
        if (stringArray != null) {
            String[] stringArray3 = stringArray;
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray3[n4];
                ((DefaultListModel)this.bibliographyList.getModel()).addElement(string);
                ++n4;
            }
        }
        if (this.generalTab != null && teachingFile != null) {
            this.tabbedPane.addTab(Messages.getString("TeachingFileTextAreaView.GeneralTab.Title"), this.generalTab);
        }
        if (this.historyTab != null && teachingFile != null && teachingFile.hasValue(TeachingFileProperty.History)) {
            this.tabbedPane.addTab(TeachingFileProperty.History.getName(), this.historyTab);
        }
        if (this.organSystemsTab != null && teachingFile != null && teachingFile.hasValue(TeachingFileProperty.OrganSystems)) {
            this.tabbedPane.addTab(TeachingFileProperty.OrganSystems.getName(), this.organSystemsTab);
        }
        if (this.diagnosisTab != null && teachingFile != null && teachingFile.hasValue(TeachingFileProperty.Diagnosis)) {
            this.tabbedPane.addTab(TeachingFileProperty.Diagnosis.getName(), this.diagnosisTab);
        }
        if (this.diffDiagnosisTab != null && teachingFile != null && teachingFile.hasValue(TeachingFileProperty.DifferentialDiagnosis)) {
            this.tabbedPane.addTab(TeachingFileProperty.DifferentialDiagnosis.getName(), this.diffDiagnosisTab);
        }
        if (this.findingsTab != null && teachingFile != null && teachingFile.hasValue(TeachingFileProperty.Findings)) {
            this.tabbedPane.addTab(TeachingFileProperty.Findings.getName(), this.findingsTab);
        }
        if (this.discussionTab != null && teachingFile != null && teachingFile.hasValue(TeachingFileProperty.Discussion)) {
            this.tabbedPane.addTab(TeachingFileProperty.Discussion.getName(), this.discussionTab);
        }
        if (this.biblioTab != null && teachingFile != null && teachingFile.hasValue(TeachingFileProperty.BibliographicReferences)) {
            this.tabbedPane.addTab(TeachingFileProperty.BibliographicReferences.getName(), this.biblioTab);
        }
        if ((n = this.tabbedPane.getTabCount()) > 1) {
            this.tabPanel.add((Component)this.tabbedPane, "Center");
        } else if (n == 1) {
            this.tabPanel.add(this.tabbedPane.getComponentAt(0), "Center");
        }
        this.tabPanel.revalidate();
        this.tabPanel.repaint();
    }

    private JComponent createGeneralTab() {
        int n;
        TableLayout tableLayout;
        JPanel jPanel = null;
        JPanel jPanel2 = null;
        JPanel jPanel3 = null;
        JPanel jPanel4 = null;
        JPanel jPanel5 = null;
        if (this.props.contains(TeachingFileProperty.AuthorName) || this.props.contains(TeachingFileProperty.AuthorAffiliation) || this.props.contains(TeachingFileProperty.AuthorContact)) {
            tableLayout = new TableLayout(new double[]{-2.0, -1.0}, new double[0]);
            tableLayout.setHGap(GUI.getScaledInt((int)5));
            tableLayout.setVGap(GUI.getScaledInt((int)5));
            jPanel = SwingUtilities2.createPanel((Boolean)false, null);
            jPanel.setLayout((LayoutManager)tableLayout);
            n = 0;
            if (this.props.contains(TeachingFileProperty.AuthorName)) {
                tableLayout.insertRow(n, -2.0);
                jPanel.add((Component)this.labels.get(TeachingFileProperty.AuthorName), "0," + n);
                jPanel.add((Component)this.authorNameLabel, "1," + n);
                ++n;
            }
            if (this.props.contains(TeachingFileProperty.AuthorAffiliation)) {
                tableLayout.insertRow(n, -2.0);
                jPanel.add((Component)this.labels.get(TeachingFileProperty.AuthorAffiliation), "0," + n);
                jPanel.add((Component)this.authorAffiliationLabel, "1," + n);
                ++n;
            }
            if (this.props.contains(TeachingFileProperty.AuthorContact)) {
                tableLayout.insertRow(n, -2.0);
                tableLayout.insertRow(n, -2.0);
                tableLayout.insertRow(n, -2.0);
                jPanel.add((Component)this.labels.get(TeachingFileProperty.AuthorContact), "0," + n);
                jPanel.add((Component)this.createScrollPane(this.authorContactArea, true, false, 31, GUI.getScaledDimension((int)150, (int)58)), "1," + n + ",1," + (n + 2));
                n += 3;
            }
        }
        if (this.props.contains(TeachingFileProperty.Abstract)) {
            jPanel2 = SwingUtilities2.createPanel((Boolean)false, null);
            jPanel2.setLayout(new BorderLayout(0, GUI.getScaledInt((int)5)));
            jPanel2.add((Component)this.labels.get(TeachingFileProperty.Abstract), "North");
            jPanel2.add((Component)this.createScrollPane(this.abstractArea, true, false, 31, GUI.getScaledDimension((int)150, (int)100)), "Center");
        }
        if (this.props.contains(TeachingFileProperty.PatientSex) || this.props.contains(TeachingFileProperty.PatientAge) || this.props.contains(TeachingFileProperty.PatientSpecies)) {
            tableLayout = new TableLayout(new double[]{-2.0, -1.0}, new double[0]);
            tableLayout.setHGap(GUI.getScaledInt((int)5));
            tableLayout.setVGap(GUI.getScaledInt((int)5));
            jPanel3 = SwingUtilities2.createPanel((Boolean)false, null);
            jPanel3.setLayout((LayoutManager)tableLayout);
            n = 0;
            if (this.props.contains(TeachingFileProperty.PatientSex)) {
                tableLayout.insertRow(n, -2.0);
                jPanel3.add((Component)this.labels.get(TeachingFileProperty.PatientSex), "0," + n);
                jPanel3.add((Component)this.patientSexLabel, "1," + n);
                ++n;
            }
            if (this.props.contains(TeachingFileProperty.PatientAge)) {
                tableLayout.insertRow(n, -2.0);
                jPanel3.add((Component)this.labels.get(TeachingFileProperty.PatientAge), "0," + n);
                jPanel3.add((Component)this.patientAgeLabel, "1," + n);
                ++n;
            }
            if (this.props.contains(TeachingFileProperty.PatientSpecies)) {
                tableLayout.insertRow(n, -2.0);
                jPanel3.add((Component)this.labels.get(TeachingFileProperty.PatientSpecies), "0," + n);
                jPanel3.add((Component)this.patientRaceLabel, "1," + n);
                ++n;
            }
        }
        if (this.props.contains(TeachingFileProperty.Purpose) || this.props.contains(TeachingFileProperty.Level) || this.props.contains(TeachingFileProperty.Category) || this.props.contains(TeachingFileProperty.Anatomy) || this.props.contains(TeachingFileProperty.Pathology) || this.props.contains(TeachingFileProperty.Diagnosis) && !this.isFreeTextProperty(TeachingFileProperty.Diagnosis) || this.props.contains(TeachingFileProperty.DifferentialDiagnosis) && !this.isFreeTextProperty(TeachingFileProperty.DifferentialDiagnosis) || this.props.contains(TeachingFileProperty.Findings) && !this.isFreeTextProperty(TeachingFileProperty.Findings) || this.props.contains(TeachingFileProperty.OrganSystems) && !this.isFreeTextProperty(TeachingFileProperty.OrganSystems)) {
            tableLayout = new TableLayout(new double[]{-2.0, -1.0}, new double[0]);
            tableLayout.setHGap(GUI.getScaledInt((int)5));
            tableLayout.setVGap(GUI.getScaledInt((int)5));
            n = 0;
            jPanel4 = SwingUtilities2.createPanel((Boolean)false, null);
            jPanel4.setLayout((LayoutManager)tableLayout);
            if (this.props.contains(TeachingFileProperty.Purpose)) {
                tableLayout.insertRow(n, -2.0);
                jPanel4.add((Component)this.labels.get(TeachingFileProperty.Purpose), "0," + n);
                jPanel4.add((Component)this.purposeLabel, "1," + n);
                ++n;
            }
            if (this.props.contains(TeachingFileProperty.Level)) {
                tableLayout.insertRow(n, -2.0);
                jPanel4.add((Component)this.labels.get(TeachingFileProperty.Level), "0," + n);
                jPanel4.add((Component)this.levelLabel, "1," + n);
                ++n;
            }
            if (this.props.contains(TeachingFileProperty.Category)) {
                tableLayout.insertRow(n, -2.0);
                jPanel4.add((Component)this.labels.get(TeachingFileProperty.Category), "0," + n);
                jPanel4.add((Component)this.categoryLabel, "1," + n);
                ++n;
            }
            if (this.props.contains(TeachingFileProperty.Anatomy)) {
                tableLayout.insertRow(n, -2.0);
                jPanel4.add((Component)this.labels.get(TeachingFileProperty.Anatomy), "0," + n);
                jPanel4.add((Component)this.anatomyLabel, "1," + n);
                ++n;
            }
            if (this.props.contains(TeachingFileProperty.Pathology)) {
                tableLayout.insertRow(n, -2.0);
                jPanel4.add((Component)this.labels.get(TeachingFileProperty.Pathology), "0," + n);
                jPanel4.add((Component)this.pathologyLabel, "1," + n);
                ++n;
            }
            if (this.props.contains(TeachingFileProperty.Diagnosis) && !this.isFreeTextProperty(TeachingFileProperty.Diagnosis)) {
                tableLayout.insertRow(n, -2.0);
                jPanel4.add((Component)this.labels.get(TeachingFileProperty.Diagnosis), "0," + n);
                jPanel4.add((Component)this.diagnosisLabel, "1," + n);
                ++n;
                if (this.props.contains(TeachingFileProperty.DiagnosisConfirmed)) {
                    tableLayout.insertRow(n, -2.0);
                    jPanel4.add((Component)this.labels.get(TeachingFileProperty.DiagnosisConfirmed), "0," + n);
                    jPanel4.add((Component)this.diagnosisConfirmedLabel, "1," + n);
                    ++n;
                }
            }
            if (this.props.contains(TeachingFileProperty.DifferentialDiagnosis) && !this.isFreeTextProperty(TeachingFileProperty.DifferentialDiagnosis)) {
                tableLayout.insertRow(n, -2.0);
                jPanel4.add((Component)this.labels.get(TeachingFileProperty.DifferentialDiagnosis), "0," + n);
                jPanel4.add((Component)this.diffDiagnosisLabel, "1," + n);
                ++n;
            }
            if (this.props.contains(TeachingFileProperty.Findings) && !this.isFreeTextProperty(TeachingFileProperty.Findings)) {
                tableLayout.insertRow(n, -2.0);
                jPanel4.add((Component)this.labels.get(TeachingFileProperty.Findings), "0," + n);
                jPanel4.add((Component)this.findingsLabel, "1," + n);
                ++n;
            }
            if (this.props.contains(TeachingFileProperty.OrganSystems) && !this.isFreeTextProperty(TeachingFileProperty.OrganSystems)) {
                tableLayout.insertRow(n, -2.0);
                jPanel4.add((Component)this.labels.get(TeachingFileProperty.OrganSystems), "0," + n);
                jPanel4.add((Component)this.organSystemsLabel, "1," + n);
                ++n;
            }
        }
        tableLayout = new TableLayout(new double[]{-2.0, -1.0}, new double[0]);
        tableLayout.setHGap(GUI.getScaledInt((int)5));
        tableLayout.setVGap(GUI.getScaledInt((int)5));
        n = 0;
        jPanel5 = SwingUtilities2.createPanel((Boolean)false, null);
        jPanel5.setLayout((LayoutManager)tableLayout);
        if (this.props.contains(TeachingFileProperty.CreatedOn)) {
            tableLayout.insertRow(n, -2.0);
            jPanel5.add((Component)this.labels.get(TeachingFileProperty.CreatedOn), "0," + n);
            jPanel5.add((Component)this.createdOnLabel, "1," + n);
            ++n;
        }
        tableLayout.insertRow(n, -2.0);
        jPanel5.add((Component)this.numberOfImagesKeyLabel, "0," + n);
        jPanel5.add((Component)this.numberOfImagesValueLabel, "1," + n);
        ++n;
        if (this.props.contains(TeachingFileProperty.AcquisitionModalities)) {
            tableLayout.insertRow(n, -2.0);
            jPanel5.add((Component)this.labels.get(TeachingFileProperty.AcquisitionModalities), "0," + n);
            jPanel5.add((Component)this.modalitiesLabel, "1," + n);
            ++n;
        }
        if (this.props.contains(TeachingFileProperty.Keywords)) {
            this.labels.get(TeachingFileProperty.Keywords).setVerticalAlignment(1);
            tableLayout.insertRow(n, -2.0);
            jPanel5.add((Component)this.labels.get(TeachingFileProperty.Keywords), "0," + n);
            jPanel5.add((Component)this.keywordsArea, "1," + n);
            ++n;
        }
        JPanel jPanel6 = null;
        JPanel jPanel7 = null;
        if (jPanel != null && jPanel2 != null) {
            jPanel6 = SwingUtilities2.createPanel((Boolean)Boolean.FALSE, null);
            jPanel6.setLayout(new BorderLayout(0, GUI.getScaledInt((int)40)));
            jPanel6.add((Component)jPanel, "North");
            jPanel6.add((Component)jPanel2, "Center");
        } else if (jPanel != null) {
            jPanel6 = jPanel;
        } else if (jPanel2 != null) {
            jPanel6 = jPanel2;
        }
        if (jPanel3 != null || jPanel4 != null) {
            boolean bl = false;
            jPanel7 = SwingUtilities2.createPanel((Boolean)Boolean.FALSE, null);
            jPanel7.setLayout((LayoutManager)new RowLayout(GUI.getScaledInt((int)5)));
            if (jPanel4 != null) {
                jPanel7.add(jPanel4);
                bl = true;
            }
            if (bl) {
                jPanel7.add((Component)SwingUtilities2.createSeparator((JSeparator2.SeparatorOrientation)JSeparator2.SeparatorOrientation.HORIZONTAL, (JSeparator2.SeparatorType)JSeparator2.SeparatorType.LINE, (Dimension)new Dimension(10, GUI.getScaledInt((int)30))));
            }
            jPanel7.add(jPanel5);
            bl = true;
            if (jPanel3 != null) {
                jPanel7.add((Component)SwingUtilities2.createSeparator((JSeparator2.SeparatorOrientation)JSeparator2.SeparatorOrientation.HORIZONTAL, (JSeparator2.SeparatorType)JSeparator2.SeparatorType.LINE, (Dimension)new Dimension(10, GUI.getScaledInt((int)30))));
                jPanel7.add(jPanel3);
            }
        }
        JPanel jPanel8 = null;
        if (jPanel6 != null) {
            TableLayout tableLayout2 = new TableLayout(new double[]{-1.0, -1.0}, new double[]{-1.0});
            tableLayout2.setHGap(GUI.getScaledInt((int)50));
            jPanel8 = SwingUtilities2.createPanel((Boolean)true, null);
            jPanel8.setLayout((LayoutManager)tableLayout2);
            jPanel8.add((Component)jPanel7, "0,0");
            jPanel8.add((Component)jPanel6, "1,0");
        } else {
            jPanel8 = jPanel7;
        }
        int n2 = GUI.getScaledInt((int)10);
        jPanel8.setBorder(BorderFactory.createEmptyBorder(n2, n2, n2, n2));
        return this.createScrollPane(jPanel8, false, false, 30, null);
    }

    private JComponent createDiagnosisTab() {
        if (this.props.contains(TeachingFileProperty.Diagnosis) && this.isFreeTextProperty(TeachingFileProperty.Diagnosis)) {
            return this.createScrollPane(this.diagnosisArea);
        }
        return null;
    }

    private JComponent createDifferentialDiagnosisTab() {
        if (this.props.contains(TeachingFileProperty.DifferentialDiagnosis) && this.isFreeTextProperty(TeachingFileProperty.DifferentialDiagnosis)) {
            return this.createScrollPane(this.diffDiagnosisArea);
        }
        return null;
    }

    private JComponent createFindingsTab() {
        if (this.props.contains(TeachingFileProperty.Findings) && this.isFreeTextProperty(TeachingFileProperty.Findings)) {
            return this.createScrollPane(this.findingsArea);
        }
        return null;
    }

    private JComponent createHistoryTab() {
        if (this.props.contains(TeachingFileProperty.History)) {
            return this.createScrollPane(this.historyArea);
        }
        return null;
    }

    private JComponent createOrganSystemsTab() {
        if (this.props.contains(TeachingFileProperty.OrganSystems) && this.isFreeTextProperty(TeachingFileProperty.OrganSystems)) {
            return this.createScrollPane(this.organSystemsArea);
        }
        return null;
    }

    private JComponent createDiscussionTab() {
        if (this.props.contains(TeachingFileProperty.Discussion)) {
            return this.createScrollPane(this.discussionArea);
        }
        return null;
    }

    private JComponent createBibliographyTab() {
        if (this.props.contains(TeachingFileProperty.BibliographicReferences)) {
            return this.createScrollPane(this.bibliographyList);
        }
        return null;
    }

    private JLabel createKeyLabel(TeachingFileProperty<?> teachingFileProperty) {
        return this.createKeyLabel(String.valueOf(teachingFileProperty.getName()) + ":");
    }

    private JLabel createKeyLabel(String string) {
        JLabel jLabel = SwingUtilities2.createLabel((String)string, null, null, null);
        jLabel.setForeground(UIManager.getColor("color.primary.3"));
        return jLabel;
    }

    private JLabel createValueLabel() {
        JLabel jLabel = new JLabel(){

            @Override
            public void setText(String string) {
                super.setText(string);
                this.setToolTipText(string);
            }
        };
        jLabel.setPreferredSize(new Dimension(GUI.getScaledInt((int)150), jLabel.getPreferredSize().height));
        return jLabel;
    }

    private JTextArea createValueArea(Color color, boolean bl) {
        JTextArea jTextArea = this.createValueArea(bl);
        jTextArea.setOpaque(true);
        return jTextArea;
    }

    private JTextArea createValueArea(boolean bl) {
        JTextArea jTextArea = new JTextArea(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setEnabled(false);
        jTextArea.setDisabledTextColor(Color.WHITE);
        if (bl) {
            int n = GUI.getScaledInt((int)5);
            jTextArea.setMargin(new Insets(n, n, n, n));
        }
        return jTextArea;
    }

    private JScrollPane createScrollPane(JComponent jComponent) {
        return this.createScrollPane(jComponent, false, true, 30, null);
    }

    private JScrollPane createScrollPane(JComponent jComponent, boolean bl, boolean bl2, int n, Dimension dimension) {
        JScrollPane jScrollPane = SwingUtilities2.createScrollPane((Component)jComponent, (Integer)20, (Integer)n, (Boolean)bl, (Boolean)bl2);
        if (dimension != null) {
            jScrollPane.setPreferredSize(dimension);
        }
        return jScrollPane;
    }

    private boolean isFreeTextProperty(TeachingFileProperty<?> teachingFileProperty) {
        if (String.class.isAssignableFrom(teachingFileProperty.getValueType().getValueClass())) {
            return true;
        }
        return IKeyword.class.isAssignableFrom(teachingFileProperty.getValueType().getValueClass()) && teachingFileProperty.getKeywordProvider() == null;
    }

    private String getTextValue(TeachingFile<TeachingFile.ObjectReference> teachingFile, TeachingFileProperty<?> teachingFileProperty) {
        if (teachingFile != null && teachingFile.hasValue(teachingFileProperty)) {
            Object[] objectArray = teachingFile.getValues(teachingFileProperty);
            if (objectArray == null || objectArray.length == 0) {
                if (!(!String.class.isAssignableFrom(teachingFileProperty.getValueType().getValueClass()) && this.isFreeTextProperty(teachingFileProperty) || TeachingFileProperty.Discussion.equals(teachingFileProperty) || TeachingFileProperty.History.equals(teachingFileProperty))) {
                    return "-";
                }
            } else if (TeachingFileProperty.PatientAge.equals(teachingFileProperty)) {
                Integer n = (Integer)teachingFile.getValue(TeachingFileProperty.PatientAge);
                if (n != null) {
                    int n2 = Math.max(n / 365, 0);
                    int n3 = (n - n2 * 365) / 30;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (n2 > 0) {
                        stringBuilder.append(Integer.toString(n2)).append(" ").append(Messages.getString("TeachingFileTextAreaView.Years.Text"));
                    }
                    if (n3 > 0) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(n3).append(" ").append(Messages.getString("TeachingFileTextAreaView.Months.Text"));
                    }
                    return stringBuilder.toString();
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                if (objectArray[0] instanceof Date) {
                    stringBuilder.append(DateTimeUtils.date2LongString((Date)((Date)objectArray[0])));
                } else {
                    stringBuilder.append(objectArray[0].toString());
                }
                int n = 1;
                while (n < objectArray.length) {
                    stringBuilder.append(" | ");
                    if (objectArray[n] instanceof Date) {
                        stringBuilder.append(DateTimeUtils.date2LongString((Date)((Date)objectArray[n])));
                    } else {
                        stringBuilder.append(objectArray[n].toString());
                    }
                    ++n;
                }
                return stringBuilder.toString();
            }
        }
        return null;
    }

    private static class BibliographyListCellRenderer
    extends JTextArea
    implements ListCellRenderer {
        private ItemBorder firstItemBorder = new ItemBorder(false);
        private ItemBorder defaultItemBorder = new ItemBorder(true);

        public BibliographyListCellRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBorder(n == 0 ? this.firstItemBorder : this.defaultItemBorder);
            this.setText(object != null ? object.toString() : null);
            this.setPreferredSize(new Dimension(jList.getWidth(), ItemBorder.margin * 2 + this.getLineCount() * GUI.getScaledInt((int)19)));
            return this;
        }

        private static class ItemBorder
        implements Border {
            public static final int margin = GUI.getScaledInt((int)8);
            private Insets insets = new Insets(margin, margin, margin, margin);
            private boolean topLine = false;

            public ItemBorder(boolean bl) {
                this.topLine = bl;
            }

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                if (this.topLine) {
                    Color color = graphics.getColor();
                    graphics.setColor(component.getBackground().brighter());
                    graphics.drawLine(n + this.insets.left, n2, n + n3 - this.insets.right, n2);
                    graphics.setColor(color);
                }
            }

            @Override
            public Insets getBorderInsets(Component component) {
                return this.insets;
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        }
    }
}

