/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.about;

import com.agfa.pacs.listtext.lta.base.about.About;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.StreamUtil;
import com.agfa.pacs.tools.TempDirectoryProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Bundle;

public class LicenseMapFactory {
    public static final ALogger log = ALogger.getLogger(LicenseMapFactory.class);
    private static final String SEARCHSTRING = "thirdparty";

    public static Map<String, List<URL>> createLicenseMap(About about) {
        TreeMap<String, List<URL>> treeMap = new TreeMap<String, List<URL>>();
        for (BundleDescription bundleDescription : about.getInstalledBundles()) {
            Enumeration enumeration;
            Bundle bundle;
            if (bundleDescription.getName() == null || !bundleDescription.getName().contains(SEARCHSTRING) || (bundle = Platform.getBundle((String)bundleDescription.getName())) == null || (enumeration = bundle.findEntries("/", "LICENSE*.txt", true)) == null) continue;
            LinkedList<URL> linkedList = new LinkedList<URL>();
            while (enumeration.hasMoreElements()) {
                linkedList.add((URL)enumeration.nextElement());
            }
            String string = bundle.getHeaders().get("Bundle-Name").toString();
            string = string.replace(" ", "&nbsp;");
            treeMap.put(string, linkedList);
        }
        return treeMap;
    }

    public static File createMergedLicenseFile(Map.Entry<String, List<URL>> entry) {
        File file = null;
        String string = "line.separator";
        try {
            file = TempDirectoryProvider.createTemporaryFile((String)"LICENSE", (String)".txt");
            file.deleteOnExit();
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileWriter fileWriter = new FileWriter(file);){
                for (URL uRL : entry.getValue()) {
                    InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
                    String string2 = StreamUtil.readStream((Reader)inputStreamReader);
                    fileWriter.write(string2);
                    fileWriter.write(System.getProperty(string));
                    fileWriter.write(System.getProperty(string));
                    fileWriter.write(System.getProperty(string));
                    fileWriter.write(System.getProperty(string));
                    fileWriter.write(System.getProperty(string));
                    inputStreamReader.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("Error on merging license files", (Throwable)iOException);
        }
        return file;
    }
}

