/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.about.plaf.basic;

import com.agfa.pacs.listtext.swingx.impl.BackgroundFader;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class BackgroundPanel
extends JPanel {
    private final BackgroundFader fader;
    private boolean isBackgroundImageInitializationPending = true;

    BackgroundPanel(JLabel jLabel) {
        this.fader = new BackgroundFader((Component)this, new Component[]{jLabel});
        if (jLabel != null) {
            jLabel.setText(" \"Nautilus\"");
        }
        BackgroundImageWindowListener backgroundImageWindowListener = new BackgroundImageWindowListener();
        this.addMouseListener(backgroundImageWindowListener);
        this.addMouseMotionListener(backgroundImageWindowListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isBackgroundImageInitializationPending) {
            this.fader.setBackgroundImageHeight(this.getHeight());
            this.fader.setBackgroundImageLocation(this.getWidth(), 0, 4, 1);
            this.isBackgroundImageInitializationPending = false;
        }
        this.fader.paintBackground(graphics);
    }

    private class BackgroundImageWindowListener
    extends MouseAdapter {
        private float startY = Float.NaN;
        private float startAlpha;

        private BackgroundImageWindowListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 2) {
                this.startY = mouseEvent.getY();
                this.startAlpha = BackgroundPanel.this.fader.getAlpha();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.startY = Float.NaN;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!Float.isNaN(this.startY)) {
                BackgroundPanel.this.fader.setAlpha(this.startAlpha + (this.startY - (float)mouseEvent.getY()) / 512.0f);
            }
        }
    }
}

