/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect;

import com.agfa.hap.pacs.impaxee.data.AuthenticationData;
import com.agfa.hap.pacs.impaxee.studyshare.AbstractStudyShareConfig;
import com.agfa.hap.pacs.impaxee.studyshare.IStudySharePDFOptions;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareSettings;
import com.agfa.hap.pacs.impaxee.studyshare.StudySharePermission;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.URLProviderFactory;
import java.util.Calendar;
import java.util.Date;

public class StudyShareConfig
extends AbstractStudyShareConfig {
    private static final StudyShareConfig INSTANCE = new StudyShareConfig();
    private static final IConfigurationProvider CONFIG = ConfigurationProviderFactory.getConfig().getNode("listtext.lta.base.connect");
    private static IStudyShareSettings DEFAULT_SETTINGS = new DefaultStudyShareSettings();

    private StudyShareConfig() {
    }

    public static StudyShareConfig getInstance() {
        return INSTANCE;
    }

    public boolean isSeparateArchiveUsed() {
        return CONFIG.getBoolean("useSeparateArchive");
    }

    public String getDestinationAET() {
        return CONFIG.getString("aet");
    }

    public String getInternalURL() {
        return CONFIG.getString("internalURL");
    }

    public String getExternalBaseURL() {
        return CONFIG.getString("externalBaseURL");
    }

    protected AuthenticationData getAuthenticationData() {
        String string;
        String string2;
        if (CONFIG.getBoolean("authentication.isReuseEnabled")) {
            string2 = URLProviderFactory.getProvider().getLoginInformation().getUserID();
            string = URLProviderFactory.getProvider().getLoginInformation().getPassword();
        } else {
            string2 = CONFIG.getString("authentication.user");
            string = CONFIG.getString("authentication.password");
        }
        return new AuthenticationData(string2, string);
    }

    protected String getUserIdImpl() {
        return CONFIG.getString("userId");
    }

    static IStudyShareSettings getDefaultSettings() {
        return DEFAULT_SETTINGS;
    }

    static boolean isQRCodeEnabledByDefault() {
        return CONFIG.getBoolean("isQRCodeEnabled");
    }

    static boolean isPrintEnabled() {
        return CONFIG.getBoolean("isPrintEnabled");
    }

    static String getDefaultDepartmentName() {
        return ConfigurationProviderFactory.getConfig().getString("listtext.import.departmentName");
    }

    static IStudySharePDFOptions.PatientIdentificationType getDefaultPatientIdentificationType() {
        return IStudySharePDFOptions.PatientIdentificationType.valueOf((String)CONFIG.getString("patientIdentificationType"));
    }

    private static class DefaultStudyShareSettings
    implements IStudyShareSettings {
        private static final ALogger LOGGER = ALogger.getLogger(DefaultStudyShareSettings.class);

        private DefaultStudyShareSettings() {
        }

        private int getDefaultExpirationDuration() {
            return (int)CONFIG.getLong("defaultExpiration");
        }

        public Date getExpirationDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, this.getDefaultExpirationDuration());
            return calendar.getTime();
        }

        public StudySharePermission getPermission() {
            StudySharePermission studySharePermission = StudySharePermission.VIEW;
            try {
                studySharePermission = StudySharePermission.valueOf((String)CONFIG.getString("defaultPermission"));
            }
            catch (Exception exception) {
                LOGGER.error("Reading default share study permission from config failed.", (Throwable)exception);
            }
            return studySharePermission;
        }
    }
}

