/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect;

import com.agfa.hap.pacs.impaxee.studyshare.IPermissionTask;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareData;
import com.agfa.hap.pacs.impaxee.studyshare.IStudyShareSettings;
import com.agfa.hap.pacs.impaxee.studyshare.StudyShareFailureType;
import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.AbstractStudyShareAction;
import com.agfa.pacs.listtext.lta.base.connect.CreatePDFAction;
import com.agfa.pacs.listtext.lta.base.connect.IStudyShareAction;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareChangeAction;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareCreationAction;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareMessages;
import com.agfa.pacs.listtext.lta.base.connect.StudySharePermissionOptions;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareRevokeAction;
import com.agfa.pacs.listtext.lta.base.connect.task.PermissionTaskFactory;
import com.agfa.pacs.listtext.swingx.layout.FlowLayout2;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.Pattern;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class StudyShareQueryAction
extends AbstractStudyShareAction {
    private static final String DESCRIPTION = Messages.getString("StudyShareQueryAction.Description");
    private static final ALogger LOGGER = ALogger.getLogger(StudyShareQueryAction.class);

    public StudyShareQueryAction(IComponentFactory iComponentFactory) {
        super(iComponentFactory);
    }

    @Override
    public String getName() {
        return DESCRIPTION;
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    void performImpl(Component component, List<IStudyInfo> list) {
        boolean bl;
        IPermissionTask iPermissionTask;
        block10: {
            CursorUtil.setWaitCursor((Component)component);
            iPermissionTask = PermissionTaskFactory.createPermissionQueryTask(list);
            bl = false;
            try {
                try {
                    bl = iPermissionTask.execute();
                }
                catch (Exception exception) {
                    LOGGER.error("Querying study share permissions failed.", (Throwable)exception);
                    if (CursorUtil.isWaitCursor((Component)component)) {
                        CursorUtil.resetWaitCursor((Component)component);
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (CursorUtil.isWaitCursor((Component)component)) {
                    CursorUtil.resetWaitCursor((Component)component);
                }
                throw throwable;
            }
            if (CursorUtil.isWaitCursor((Component)component)) {
                CursorUtil.resetWaitCursor((Component)component);
            }
        }
        if (bl) {
            this.showQueryResult(component, list, iPermissionTask);
        } else {
            this.informUserOfFailure(component, iPermissionTask.getFailureType());
        }
    }

    private void showQueryResult(Component component, List<IStudyInfo> list, IPermissionTask iPermissionTask) {
        if (IStudyShareData.NONE.equals(iPermissionTask.getResult())) {
            this.showUnsharedData(component, list);
        } else {
            this.showSharingInformation(component, list, iPermissionTask);
        }
    }

    private void showUnsharedData(Component component, List<IStudyInfo> list) {
        JPanel jPanel = this.componentFactory.createPanel((LayoutManager)new FlowLayout2(1, 0));
        String string = Messages.getString("StudyShareQueryAction.SettingsPanel.NoStudyShare.Message");
        String[] stringArray = Pattern.NEWLINE.split(string);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            jPanel.add(this.componentFactory.createLabel(string2));
            ++n2;
        }
        this.showQueryResultDialog(component, list, jPanel, new StudyShareCreationAction(this.componentFactory), new CloseAction());
    }

    private void showSharingInformation(Component component, List<IStudyInfo> list, IPermissionTask iPermissionTask) {
        StudySharePermissionOptions studySharePermissionOptions = new StudySharePermissionOptions(this.componentFactory, (IStudyShareSettings)iPermissionTask.getResult(), false);
        this.showQueryResultDialog(component, list, studySharePermissionOptions, new CreatePDFAction(this.componentFactory, iPermissionTask), new StudyShareChangeAction(this.componentFactory, iPermissionTask), new StudyShareRevokeAction(this.componentFactory, iPermissionTask), new CloseAction());
    }

    private void showQueryResultDialog(Component component, List<IStudyInfo> list, JPanel jPanel, IStudyShareAction ... iStudyShareActionArray) {
        jPanel.setBorder(this.componentFactory.createTitledBorder(Messages.getString("StudyShareQueryAction.SettingsPanel.Title")));
        JDialog jDialog = new JDialog(JOptionPane.getFrameForComponent(component), DESCRIPTION, true);
        jDialog.setDefaultCloseOperation(2);
        jDialog.setLayout(new BorderLayout());
        JPanel jPanel2 = this.componentFactory.createPanel((LayoutManager)new FlowLayout(1, this.componentFactory.scaleInt(6), 0));
        IStudyShareAction[] iStudyShareActionArray2 = iStudyShareActionArray;
        int n = iStudyShareActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStudyShareAction iStudyShareAction = iStudyShareActionArray2[n2];
            jPanel2.add(this.componentFactory.createButton((Action)new DialogAction(jDialog, iStudyShareAction, list)));
            ++n2;
        }
        int n3 = this.componentFactory.scaleInt(15);
        JPanel jPanel3 = this.createDialog(list, jPanel, jPanel2);
        jPanel3.setBorder(new EmptyBorder(n3, n3, n3, n3));
        jDialog.add((Component)jPanel3, "Center");
        jDialog.pack();
        this.componentFactory.centerOnOwner((Window)jDialog);
        jDialog.setVisible(true);
    }

    private void informUserOfFailure(Component component, StudyShareFailureType studyShareFailureType) {
        String string = StudyShareMessages.getString(studyShareFailureType);
        if (string == null) {
            string = Messages.getString("StudyShareQueryAction.Failure.Message");
        }
        this.showErrorDialog(Messages.getString("StudyShareQueryAction.Failure.Title"), string, component);
    }

    private static class CloseAction
    implements IStudyShareAction {
        private CloseAction() {
        }

        @Override
        public String getName() {
            return Messages.getString("Close");
        }

        @Override
        public String getDescription() {
            return Messages.getString("StudyShare.CloseAction.Description");
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void perform(Component component, List<IStudyInfo> list) {
        }
    }

    private static class DialogAction
    extends AbstractAction {
        private final JDialog dialog;
        private final IStudyShareAction action;
        private final List<IStudyInfo> studies;

        public DialogAction(JDialog jDialog, IStudyShareAction iStudyShareAction, List<IStudyInfo> list) {
            super(iStudyShareAction.getName());
            this.dialog = jDialog;
            this.action = iStudyShareAction;
            this.studies = list;
            this.putValue("ShortDescription", iStudyShareAction.getDescription());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.setVisible(false);
            this.action.perform(this.dialog.getOwner(), this.studies);
        }
    }
}

