/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.task;

import com.agfa.pacs.background.IBackgroundProgress;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.task.ITaskTerminationListener;
import com.agfa.pacs.listtext.lta.base.connect.task.SingleCMoveTask;
import com.agfa.pacs.listtext.lta.store.StoreUtils;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.dcm4che3.util.UIDUtils;

class CombinedCMoveTask
implements IBackgroundTask,
ITaskTerminationListener {
    private String uid = UIDUtils.createUID();
    private static final ALogger LOGGER = ALogger.getLogger(CombinedCMoveTask.class);
    private static final String NAME = Messages.getString("StudyShare.CMoveTask.Name");
    private final Collection<SingleCMoveTask> tasks;
    private final CountDownLatch terminationLatch;
    private IBackgroundProgress listener;

    CombinedCMoveTask(String string, List<IStudyInfo> list) {
        Map<IDicomNode, List<IStudyInfo>> map = CombinedCMoveTask.groupByDicomNode(list);
        int n = map.size();
        this.tasks = new ArrayList<SingleCMoveTask>(n);
        this.terminationLatch = new CountDownLatch(n);
        for (Map.Entry<IDicomNode, List<IStudyInfo>> entry : map.entrySet()) {
            this.tasks.add(new SingleCMoveTask(entry.getKey(), string, entry.getValue(), this));
        }
    }

    private static Map<IDicomNode, List<IStudyInfo>> groupByDicomNode(List<IStudyInfo> list) {
        HashMap<IDicomNode, List<IStudyInfo>> hashMap = new HashMap<IDicomNode, List<IStudyInfo>>();
        for (IStudyInfo iStudyInfo : list) {
            IDicomNode iDicomNode = StoreUtils.findSourceDicomNode((IDataInfoSource)iStudyInfo.getSource());
            if (iDicomNode == null) {
                throw new IllegalArgumentException("Unknown source node for study: " + iStudyInfo);
            }
            ArrayList<IStudyInfo> arrayList = (ArrayList<IStudyInfo>)hashMap.get(iDicomNode);
            if (arrayList == null) {
                arrayList = new ArrayList<IStudyInfo>();
                hashMap.put(iDicomNode, arrayList);
            }
            arrayList.add(iStudyInfo);
        }
        return hashMap;
    }

    public String getInfo() {
        return NAME;
    }

    public boolean execute() {
        int n = 0;
        for (Runnable runnable : this.tasks) {
            new Thread(runnable, "CMove-Thread-" + ++n).start();
        }
        try {
            this.terminationLatch.await();
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn("Waiting for end of C-Move interrupted.", (Throwable)interruptedException);
        }
        for (SingleCMoveTask singleCMoveTask : this.tasks) {
            if (singleCMoveTask.isSuccessful()) continue;
            return false;
        }
        if (this.listener != null) {
            this.listener.progress(1.0);
        }
        return true;
    }

    public void terminate() {
    }

    public void take(IBackgroundProgress iBackgroundProgress) {
        this.listener = iBackgroundProgress;
    }

    @Override
    public void onTaskFinish() {
        this.terminationLatch.countDown();
        this.listener.progress((double)this.terminationLatch.getCount() / (double)this.tasks.size());
    }

    public String getUID() {
        return this.uid;
    }
}

