/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.task;

import com.agfa.hap.pacs.impaxee.studyshare.IPermissionTask;
import com.agfa.hap.pacs.impaxee.studyshare.IStudySharePDFOptions;
import com.agfa.hap.pacs.impaxee.studyshare.StudySharePermission;
import com.agfa.hap.pacs.impaxee.studyshare.task.AbstractPDFCreationTask;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareMessages;
import com.agfa.pacs.tools.TempDirectoryProvider;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class PDFCreationTask
extends AbstractPDFCreationTask<File> {
    public static final String NAME = Messages.getString("StudyShare.PDFCreationTask.Name");
    private static File webAccessTmpDir;

    PDFCreationTask(IPermissionTask iPermissionTask, IStudySharePDFOptions iStudySharePDFOptions) {
        super(iPermissionTask, iStudySharePDFOptions);
    }

    protected File createResult(String string) throws IOException {
        File file;
        if (webAccessTmpDir == null) {
            webAccessTmpDir = TempDirectoryProvider.createTempDirectory((String)"webaccess").toFile();
        }
        if (string == null) {
            file = File.createTempFile("external-access-", ".pdf", webAccessTmpDir);
        } else {
            file = new File(webAccessTmpDir, string);
            if (file.exists()) {
                webAccessTmpDir = TempDirectoryProvider.createTempDirectory((String)"webaccess").toFile();
                file = new File(webAccessTmpDir, string);
            }
        }
        return file;
    }

    protected OutputStream createOutputStream(File file) throws IOException {
        return Files.newOutputStream(file.toPath(), new OpenOption[0]);
    }

    protected String getString(StudySharePermission studySharePermission) {
        return StudyShareMessages.getString(studySharePermission);
    }
}

