/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.task;

import com.agfa.pacs.base.ProgressState;
import com.agfa.pacs.data.export.DicomCMove;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.SimpleDicomNode;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.task.ITaskTerminationListener;
import com.agfa.pacs.listtext.lta.progress.ProgressManagerFactory;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import com.agfa.pacs.logging.ALogger;
import java.util.List;

class SingleCMoveTask
implements Runnable {
    private static final ALogger LOGGER = ALogger.getLogger(SingleCMoveTask.class);
    private static final String NAME = Messages.getString("StudyShare.CMoveTask.Name");
    private final IDicomNode sourceNode;
    private final String destinationAET;
    private final List<IStudyInfo> studies;
    private final ITaskTerminationListener listener;
    private boolean isSuccessful;

    SingleCMoveTask(IDicomNode iDicomNode, String string, List<IStudyInfo> list, ITaskTerminationListener iTaskTerminationListener) {
        this.sourceNode = iDicomNode;
        this.destinationAET = string;
        this.studies = list;
        this.listener = iTaskTerminationListener;
    }

    @Override
    public void run() {
        try {
            this.isSuccessful = this.execute();
        }
        finally {
            this.listener.onTaskFinish();
        }
    }

    boolean isSuccessful() {
        return this.isSuccessful;
    }

    private boolean execute() {
        DicomCMove.MoveResult moveResult;
        ProgressStateModel progressStateModel;
        block4: {
            progressStateModel = ProgressManagerFactory.getManager().createAndAddProgress(NAME, this.destinationAET, this.studies);
            moveResult = DicomCMove.moveInstancesSync((IDicomNode)this.sourceNode, (IDicomNode)new SimpleDicomNode(null, 0, this.destinationAET, null), this.studies, (ProgressState)progressStateModel);
            if (moveResult != DicomCMove.MoveResult.MOVE_SUCCESSFUL) break block4;
            progressStateModel.setState(JobState.FINISHED);
            return true;
        }
        try {
            if (moveResult == DicomCMove.MoveResult.MOVE_NOT_CONFIGURED) {
                LOGGER.error("Unknown destination AE Title: " + this.destinationAET);
            }
        }
        catch (Exception exception) {
            LOGGER.error("C-Move to Connect archive failed.", (Throwable)exception);
            progressStateModel.setStateMessage(exception.getLocalizedMessage());
        }
        progressStateModel.setState(JobState.FAILED);
        return false;
    }
}

