/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.dicominfo;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.dicominfo.TagsTableModel;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public class CompareTagsTableModel
extends TagsTableModel {
    private static final long serialVersionUID = 1L;
    private int objects;
    private boolean showDiffs;

    public CompareTagsTableModel(List<Attributes> list, boolean bl, IComponentFactory iComponentFactory) {
        super(iComponentFactory);
        this.columnNames = new String[]{Messages.getString("DcmInfoSetDlg.GroupElement"), Messages.getString("DcmInfoSetDlg.Description")};
        this.showDiffs = bl;
        this.objects = this.showDiffs ? list.size() : 1;
        this.evalDataset(list, 0);
    }

    private void evalDataset(List<Attributes> list, int n) {
        int n2;
        Object object;
        Attributes attributes2;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Attributes attributes2 : list) {
            object = attributes2.tags();
            int[] nArray = object;
            int n3 = ((int[])object).length;
            int n4 = 0;
            while (n4 < n3) {
                n2 = nArray[n4];
                if (attributes2.containsValue(n2) && n2 != 2145386512 && ElementDictionary.vrOf((int)n2, null) != VR.SQ && attributes2.getVR(n2) != VR.SQ) {
                    hashSet.add(n2);
                }
                ++n4;
            }
        }
        attributes2 = hashSet.iterator();
        while (attributes2.hasNext()) {
            int n5 = (Integer)attributes2.next();
            if (!(this.areDifferent(list, n5) ^ this.showDiffs)) continue;
            attributes2.remove();
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            String string;
            Integer n6 = (Integer)object.next();
            n2 = 1;
            if ((n6 & 0x10000) != 0) {
                n2 |= 2;
            }
            if ((string = TagUtils.groupNumber((int)n6) == 65535 ? TagDictionary.getInstance().getPrivateTag(n6).getDescription() : Dcm4cheUtils.getStandardNameForTag((int)n6)) == null) {
                string = "";
            }
            String[] stringArray = new String[this.objects];
            int n7 = 0;
            while (n7 < this.objects) {
                Attributes attributes3 = list.get(n7);
                stringArray[n7] = CompareTagsTableModel.isSequence(attributes3, n6) ? "[" + Messages.getString("DcmInfoSetDlg.ThisIsASequence") + "]" : (attributes3.containsValue(n6.intValue()) ? this.getData(n6, attributes3) : "[" + Messages.getString("DcmInfoSetDlg.None") + "]");
                ++n7;
            }
            this.addTagEntry(new TagsTableModel.TagEntry(n, n6, string, stringArray, n2));
        }
    }

    private String getData(int n, Attributes attributes) {
        int n2;
        int n3;
        int[] nArray;
        Object[] objectArray;
        StringBuilder stringBuilder;
        String string = null;
        VR vR = TagUtils.groupNumber((int)n) == 65535 ? VR.LT : ElementDictionary.vrOf((int)n, null);
        if (vR == VR.OB || vR == VR.OW || vR == VR.OF || vR == VR.UN) {
            string = CompareTagsTableModel.getBytesAsString(attributes, n);
        }
        if (vR == VR.AT) {
            stringBuilder = new StringBuilder();
            nArray = objectArray = attributes.getInts(n);
            n3 = objectArray.length;
            n2 = 0;
            while (n2 < n3) {
                int n4 = nArray[n2];
                stringBuilder.append("[");
                stringBuilder.append(TagUtils.toString((int)n4));
                stringBuilder.append(" ");
                stringBuilder.append(ElementDictionary.keywordOf((int)n4, null));
                stringBuilder.append("]");
                ++n2;
            }
            string = stringBuilder.toString();
        }
        if (string == null) {
            try {
                stringBuilder = new StringBuilder();
                nArray = objectArray = (Object[])attributes.getStrings(n);
                n3 = objectArray.length;
                n2 = 0;
                while (n2 < n3) {
                    int n5 = nArray[n2];
                    stringBuilder.append((String)n5);
                    stringBuilder.append("\\");
                    ++n2;
                }
                if (objectArray.length > 0) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                string = stringBuilder.toString();
            }
            catch (Exception exception) {
                log.error("TagsTabelModel  " + vR, (Throwable)exception);
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean areDifferent(List<Attributes> list, Integer n) {
        try {
            Object object2;
            for (Object object2 : list) {
                if (object2.containsValue(n.intValue())) continue;
                return true;
            }
            object2 = list.get(0).getBytes(n.intValue());
            int n2 = 1;
            while (n2 < list.size()) {
                byte[] byArray = list.get(n2).getBytes(n.intValue());
                if (((Attributes)object2).length != byArray.length) {
                    return true;
                }
                int n3 = 0;
                while (n3 < ((Attributes)object2).length) {
                    if (object2[n3] != byArray[n3]) {
                        return true;
                    }
                    ++n3;
                }
                ++n2;
            }
            return false;
        }
        catch (IOException iOException) {
            ALogger.getLogger(CompareTagsTableModel.class).error("Bulk error", (Throwable)iOException);
            return false;
        }
    }

    @Override
    public String getColumnName(int n) {
        if (n < this.columnNames.length) {
            return this.columnNames[n];
        }
        if (this.showDiffs) {
            return String.valueOf(Messages.getString("DcmInfoSetDlg.Data")) + " " + (n - this.columnNames.length + 1);
        }
        return Messages.getString("DcmInfoSetDlg.SameData");
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length + this.objects;
    }
}

