/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.dirwatcher;

import com.agfa.pacs.base.dirwatcher.IDirectoryWatcher;
import com.agfa.pacs.base.dirwatcher.IDirectoryWatcherListener;
import com.agfa.pacs.data.shared.store.ISendNode;
import com.agfa.pacs.listtext.integration.dirwatcher.AbstractDirectoryScanner;
import com.agfa.pacs.logging.ALogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

final class AdvancedDirectoryScanner
extends AbstractDirectoryScanner {
    private static final ALogger log = ALogger.getLogger(AdvancedDirectoryScanner.class);
    private final Path path;
    private final Timer timer;
    private final WatchService watchService;
    private final WatchKey watchKey;
    private Set<String> existing = new HashSet<String>();
    private volatile WatcherTimerTask task;
    private volatile boolean isCanceling;

    AdvancedDirectoryScanner(String string, IDirectoryWatcherListener iDirectoryWatcherListener, IDirectoryWatcher.WatcherAction watcherAction, ISendNode iSendNode, boolean bl) throws IOException {
        super(string, iDirectoryWatcherListener, watcherAction, iSendNode);
        this.path = Paths.get(string, new String[0]);
        if (bl) {
            this.scan(Arrays.asList(this.getFiles()), 0L);
        }
        this.timer = new Timer("DirectoryWatcherTimerThread", true);
        this.watchService = FileSystems.getDefault().newWatchService();
        this.watchKey = this.path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        new WatcherThread().start();
    }

    void cancel() {
        this.isCanceling = true;
        try {
            this.watchService.close();
        }
        catch (IOException iOException) {
            log.error("Failed to close watch service", (Throwable)iOException);
        }
        this.watchKey.cancel();
        this.timer.cancel();
    }

    private List<File> scan(Collection<File> collection, long l) {
        boolean bl = l <= 0L;
        ArrayList<File> arrayList = new ArrayList<File>(collection);
        ArrayList<File> arrayList2 = new ArrayList<File>();
        while (true) {
            ArrayList<File> arrayList3 = arrayList;
            arrayList = new ArrayList();
            long l2 = new Date().getTime();
            for (File file : arrayList3) {
                Serializable serializable;
                if (!file.exists() || file.isDirectory()) continue;
                if (this.existing.contains(file.getAbsolutePath())) {
                    file.deleteOnExit();
                    continue;
                }
                if (l2 - l < file.lastModified()) {
                    arrayList.add(file);
                    if (!log.isDebugEnabled()) continue;
                    serializable = new StringBuilder();
                    ((StringBuilder)serializable).append("Too young file: ");
                    ((StringBuilder)serializable).append(file.getName());
                    ((StringBuilder)serializable).append(" (");
                    ((StringBuilder)serializable).append(l2 - file.lastModified());
                    ((StringBuilder)serializable).append("ms old)");
                    log.debug(((StringBuilder)serializable).toString());
                    continue;
                }
                try {
                    serializable = null;
                    Object var13_14 = null;
                    try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                        boolean bl2 = this.isDicom(bufferedInputStream);
                        this.existing.add(file.getAbsolutePath());
                        if (!bl2) continue;
                        arrayList2.add(file);
                    }
                    catch (Throwable throwable) {
                        if (serializable == null) {
                            serializable = throwable;
                        } else if (serializable != throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                        throw serializable;
                    }
                }
                catch (Exception exception) {
                    log.warn("File cannot be opened: " + file.getAbsolutePath(), (Throwable)exception);
                }
            }
            if (arrayList.isEmpty() || bl) {
                return arrayList2;
            }
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                log.debug("interrupted", (Throwable)interruptedException);
                continue;
            }
            break;
        }
    }

    synchronized void performCheck(Collection<File> collection, long l) {
        List<File> list = this.scan(collection, l);
        this.handleNewFiles(list);
    }

    private static <T> WatchEvent<T> cast(WatchEvent<?> watchEvent) {
        return watchEvent;
    }

    private class WatcherThread
    extends Thread {
        WatcherThread() throws IOException {
            super("WatchKeyListenerThread");
            this.setPriority(1);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!AdvancedDirectoryScanner.this.isCanceling) {
                WatchKey watchKey;
                try {
                    watchKey = AdvancedDirectoryScanner.this.watchService.take();
                }
                catch (InterruptedException interruptedException) {
                    log.warn("Directory watcher thread interrupted.", (Throwable)interruptedException);
                    continue;
                }
                catch (ClosedWatchServiceException closedWatchServiceException) {
                    log.warn("Directory watcher thread has been closed.");
                    continue;
                }
                if (AdvancedDirectoryScanner.this.isCanceling) break;
                if (!AdvancedDirectoryScanner.this.watchKey.equals(watchKey)) {
                    log.warn("Unknown WatchKey: " + watchKey);
                    continue;
                }
                HashSet<File> hashSet = new HashSet<File>();
                if (AdvancedDirectoryScanner.this.task != null) {
                    AdvancedDirectoryScanner.this.task.cancel();
                    hashSet.addAll(((AdvancedDirectoryScanner)AdvancedDirectoryScanner.this).task.files);
                    AdvancedDirectoryScanner.this.task = null;
                }
                for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                    Object object;
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Watch event overflow, need to check ALL files in '");
                        ((StringBuilder)object).append(AdvancedDirectoryScanner.this.getDirectoryPath());
                        ((StringBuilder)object).append("' ...");
                        log.warn(((StringBuilder)object).toString());
                        File[] fileArray = AdvancedDirectoryScanner.this.getFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            hashSet.add(file);
                            ++n2;
                        }
                        continue;
                    }
                    object = AdvancedDirectoryScanner.cast(watchEvent);
                    hashSet.add(AdvancedDirectoryScanner.this.path.resolve((Path)object.context()).toFile());
                }
                if (!AdvancedDirectoryScanner.this.isCanceling && !hashSet.isEmpty()) {
                    AdvancedDirectoryScanner.this.task = new WatcherTimerTask(hashSet);
                    AdvancedDirectoryScanner.this.timer.schedule((TimerTask)AdvancedDirectoryScanner.this.task, 3500L);
                }
                if (watchKey.reset()) continue;
                log.warn("Watch key no longer valid, aborting: " + (Object)((Object)AdvancedDirectoryScanner.this));
                break;
            }
        }
    }

    private class WatcherTimerTask
    extends TimerTask {
        final Collection<File> files;

        public WatcherTimerTask(Collection<File> collection) {
            this.files = collection;
        }

        @Override
        public void run() {
            AdvancedDirectoryScanner.this.task = null;
            AdvancedDirectoryScanner.this.performCheck(this.files, 3500L);
        }
    }
}

