/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.help;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.listtext.lta.base.help.IHelpModule;
import java.util.List;
import java.util.Vector;

public abstract class HelpModuleFactory {
    private static HelpModuleFactory implementation;

    public static synchronized HelpModuleFactory getInstance() {
        if (implementation == null) {
            HelpModuleFactory.initialize();
        }
        return implementation;
    }

    public List<IHelpModule> getDisplayOrderedHelpModules() {
        return this.getDisplayOrderedModules(implementation.getHelpModulesInt());
    }

    protected abstract List<IHelpModule> getHelpModulesInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)HelpModuleFactory.class.getName()));
            implementation = (HelpModuleFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException2) {
            reflectiveOperationException = reflectiveOperationException2;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + HelpModuleFactory.class.getName(), reflectiveOperationException);
        }
    }

    private List<IHelpModule> getDisplayOrderedModules(Iterable<IHelpModule> iterable) {
        Vector<IHelpModule> vector = new Vector<IHelpModule>();
        for (IHelpModule iHelpModule : iterable) {
            if (vector.isEmpty()) {
                vector.addElement(iHelpModule);
                continue;
            }
            int n = 0;
            for (IHelpModule iHelpModule2 : vector) {
                if (iHelpModule2.getDisplayOrderPriority() <= iHelpModule.getDisplayOrderPriority()) break;
                ++n;
            }
            vector.insertElementAt(iHelpModule, n);
        }
        return vector;
    }
}

