/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.orbis;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.ILoginData;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.tools.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class OrbisHttpClient {
    private static final ALogger log = ALogger.getLogger(OrbisHttpClient.class);
    private static final String ORBIS_SERVICE_BASE = "listtext.service.orbis.";
    private static final String ORBIS_SERVICE_USE_LOGIN_USER = "listtext.service.orbis.useLoginUser";
    private static final String ORBIS_SERVICE_USERNAME = "listtext.service.orbis.username";
    private static final String ORBIS_SERVICE_PASSWORD = "listtext.service.orbis.password";
    private static final String ORBIS_SERVICE_DISABLE_CERTIFICATE_CHECK = "listtext.service.orbis.disableCertificateCheck";
    private static final String ORBIS_SERVICE_DISABLE_HOSTNAME_CHECK = "listtext.service.orbis.disableHostnameCheck";
    private String username;
    private String password;
    private boolean disableCertificateCheck;
    private boolean disableHostnameCheck;
    private OrbisContentTypes contentType = OrbisContentTypes.UNDEFINED;
    private int lastResponseCode = -1;

    public OrbisHttpClient() {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        if (iConfigurationProvider.getBoolean(ORBIS_SERVICE_USE_LOGIN_USER)) {
            ILoginData iLoginData = URLProviderFactory.getProvider().getLoginInformation();
            this.username = iLoginData.getUserID();
            this.password = iLoginData.getPassword();
        } else {
            this.username = iConfigurationProvider.getString(ORBIS_SERVICE_USERNAME);
            this.password = iConfigurationProvider.getString(ORBIS_SERVICE_PASSWORD);
        }
        this.disableCertificateCheck = iConfigurationProvider.getBoolean(ORBIS_SERVICE_DISABLE_CERTIFICATE_CHECK);
        this.disableHostnameCheck = iConfigurationProvider.getBoolean(ORBIS_SERVICE_DISABLE_HOSTNAME_CHECK);
    }

    public void setContentType(OrbisContentTypes orbisContentTypes) {
        this.contentType = orbisContentTypes;
    }

    public String sendHttpGet(String string, boolean bl) {
        String string2;
        block18: {
            string2 = null;
            HttpURLConnection httpURLConnection = null;
            try {
                Object object;
                URL uRL = new URL(string);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                if (httpURLConnection instanceof HttpsURLConnection) {
                    this.setTrusted((HttpsURLConnection)httpURLConnection);
                }
                httpURLConnection.setRequestMethod("GET");
                switch (this.contentType) {
                    case JSON: {
                        httpURLConnection.addRequestProperty("Content-Type", "application/json; charset=utf-8");
                        httpURLConnection.addRequestProperty("Accept", "application/json; charset=utf-8");
                        break;
                    }
                }
                if (this.username != null && this.password != null) {
                    object = String.valueOf(this.username) + ":" + this.password;
                    String string3 = Base64.getEncoder().encodeToString(((String)object).getBytes(StandardCharsets.UTF_8));
                    httpURLConnection.addRequestProperty("Authorization", "Basic " + string3);
                }
                httpURLConnection.connect();
                this.lastResponseCode = httpURLConnection.getResponseCode();
                if (this.lastResponseCode == 404 && bl) {
                    return null;
                }
                try {
                    if (this.lastResponseCode != 200) {
                        log.error("Server response has non 200-OK status: " + httpURLConnection.getResponseCode());
                        break block18;
                    }
                    object = httpURLConnection.getInputStream();
                    string2 = new String(StreamUtil.readStream((InputStream)object), "UTF-8");
                    ((InputStream)object).close();
                }
                catch (MalformedURLException malformedURLException) {
                    log.error("Failed to build request URL", (Throwable)malformedURLException);
                }
                catch (ProtocolException | KeyManagementException | NoSuchAlgorithmException exception) {
                    log.error("Failed to connect to Orbis service via HTTPS", (Throwable)exception);
                }
                catch (IOException iOException) {
                    log.error("Failed to perform request on Orbis service: " + string, (Throwable)iOException);
                }
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
        return string2;
    }

    public int getLastResponseCode() {
        return this.lastResponseCode;
    }

    private void setTrusted(HttpsURLConnection httpsURLConnection) throws NoSuchAlgorithmException, KeyManagementException {
        if (this.disableCertificateCheck) {
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }
            }};
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
            if (this.disableHostnameCheck) {
                httpsURLConnection.setHostnameVerifier(new TrustfulHostnameVerifier());
            }
        }
    }

    public static enum OrbisContentTypes {
        UNDEFINED,
        JSON;

    }

    private static class TrustfulHostnameVerifier
    implements HostnameVerifier {
        private TrustfulHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }
}

