/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.pwp;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.pwp.IWPPerson;
import com.agfa.pacs.listtext.lta.base.pwp.IWhitePagesProvider;
import com.agfa.pacs.listtext.lta.base.pwp.WPUtils;
import com.agfa.pacs.listtext.lta.base.pwp.WhitePagesFactory;
import com.agfa.pacs.listtext.swingx.util.LabelTransferHandlerFactory;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.listtext.swingx.util.graphics.IconLoader;
import com.agfa.pacs.logging.ALogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.dcm4che3.data.PersonName;

public class PersonLabel
extends JPanel {
    private static boolean hasSearch = false;
    private static ALogger log = ALogger.getLogger(PersonLabel.class);
    private JLabel label;
    private JButton btn;
    private String[] parts;
    private String fullName;
    private Color defaultBtnBackground;
    private String naText = Messages.getString("NotAvailable");

    static {
        if (WhitePagesFactory.getWhitePages() != null && WhitePagesFactory.getWhitePages().isActive()) {
            hasSearch = true;
        }
    }

    public void setText(String string) {
        this.fullName = string;
        this.btn.setBackground(this.defaultBtnBackground);
        if (string != null) {
            String[] stringArray = string.split(" |\\.|\\^");
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (string2.length() > 2) {
                    arrayList.add(string2);
                }
                ++n2;
            }
            this.parts = arrayList.toArray(new String[arrayList.size()]);
            this.label.setText(PersonNameUtilities.personNameToHRReverse((PersonName)new PersonName(string, true)));
        } else {
            this.label.setText("");
        }
        this.btn.setVisible(string != null && hasSearch && !string.equals(this.naText));
    }

    public PersonLabel() {
        this.setLayout(new BorderLayout(0, 0));
        this.label = new JLabel();
        this.label.setHorizontalAlignment(2);
        this.label.setTransferHandler(LabelTransferHandlerFactory.getInstance());
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, mouseEvent, 1);
            }
        });
        this.btn = SwingUtilities2.createButton((Action)new SearchPerson());
        this.btn.setVisible(false);
        this.defaultBtnBackground = this.btn.getBackground();
        this.add((Component)this.label, "Center");
        this.add((Component)this.btn, "East");
    }

    private class SearchPerson
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SearchPerson() {
            super("", IconLoader.getIcon((String)"/icons/telBook.gif", (ClassLoader)PersonLabel.class.getClassLoader(), (double)GUI.getScaleFactor()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IWhitePagesProvider iWhitePagesProvider = WhitePagesFactory.getWhitePages();
            if (iWhitePagesProvider != null) {
                List<IWPPerson> list = iWhitePagesProvider.searchForPersonInformation(PersonLabel.this.parts, PersonLabel.this.fullName);
                log.info("Searching for:" + PersonLabel.this.fullName + " returned " + list.size());
                if (list.size() == 0) {
                    PersonLabel.this.btn.setBackground(UIManager.getColor("color.warning"));
                } else {
                    WPUtils.displayAsPopup(list, PersonLabel.this.btn);
                }
            }
        }
    }
}

