/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.session;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.controls.PermissionUtilities;
import com.agfa.pacs.listtext.lta.deletion.DeletionUtils;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.permission.Permissions;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import org.dcm4che3.data.Attributes;

public class SessionDeleter {
    private static final ALogger LOGGER = ALogger.getLogger(SessionDeleter.class);
    private final IComponentFactory componentFactory;

    public SessionDeleter(IComponentFactory iComponentFactory) {
        this.componentFactory = iComponentFactory;
    }

    public static boolean hasPermission() {
        return Permissions.getInstance().isAllowed("DeleteDicomObjects/DeleteSessions");
    }

    public boolean deleteSession(Component component, IObjectInfo iObjectInfo) {
        boolean bl = false;
        if (!SessionDeleter.hasPermission()) {
            PermissionUtilities.showPermissionDeniedDialog(component, null);
        } else if (this.askForUserConfirmation(component, iObjectInfo)) {
            try {
                bl = DeletionUtils.deleteInstances(Collections.singletonList(iObjectInfo));
            }
            catch (Exception exception) {
                LOGGER.error("Deletion of session failed.", (Throwable)exception);
                bl = false;
            }
            if (!bl) {
                this.informUserOfDeletionFailure(component, iObjectInfo);
            }
        }
        return bl;
    }

    private boolean askForUserConfirmation(Component component, IObjectInfo iObjectInfo) {
        return this.componentFactory.showYesNoDialog(Messages.getString("SessionDeleter.UserConfirmation.Title"), this.getUserMessage("UserConfirmation", iObjectInfo), component);
    }

    private void informUserOfDeletionFailure(Component component, IObjectInfo iObjectInfo) {
        this.componentFactory.showErrorDialog(Messages.getString("SessionDeleter.DeletionFailure.Title"), this.getUserMessage("DeletionFailure", iObjectInfo), component);
    }

    private String getUserMessage(String string, IObjectInfo iObjectInfo) {
        Attributes attributes = iObjectInfo.getDicomObjectMerged();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\'');
        stringBuilder.append(attributes.getString(528432));
        stringBuilder.append('\'');
        Date date = Dcm4cheUtils.getDate((int)524320, (Attributes)attributes);
        if (date != null && !Product.isRunningAutoTests()) {
            stringBuilder.append(' ');
            stringBuilder.append(Messages.getString("SessionDeleter.from"));
            stringBuilder.append(' ');
            stringBuilder.append(DateTimeUtils.date2String((Date)date));
        }
        return MessageFormat.format(Messages.getString("SessionDeleter." + string + ".Message"), stringBuilder.toString());
    }
}

