/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.tagdictionary;

import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTagDictionary;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dcm4che3.data.VR;

public class PrivateTagDictionary {
    public static final String DEFAULT_PRIVATE_VALUE_SUFFIX = "*";
    public static final int frameNumberTag = -65535;
    public static final PrivateTag frameNumber = new PrivateTag("FrameNumber", "Frame Number", -65535, VR.IS);
    public static final PrivateTag studyLoadOrder = new PrivateTag("StudyLoadOrder", "Study Load Order", -65534, VR.IS);
    public static final int studyLoadOrderTag = studyLoadOrder.getNumber();
    public static final PrivateTag seriesNumberOfImages = new PrivateTag("SeriesNumberOfImages", "Number of Images in Series", -65533, VR.IS);
    public static final int seriesNumberOfImagesTag = seriesNumberOfImages.getNumber();
    public static final PrivateTag studyNumberOfImages = new PrivateTag("StudyNumberOfImages", "Number of Images in Study", -65532, VR.IS);
    public static final int studyNumberOfImagesTag = studyNumberOfImages.getNumber();
    public static final PrivateTag imageAreaNumberOfScreens = new PrivateTag("ImageAreaNumberOfScreens", "Number of Image Area Screens", -65531, VR.IS);
    public static final int imageAreaNumberOfScreensTag = imageAreaNumberOfScreens.getNumber();
    public static final PrivateTag displaySetNumberOfImages = new PrivateTag("DisplaySetNumberOfImages", "Number of Images in Display Set", -65530, VR.IS);
    public static final int displaySetNumberOfImagesTag = displaySetNumberOfImages.getNumber();
    public static final PrivateTag patientNumberOfLoadedStudies = new PrivateTag("PatientNumberOfLoadedStudies", "Number of Loaded Studies", -65529, VR.IS);
    public static final int patientNumberOfLoadedStudiesTag = patientNumberOfLoadedStudies.getNumber();
    public static final int displaySetOrientationTag = -65528;
    public static final PrivateTag displaySetOrientation = new PrivateTag("DisplaySetOrientation", "Display Set Orientation", -65528, VR.SH);
    public static final int displaySetTypeTag = -65527;
    public static final PrivateTag displaySetType = new PrivateTag("DisplaySetType", "Display Set Type", -65527, VR.SH);
    public static final PrivateTag studyLoadOrderReverse = new PrivateTag("StudyLoadOrderReverse", "Study Load Order Reverse", -65526, VR.IS);
    public static final int studyLoadOrderReverseTag = studyLoadOrderReverse.getNumber();
    public static final int numberOfAvailablePriorsTag = -65525;
    public static final PrivateTag numberOfAvailablePriors = new PrivateTag("NumberOfAvailablePriors", "Number of available priors", -65525, VR.IS);
    public static final PrivateTag displaySetProperties = new PrivateTag("DisplaySetProperties", "Display Set Properties", -65524, VR.SH);
    public static final int displaySetPropertiesTag = displaySetProperties.getNumber();
    public static final int numberOfDisplaySetsInStudyTag = -65523;
    public static final PrivateTag numberOfDisplaySetsInStudy = new PrivateTag("NumberOfDisplaySetsInStudy", "Number Of Display Sets In Study", -65523, VR.US);
    public static final int studyAgeTag = -65522;
    public static final PrivateTag studyAge = new PrivateTag("StudyAge", "Study Age", -65522, VR.SH);
    public static final int numberOfRuns4DTag = -65521;
    public static final PrivateTag numberOfRuns4D = new PrivateTag("NumberOf4DRuns", "Number Of 4D Runs", -65521, VR.IS);
    public static final int SOURCE_ARCHIVE_TAG = -65520;
    public static final PrivateTag SOURCE_ARCHIVE = new PrivateTag("SourceArchive", "Source Archive", -65520, VR.ST);
    private List<PrivateTag> privateTags = new ArrayList<PrivateTag>();
    private Map<String, PrivateTag> tagMap = new TreeMap<String, PrivateTag>();
    private Map<Integer, PrivateTag> tagNumberMap = new TreeMap<Integer, PrivateTag>();
    private final Map<Integer, PrivateTag> mapPublicToWrappingPrivateTags = new TreeMap<Integer, PrivateTag>();
    private final Map<Integer, Integer> mapWrappingPrivateToPublicTags = new TreeMap<Integer, Integer>();

    PrivateTagDictionary(DicomTagDictionary dicomTagDictionary) {
        this.addPrivateTag(frameNumber);
        this.addPrivateTag(studyLoadOrder);
        this.addPrivateTag(seriesNumberOfImages);
        this.addPrivateTag(studyNumberOfImages);
        this.addPrivateTag(imageAreaNumberOfScreens);
        this.addPrivateTag(displaySetNumberOfImages);
        this.addPrivateTag(patientNumberOfLoadedStudies);
        this.addPrivateTag(displaySetOrientation);
        this.addPrivateTag(displaySetType);
        this.addPrivateTag(studyLoadOrderReverse);
        this.addPrivateTag(numberOfAvailablePriors);
        this.addPrivateTag(displaySetProperties);
        this.addPrivateTag(numberOfDisplaySetsInStudy);
        this.addPrivateTag(studyAge);
        this.addPrivateTag(numberOfRuns4D);
        this.addPrivateTag(SOURCE_ARCHIVE);
        this.addWrappingPrivateTag(dicomTagDictionary, 1609863, -4607);
    }

    public PrivateTag getPrivateTag(int n) {
        if (n < 0 || n >= this.privateTags.size()) {
            return null;
        }
        return this.privateTags.get(n);
    }

    public void addPrivateTag(PrivateTag privateTag) {
        int n = Collections.binarySearch(this.privateTags, privateTag);
        if (n < 0) {
            this.privateTags.add(-n - 1, privateTag);
            this.tagMap.put(privateTag.getName(), privateTag);
            this.tagNumberMap.put(privateTag.getNumber(), privateTag);
        }
    }

    public int size() {
        return this.privateTags.size();
    }

    public PrivateTag privateTagForName(String string) {
        if (string == null) {
            return null;
        }
        return this.tagMap.get(string);
    }

    public PrivateTag privateTagForNumber(Integer n) {
        if (n == null) {
            return null;
        }
        return this.tagNumberMap.get(n);
    }

    public Tag[] allTags() {
        return this.privateTags.toArray(new Tag[this.privateTags.size()]);
    }

    public List<DicomTag> allTagsAsList() {
        return new ArrayList<DicomTag>(this.privateTags);
    }

    public String descriptionForTag(int n) {
        PrivateTag privateTag = this.tagNumberMap.get(n);
        if (privateTag != null) {
            return privateTag.getDescription();
        }
        return null;
    }

    public static boolean isPrivateTag(int n) {
        return (n >> 16 & 0xFFFF) == 65535;
    }

    public Collection<PrivateTag> getWrappingPrivateTags() {
        return this.mapPublicToWrappingPrivateTags.values();
    }

    public boolean isWrappingPrivateTag(Integer n) {
        return this.mapWrappingPrivateToPublicTags.containsKey(n);
    }

    public int convertToPublicTag(int n) {
        Integer n2 = this.mapWrappingPrivateToPublicTags.get(n);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    public Integer getWrappingPrivateOrPublicTag(int n) {
        PrivateTag privateTag = this.mapPublicToWrappingPrivateTags.get(n);
        if (privateTag == null) {
            return n;
        }
        return privateTag.getNumber();
    }

    private void addWrappingPrivateTag(DicomTagDictionary dicomTagDictionary, int n, int n2) {
        PrivateTag privateTag = new PrivateTag("Private" + dicomTagDictionary.nameForTag(n), String.valueOf(dicomTagDictionary.descriptionForTag(n)) + DEFAULT_PRIVATE_VALUE_SUFFIX, n2, VR.LO);
        this.mapPublicToWrappingPrivateTags.put(n, privateTag);
        this.mapWrappingPrivateToPublicTags.put(n2, n);
        this.addPrivateTag(privateTag);
    }
}

