/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.tagdictionary;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTagDictionary;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.listtext.lta.base.tagdictionary.Tag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDescriptionComparator;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class TagDictionary {
    private static final ALogger log = ALogger.getLogger(TagDictionary.class);
    private static DicomTagDictionary dicomTagDictionary;
    private static TagDictionary instance;
    private DicomTag[] allTagsArray = null;
    private PrivateTagDictionary privateTagDictionary;

    static {
        instance = new TagDictionary();
    }

    public static TagDictionary getInstance() {
        return instance;
    }

    private TagDictionary() {
        InputStream inputStream = DicomTagDictionary.class.getClassLoader().getResourceAsStream("/dicomTags.xml");
        try {
            dicomTagDictionary = (DicomTagDictionary)((Object)new XmlLoader().load(inputStream, DicomTagDictionary.class));
        }
        catch (MarshalException marshalException) {
            log.info("error while parsing dicomTags.xml", (Throwable)marshalException);
            dicomTagDictionary = new DicomTagDictionary();
        }
        this.privateTagDictionary = new PrivateTagDictionary(dicomTagDictionary);
    }

    public DicomTag[] getAllTags() {
        if (this.allTagsArray == null) {
            ArrayList<DicomTag> arrayList = new ArrayList<DicomTag>(1000);
            int n = this.privateTagDictionary.size();
            arrayList.addAll(dicomTagDictionary.getAllTags());
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(this.privateTagDictionary.getPrivateTag(n2));
                ++n2;
            }
            Collections.sort(arrayList, TagDescriptionComparator.getInstance());
            this.allTagsArray = arrayList.toArray(new DicomTag[arrayList.size()]);
        }
        return this.allTagsArray;
    }

    public Tag[] getAllDicomTags() {
        Tag[] tagArray = new DicomTag[dicomTagDictionary.size()];
        tagArray = dicomTagDictionary.currentTagsAsList().toArray(tagArray);
        Arrays.sort(tagArray, TagDescriptionComparator.getInstance());
        return tagArray;
    }

    public Tag[] getAllPrivateTags() {
        Tag[] tagArray = this.privateTagDictionary.allTags();
        Arrays.sort(tagArray, TagDescriptionComparator.getInstance());
        return tagArray;
    }

    public List<DicomTag> getAllDicomTagsAsList() {
        List<DicomTag> list = dicomTagDictionary.currentTagsAsList();
        Collections.sort(list, TagDescriptionComparator.getInstance());
        return list;
    }

    public List<DicomTag> getAllPrivateTagsAsList() {
        List<DicomTag> list = this.privateTagDictionary.allTagsAsList();
        Collections.sort(list, TagDescriptionComparator.getInstance());
        return list;
    }

    public List<DicomTag> getAllTagsAsList() {
        List<DicomTag> list = dicomTagDictionary.currentTagsAsList();
        list.addAll(this.privateTagDictionary.allTagsAsList());
        Collections.sort(list, TagDescriptionComparator.getInstance());
        return list;
    }

    public DicomTag getDicomTagForName(String string) {
        return dicomTagDictionary.dicomTag(string);
    }

    public PrivateTag getPrivateTagForName(String string) {
        return this.privateTagDictionary.privateTagForName(string);
    }

    public DicomTag getTagForName(String string) {
        DicomTag dicomTag = this.getDicomTagForName(string);
        return dicomTag != null ? dicomTag : this.getPrivateTagForName(string);
    }

    public String getNameForName(String string) {
        DicomTag dicomTag = this.getDicomTagForName(string);
        if (dicomTag == null) {
            dicomTag = this.getPrivateTagForName(string);
        }
        if (dicomTag != null) {
            return dicomTag.getName();
        }
        return null;
    }

    public DicomTag getDicomTag(Integer n) {
        return dicomTagDictionary.dicomTag(n);
    }

    public String descriptionForTag(int n) {
        String string = dicomTagDictionary.descriptionForTag(n);
        if (string != null) {
            return string;
        }
        return this.privateTagDictionary.descriptionForTag(n);
    }

    public String descriptionForTag(String string) {
        return this.getTagForName(string).getDescription();
    }

    public boolean isPrivatTag(String string) {
        return this.privateTagDictionary.privateTagForName(string) != null;
    }

    public PrivateTagDictionary getPrivateTagDictionary() {
        return this.privateTagDictionary;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportDicomTagsToHTML(File file, int n) throws IOException {
        void var3_7;
        if (file == null) {
            return;
        }
        Object var3_3 = null;
        List<DicomTag> list = dicomTagDictionary.currentTagsAsList();
        if (n == 0) {
            TagComparatorName tagComparatorName = new TagComparatorName();
        } else if (n == 1) {
            TagComparatorVR tagComparatorVR = new TagComparatorVR();
        } else if (n == 2) {
            TagComparatorNumber tagComparatorNumber = new TagComparatorNumber();
        }
        if (var3_7 != null) {
            Collections.sort(list, var3_7);
        }
        Throwable throwable = null;
        Object var6_11 = null;
        try {
            OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            try {
                try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
                    dataOutputStream.write(this.convertDicomTagsToHTML(list));
                }
                if (outputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private byte[] convertDicomTagsToHTML(List<DicomTag> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><meta name=\"GENERATOR\" content=\"ImpaxEE R20\"><title>\"Supported tags for hanging protocols\"</title></head><body>");
        stringBuffer.append("<h1 align=\"center\">Supported DICOM tags</h1>");
        stringBuffer.append("<p align=\"center\">Version " + Product.getVersionString() + "</p>");
        stringBuffer.append("<table align=\"center\" border=\"1\">");
        stringBuffer.append("<tr>");
        stringBuffer.append("<td><b>Number</b></td>");
        stringBuffer.append("<td><b>Name</b></td>");
        stringBuffer.append("<td><b>Description</b></td>");
        stringBuffer.append("<td><b>VR</b></td>");
        stringBuffer.append("</tr>");
        for (DicomTag dicomTag : list) {
            stringBuffer.append("<tr>");
            this.appendAsTD(stringBuffer, dicomTag.tagNumberAsFormatedString());
            this.appendAsTD(stringBuffer, dicomTag.getName());
            this.appendAsTD(stringBuffer, dicomTag.getDescription());
            this.appendAsTD(stringBuffer, dicomTag.getVr());
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString().getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportPrivateTagsToHTML(File file, int n) throws IOException {
        void var3_6;
        if (file == null) {
            return;
        }
        Object var3_3 = null;
        List<DicomTag> list = this.privateTagDictionary.allTagsAsList();
        if (n == 0) {
            TagComparatorName tagComparatorName = new TagComparatorName();
        } else if (n == 1) {
            TagComparatorVR tagComparatorVR = new TagComparatorVR();
        }
        if (var3_6 != null) {
            Collections.sort(list, var3_6);
        }
        Throwable throwable = null;
        Object var6_10 = null;
        try {
            OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            try {
                try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
                    dataOutputStream.write(this.convertPrivateTagsToHTML(list));
                }
                if (outputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private byte[] convertPrivateTagsToHTML(List<DicomTag> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><meta name=\"GENERATOR\" content=\"ImpaxEE R20\"><title>\"Supported tags for hanging protocols\"</title></head><body>");
        stringBuffer.append("<h1 align=\"center\">Supported private tags</h1>");
        stringBuffer.append("<p align=\"center\">Version " + Product.getVersionString() + "</p>");
        stringBuffer.append("<table align=\"center\" border=\"1\">");
        stringBuffer.append("<tr>");
        stringBuffer.append("<td><b>Name</b></td>");
        stringBuffer.append("<td><b>Description</b></td>");
        stringBuffer.append("<td><b>VR</b></td>");
        stringBuffer.append("</tr>");
        for (Tag tag : list) {
            stringBuffer.append("<tr>");
            this.appendAsTD(stringBuffer, tag.getName());
            this.appendAsTD(stringBuffer, tag.getDescription());
            this.appendAsTD(stringBuffer, tag.getVr());
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void appendAsTD(StringBuffer stringBuffer, String string) {
        stringBuffer.append("<td>");
        stringBuffer.append(string);
        stringBuffer.append("</td>");
    }

    public Tag getTag(Integer n) {
        if ((n & 0x10000) != 0) {
            return this.privateTagDictionary.privateTagForNumber(n);
        }
        return dicomTagDictionary.dicomTag(n);
    }

    public PrivateTag getPrivateTag(Integer n) {
        return this.privateTagDictionary.privateTagForNumber(n);
    }

    public boolean isPrivatTag(Integer n) {
        return this.privateTagDictionary.privateTagForNumber(n) != null;
    }

    private static class TagComparatorName
    implements Comparator<Tag> {
        Collator collator = Collator.getInstance(Locale.getDefault());

        @Override
        public int compare(Tag tag, Tag tag2) {
            return this.collator.compare(tag.getName(), tag2.getName());
        }
    }

    private static class TagComparatorNumber
    implements Comparator<DicomTag> {
        @Override
        public int compare(DicomTag dicomTag, DicomTag dicomTag2) {
            if (dicomTag != null) {
                if (dicomTag2 != null) {
                    long l;
                    long l2 = (long)dicomTag.getNumber().intValue() & 0xFFFFFFFFL;
                    if (l2 < (l = (long)dicomTag2.getNumber().intValue() & 0xFFFFFFFFL)) {
                        return -1;
                    }
                    if (l2 > l) {
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
            if (dicomTag2 == null) {
                return 0;
            }
            return -1;
        }
    }

    private static class TagComparatorVR
    implements Comparator<Tag> {
        Collator collator = Collator.getInstance(Locale.getDefault());

        @Override
        public int compare(Tag tag, Tag tag2) {
            return this.collator.compare(tag.getVr(), tag2.getVr());
        }
    }
}

