/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.taskEngine;

import com.agfa.pacs.background.DoneState;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.background.IBackgroundTaskEngine;
import com.agfa.pacs.background.IProgressListener;
import com.agfa.pacs.background.IScheduledBackgroundTask;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.export.IFollowUpTaskRegistry;
import com.agfa.pacs.listtext.async.AsyncWorkerPool;
import com.agfa.pacs.listtext.lta.progress.ProgressManagerFactory;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import com.agfa.pacs.listtext.lta.util.job.JobControl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import org.dcm4che3.data.Attributes;

public class EEBackgroundEngine
implements IBackgroundTaskEngine {
    private final Map<IBackgroundTask, ProgressStateDetail> detailInformations = new WeakHashMap<IBackgroundTask, ProgressStateDetail>();

    public FollowUpTask createFollowUpRegistry(JobControl jobControl, IProgressListener<DoneState, String, String> iProgressListener) {
        return new FollowUpTask(jobControl.getModel(), iProgressListener);
    }

    public IScheduledBackgroundTask placeBackgroundTask(IBackgroundTask iBackgroundTask) {
        return this.placeBackgroundTask(iBackgroundTask, null);
    }

    public IScheduledBackgroundTask placeBackgroundTask(IBackgroundTask iBackgroundTask, IProgressListener<DoneState, String, String> iProgressListener) {
        ProgressStateDetail progressStateDetail = null;
        if (this.detailInformations.containsKey(iBackgroundTask)) {
            progressStateDetail = this.detailInformations.remove(iBackgroundTask);
        }
        if (iBackgroundTask.getInfo() != null) {
            if (progressStateDetail == null) {
                progressStateDetail = new ProgressStateDetail();
            }
            JobControl jobControl = new JobControl(iBackgroundTask.getInfo(), progressStateDetail.detailedMessage, progressStateDetail.target, progressStateDetail.patients.toArray(new Attributes[progressStateDetail.patients.size()]));
            ProgressManagerFactory.getManager().addProgressState(jobControl.getModel());
            jobControl.addTask(iBackgroundTask);
            if (iProgressListener != null) {
                ProgressListenerWrapper.attachListener(jobControl.getModel(), iProgressListener);
            }
            Thread thread = new Thread((Runnable)jobControl, iBackgroundTask.getInfo());
            thread.setPriority(1);
            thread.start();
            return new EEScheduledBackgroundTask(iBackgroundTask);
        }
        EEScheduledBackgroundTask eEScheduledBackgroundTask = new EEScheduledBackgroundTask(iBackgroundTask);
        AsyncWorkerPool.getInstance().placeTask((Runnable)eEScheduledBackgroundTask);
        return eEScheduledBackgroundTask;
    }

    public IBackgroundTask getTask(String string) {
        throw new UnsupportedOperationException();
    }

    public boolean isProcessing() {
        return false;
    }

    public boolean isIdle() {
        return true;
    }

    public void shutdown() {
    }

    private static class EEScheduledBackgroundTask
    implements IScheduledBackgroundTask,
    Runnable {
        private IBackgroundTask backgroundTask;
        private Optional<DoneState> result = Optional.empty();

        public EEScheduledBackgroundTask(IBackgroundTask iBackgroundTask) {
            this.backgroundTask = iBackgroundTask;
        }

        public IBackgroundTask getTask() {
            return this.backgroundTask;
        }

        public boolean cancel() {
            this.backgroundTask.terminate();
            this.result = Optional.of(DoneState.CANCELED);
            return true;
        }

        public void attachProgressListener(IProgressListener<? super DoneState, ? super String, ? super String> iProgressListener) {
            throw new UnsupportedOperationException();
        }

        public boolean isDone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void run() {
            boolean bl = this.backgroundTask.execute();
            this.result = Optional.of(bl ? DoneState.SUCCESS : DoneState.FAILED);
        }

        public Optional<DoneState> getDoneState() {
            return this.result;
        }
    }

    private class FollowUpTask
    implements IFollowUpTaskRegistry {
        private final ProgressStateDetail detail;
        private final IProgressListener<DoneState, String, String> listener;

        public FollowUpTask(ProgressStateModel progressStateModel, IProgressListener<DoneState, String, String> iProgressListener) {
            this.detail = new ProgressStateDetail(progressStateModel);
            this.listener = iProgressListener;
        }

        public IProgressListener<DoneState, String, String> registerFollowUpTask(IBackgroundTask iBackgroundTask) {
            EEBackgroundEngine.this.detailInformations.put(iBackgroundTask, this.detail);
            return this.listener;
        }

        public void registerScheduledFollowUpTask(IScheduledBackgroundTask iScheduledBackgroundTask) {
        }
    }

    private static class ProgressListenerWrapper
    implements PropertyChangeListener {
        private final ProgressStateModel model;
        private final IProgressListener<? super DoneState, ? super String, ? super String> delegate;

        private ProgressListenerWrapper(ProgressStateModel progressStateModel, IProgressListener<? super DoneState, ? super String, ? super String> iProgressListener) {
            this.model = progressStateModel;
            this.delegate = iProgressListener;
        }

        static void attachListener(ProgressStateModel progressStateModel, IProgressListener<DoneState, String, String> iProgressListener) {
            progressStateModel.addPropertyChangeListener((PropertyChangeListener)new ProgressListenerWrapper(progressStateModel, iProgressListener));
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JobState jobState;
            if ("PROGRESS_VALUE_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
                double d = (Double)propertyChangeEvent.getNewValue();
                this.delegate.progress(d, (Object)this.model.getProgressState().name());
            } else if ("PROGRESS_STATE_CHANGED".equals(propertyChangeEvent.getPropertyName()) && (jobState = (JobState)propertyChangeEvent.getNewValue()).isDone()) {
                this.model.removePropertyChangeListener((PropertyChangeListener)this);
                this.notifyDone(jobState);
            }
        }

        void notifyDone(JobState jobState) {
            DoneState doneState;
            switch (jobState) {
                case CANCELLED: {
                    doneState = DoneState.CANCELED;
                    break;
                }
                case FINISHED: 
                case RETIRED: {
                    doneState = DoneState.SUCCESS;
                    break;
                }
                default: {
                    doneState = DoneState.FAILED;
                }
            }
            String string = this.model.getProgressMessage();
            if (string == null || string.endsWith("...")) {
                string = this.model.getDetailMessage();
            }
            this.delegate.done((Object)doneState, (Object)string);
        }
    }

    private static class ProgressStateDetail {
        final String detailedMessage;
        final String target;
        final List<Attributes> patients;

        ProgressStateDetail() {
            this.detailedMessage = null;
            this.target = null;
            this.patients = Collections.emptyList();
        }

        ProgressStateDetail(ProgressStateModel progressStateModel) {
            this.detailedMessage = progressStateModel.getDetailMessage();
            this.target = progressStateModel.getTarget();
            this.patients = progressStateModel.getPatients();
        }
    }
}

