/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.worklists;

import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklist;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistAction;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistBundle;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistItem;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistItemWalker;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistProvider;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistSelectionModel;
import com.agfa.pacs.listtext.lta.base.worklists.NormalizedWorklistProviderFactory;
import com.agfa.pacs.listtext.lta.base.worklists.NormalizedWorklistUtils;
import com.agfa.pacs.listtext.lta.util.WeakListenerSupport;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.dcm4che3.data.VR;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class NormalizedWorklistManager {
    private static final ALogger log = ALogger.getLogger(NormalizedWorklistManager.class);
    private static final String CONFIG_PATH = "listtext.lta.listarea.openedWorklists";
    private static NormalizedWorklistManager instance;
    private INormalizedWorklist openedWorklist;
    private boolean openedWorklistExpanded;
    private boolean searchVisible;
    private List<INormalizedWorklistItem> selectedItems;
    private WeakListenerSupport<INormalizedWorklistManagerListener> listenerSupport = new WeakListenerSupport();

    private NormalizedWorklistManager() {
        this.selectedItems = new ArrayList<INormalizedWorklistItem>(8);
        EventEngineFactory.getInstance().register(EventEngineFactory.getInstance().createListenerProvider((IEventListener)new OpenedWorklistEventHandler()), "lta.listarea.ui");
        this.init();
    }

    public static synchronized NormalizedWorklistManager getInstance() {
        if (instance == null) {
            instance = new NormalizedWorklistManager();
        }
        return instance;
    }

    public boolean isWorklistAvailable() {
        for (INormalizedWorklistProvider iNormalizedWorklistProvider : NormalizedWorklistProviderFactory.get().getProviders()) {
            if (!iNormalizedWorklistProvider.isAvailable() || iNormalizedWorklistProvider.getType().isSearchType()) continue;
            return true;
        }
        return false;
    }

    public boolean isSearchAvailable() {
        return NormalizedWorklistManager.findSearchWorklist() != null;
    }

    public boolean isSearchVisible() {
        return this.searchVisible;
    }

    public void setSearchVisible(boolean bl) {
        if (this.searchVisible != bl) {
            this.searchVisible = bl;
            this.save();
            this.fireSearchWorklistChanged(this.getSearchWorklist());
        }
    }

    public INormalizedWorklist getSearchWorklist() {
        if (this.searchVisible) {
            return NormalizedWorklistManager.findSearchWorklist();
        }
        return null;
    }

    public INormalizedWorklist getOpenedWorklist() {
        return this.openedWorklist;
    }

    public INormalizedWorklistProvider.IWorklistType getOpenedWorklistType() {
        return this.openedWorklist != null ? this.openedWorklist.getBundle().getProvider().getType() : null;
    }

    public INormalizedWorklistBundle getOpenedWorklistBundle() {
        return this.openedWorklist != null ? this.openedWorklist.getBundle() : null;
    }

    private static INormalizedWorklist getWorklistToOpen(INormalizedWorklistBundle iNormalizedWorklistBundle) {
        Collection<? extends INormalizedWorklist> collection;
        INormalizedWorklistSelectionModel iNormalizedWorklistSelectionModel;
        if (iNormalizedWorklistBundle != null && (iNormalizedWorklistSelectionModel = iNormalizedWorklistBundle.getProvider().getSelectionModel()) != null && (collection = iNormalizedWorklistSelectionModel.getSelectedWorklists(iNormalizedWorklistBundle)) != null && !collection.isEmpty()) {
            return collection.iterator().next();
        }
        return null;
    }

    public INormalizedWorklist getExpandedWorklist() {
        return this.isOpenedWorklistExpanded() ? this.getOpenedWorklist() : this.getSearchWorklist();
    }

    public void setOpenedWorklist(INormalizedWorklist iNormalizedWorklist, boolean bl) {
        this.setOpenedWorklist(iNormalizedWorklist, bl, -1L);
    }

    public void setOpenedWorklistBundle(INormalizedWorklistBundle iNormalizedWorklistBundle, boolean bl) {
        this.setOpenedWorklist(NormalizedWorklistManager.getWorklistToOpen(iNormalizedWorklistBundle), bl);
    }

    private void setOpenedWorklist(INormalizedWorklist iNormalizedWorklist, boolean bl, long l) {
        if (this.openedWorklist != iNormalizedWorklist || this.openedWorklistExpanded != bl) {
            if (this.openedWorklist != null) {
                try {
                    INormalizedWorklistAction iNormalizedWorklistAction = this.openedWorklist.getBundle().getProvider().getAction("CANCEL");
                    if (iNormalizedWorklistAction != null) {
                        iNormalizedWorklistAction.execute(this.openedWorklist, null);
                    }
                }
                catch (Exception exception) {
                    log.error(null, (Throwable)exception);
                }
            }
            this.openedWorklist = iNormalizedWorklist;
            this.openedWorklistExpanded = bl;
            this.save();
            if (iNormalizedWorklist != null) {
                RefreshWorklistService.get().scheduleOnce(iNormalizedWorklist, l);
                if (NormalizedWorklistUtils.isOfType(iNormalizedWorklist, "DEMO")) {
                    RefreshWorklistService.get().schedulePeriodically(iNormalizedWorklist);
                } else {
                    RefreshWorklistService.get().schedulePeriodically(null);
                }
            } else {
                RefreshWorklistService.get().shutdown();
            }
            this.fireOpenedWorklistChanged(this.getOpenedWorklist(), this.isOpenedWorklistExpanded());
        }
    }

    public boolean isWorklistOpened(INormalizedWorklist iNormalizedWorklist) {
        return iNormalizedWorklist == this.getOpenedWorklist() || iNormalizedWorklist == this.getSearchWorklist();
    }

    public boolean isOpenedWorklistExpanded() {
        return this.openedWorklist != null && this.openedWorklistExpanded;
    }

    public void setOpenedWorklistExpanded(boolean bl) {
        if (this.openedWorklistExpanded != bl) {
            this.openedWorklistExpanded = bl;
            this.save();
            this.fireOpenedWorklistChanged(this.getOpenedWorklist(), this.isOpenedWorklistExpanded());
        }
    }

    public List<INormalizedWorklistItem> getSelectedItems() {
        return Collections.unmodifiableList(this.selectedItems);
    }

    public List<IDataInfo> getSelectedInfos() {
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
        if (this.selectedItems != null) {
            for (INormalizedWorklistItem iNormalizedWorklistItem : this.selectedItems) {
                arrayList.addAll(iNormalizedWorklistItem.getDataInfos());
            }
        }
        return arrayList;
    }

    public void addListener(INormalizedWorklistManagerListener iNormalizedWorklistManagerListener) {
        this.listenerSupport.addListener((Object)iNormalizedWorklistManagerListener);
    }

    public void addListener(INormalizedWorklistManagerListener iNormalizedWorklistManagerListener, boolean bl) {
        this.listenerSupport.addListener((Object)iNormalizedWorklistManagerListener, bl);
    }

    public void removeListener(INormalizedWorklistManagerListener iNormalizedWorklistManagerListener) {
        this.listenerSupport.removeListener((Object)iNormalizedWorklistManagerListener);
    }

    private void fireSearchWorklistChanged(INormalizedWorklist iNormalizedWorklist) {
        for (INormalizedWorklistManagerListener iNormalizedWorklistManagerListener : this.listenerSupport.getAllListeners()) {
            iNormalizedWorklistManagerListener.searchWorklistChanged(iNormalizedWorklist);
        }
    }

    private void fireOpenedWorklistChanged(INormalizedWorklist iNormalizedWorklist, boolean bl) {
        for (INormalizedWorklistManagerListener iNormalizedWorklistManagerListener : this.listenerSupport.getAllListeners()) {
            iNormalizedWorklistManagerListener.openedWorklistChanged(iNormalizedWorklist, bl);
        }
    }

    private static INormalizedWorklist findSearchWorklist() {
        for (INormalizedWorklistProvider iNormalizedWorklistProvider : NormalizedWorklistProviderFactory.get().getProviders()) {
            List<? extends INormalizedWorklist> list;
            List<? extends INormalizedWorklistBundle> list2;
            if (!iNormalizedWorklistProvider.isAvailable() || !iNormalizedWorklistProvider.getType().isSearchType() || (list2 = iNormalizedWorklistProvider.getBundles()).isEmpty() || (list = list2.get(0).getWorklists()) == null || list.isEmpty()) continue;
            return list.get(0);
        }
        return null;
    }

    private void save() {
        try {
            INormalizedWorklistBundle iNormalizedWorklistBundle;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<opened-worklists>");
            if (this.openedWorklist != null) {
                iNormalizedWorklistBundle = this.openedWorklist.getBundle();
                stringBuilder.append("<opened-worklist");
                stringBuilder.append(" type-id=\"").append(iNormalizedWorklistBundle.getProvider().getType().getID()).append("\"");
                stringBuilder.append(" bundle-id=\"").append(iNormalizedWorklistBundle.getID()).append("\"");
                stringBuilder.append(" expanded=\"").append(this.openedWorklistExpanded).append("\"");
                stringBuilder.append("/>");
            }
            stringBuilder.append("</opened-worklists>");
            iNormalizedWorklistBundle = ConfigurationProviderFactory.getConfig();
            this.setSearchVisible(this.searchVisible, (IConfigurationProvider)iNormalizedWorklistBundle);
            ConfigUtilities.saveToConfigAsXML_UTF16((IConfigurationProvider)iNormalizedWorklistBundle, (String)"listtext.lta.listarea.openedWorklists.worklists", (String)stringBuilder.toString());
        }
        catch (Exception exception) {
            log.error("Failed to save list-area opened worklist settings!", (Throwable)exception);
        }
    }

    private void init() {
        this.searchVisible = true;
        this.openedWorklist = null;
        this.openedWorklistExpanded = false;
        try {
            try {
                IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
                this.searchVisible = this.isSearchVisible(iConfigurationProvider);
                if (iConfigurationProvider.exists("listtext.lta.listarea.openedWorklists.worklists")) {
                    Document document = ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)iConfigurationProvider, (String)"listtext.lta.listarea.openedWorklists.worklists");
                    NodeList nodeList = document.getElementsByTagName("opened-worklist");
                    if (nodeList.getLength() > 0) {
                        NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
                        INormalizedWorklistProvider iNormalizedWorklistProvider = NormalizedWorklistProviderFactory.get().getProvider(namedNodeMap.getNamedItem("type-id").getNodeValue());
                        if (iNormalizedWorklistProvider == null) {
                            log.warn("Failed to read/init list-area opened/expanded worklist settings: Worklist type not found!");
                        } else {
                            INormalizedWorklistSelectionModel iNormalizedWorklistSelectionModel;
                            String string = namedNodeMap.getNamedItem("bundle-id").getNodeValue();
                            if (string != null && (iNormalizedWorklistSelectionModel = iNormalizedWorklistProvider.getSelectionModel()) != null) {
                                boolean bl = false;
                                for (INormalizedWorklistBundle iNormalizedWorklistBundle : iNormalizedWorklistSelectionModel.getSelectedBundles()) {
                                    if (!string.equals(iNormalizedWorklistBundle.getID())) continue;
                                    bl = true;
                                    this.setOpenedWorklist(NormalizedWorklistManager.getWorklistToOpen(iNormalizedWorklistBundle), Boolean.valueOf(namedNodeMap.getNamedItem("expanded").getNodeValue()), 2000L);
                                    break;
                                }
                                if (!bl) {
                                    DelayedInitializationHandler.install(iNormalizedWorklistProvider, string, true, Boolean.valueOf(namedNodeMap.getNamedItem("expanded").getNodeValue()));
                                }
                            }
                        }
                    }
                } else {
                    this.initOpenedLegacyWorklistBackwardCompatible();
                    if (this.openedWorklist == null) {
                        this.initOpenedUWLBackwardCompatible();
                    }
                }
            }
            catch (Exception exception) {
                log.error("Failed to read/init list-area opened/expanded worklist settings!", (Throwable)exception);
                if (this.searchVisible) {
                    DelayedSearchInitializationHandler.install();
                }
            }
        }
        finally {
            if (this.searchVisible) {
                DelayedSearchInitializationHandler.install();
            }
        }
    }

    public boolean isSearchVisible(IConfigurationProvider iConfigurationProvider) {
        block5: {
            try {
                String string = "listtext.lta.listarea.openedWorklists.searchVisible";
                if (iConfigurationProvider.exists(string)) {
                    return iConfigurationProvider.getBoolean(string);
                }
                IConfigurationProvider iConfigurationProvider2 = ConfigurationProviderFactory.getConfig();
                if (iConfigurationProvider2.exists("listtext.lta.listarea.searchWorklist")) {
                    if (iConfigurationProvider2.getBoolean("listtext.lta.listarea.searchWorklist.opened")) {
                        return true;
                    }
                    break block5;
                }
                return true;
            }
            catch (Exception exception) {
                log.error(null, (Throwable)exception);
            }
        }
        return false;
    }

    public void setSearchVisible(boolean bl, IConfigurationProvider iConfigurationProvider) {
        String string = "listtext.lta.listarea.openedWorklists.searchVisible";
        iConfigurationProvider.setBoolean(string, bl);
    }

    private void initOpenedLegacyWorklistBackwardCompatible() {
        try {
            IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
            if (iConfigurationProvider.exists("listtext.lta.listarea.openedWorklist.expanded")) {
                this.openedWorklistExpanded = iConfigurationProvider.getBoolean("listtext.lta.listarea.openedWorklist.expanded");
            }
            IConfigurationProvider iConfigurationProvider2 = null;
            if (iConfigurationProvider.exists("listtext.lta.listarea.openedWorklist")) {
                if (iConfigurationProvider.getBoolean("listtext.lta.listarea.openedWorklist.opened")) {
                    iConfigurationProvider2 = iConfigurationProvider.getNode("listtext.lta.listarea.openedWorklist");
                }
            } else if (iConfigurationProvider.exists("listtext.lta.listarea.expandedWorklistXML")) {
                iConfigurationProvider2 = iConfigurationProvider.getNode("listtext.lta.listarea.expandedWorklistXML");
            }
            if (iConfigurationProvider2 != null) {
                String string;
                NodeList nodeList;
                Document document = ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)iConfigurationProvider2, (String)"worklistIdXML");
                String string2 = document.getElementsByTagName("library-id").item(0).getTextContent();
                INormalizedWorklistProvider iNormalizedWorklistProvider = NormalizedWorklistProviderFactory.get().getProvider(string2);
                if (iNormalizedWorklistProvider != null && (nodeList = document.getElementsByTagName("bundle-id")).getLength() > 0 && (string = nodeList.item(0).getTextContent()) != null) {
                    boolean bl = false;
                    for (INormalizedWorklistBundle iNormalizedWorklistBundle : iNormalizedWorklistProvider.getBundles()) {
                        if (!string.equals(iNormalizedWorklistBundle.getID())) continue;
                        bl = true;
                        this.setOpenedWorklist(NormalizedWorklistManager.getWorklistToOpen(iNormalizedWorklistBundle), this.openedWorklistExpanded, 2000L);
                        break;
                    }
                    if (!bl) {
                        DelayedInitializationHandler.install(iNormalizedWorklistProvider, string, true, this.openedWorklistExpanded);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.warn("Reading expanded worklist flag from configuration failed! Search is going to be expanded by default...", (Throwable)exception);
        }
    }

    private void initOpenedUWLBackwardCompatible() {
        try {
            Document document;
            NodeList nodeList;
            IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
            if (iConfigurationProvider.exists("listtext.lta.listarea.openedWorklist.uwl") && (nodeList = (document = ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)iConfigurationProvider, (String)"listtext.lta.listarea.openedWorklist.uwl")).getElementsByTagName("opened-worklist")).getLength() > 0) {
                NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
                INormalizedWorklistProvider iNormalizedWorklistProvider = NormalizedWorklistProviderFactory.get().getProvider(namedNodeMap.getNamedItem("type-id").getNodeValue());
                if (iNormalizedWorklistProvider == null) {
                    log.warn("Failed to read/init list-area opened/expanded UWL settings: Type of UWL not found!");
                } else {
                    String string = namedNodeMap.getNamedItem("uwl-id").getNodeValue();
                    if (string != null) {
                        boolean bl = false;
                        block2: for (INormalizedWorklistBundle iNormalizedWorklistBundle : iNormalizedWorklistProvider.getBundles()) {
                            for (INormalizedWorklist iNormalizedWorklist : iNormalizedWorklistBundle.getWorklists()) {
                                if (!string.equals(iNormalizedWorklist.getID())) continue;
                                bl = true;
                                this.setOpenedWorklist(NormalizedWorklistManager.getWorklistToOpen(iNormalizedWorklist.getBundle()), Boolean.valueOf(namedNodeMap.getNamedItem("expanded").getNodeValue()), 2000L);
                                continue block2;
                            }
                        }
                        if (!bl) {
                            DelayedInitializationHandler.install(iNormalizedWorklistProvider, string, false, Boolean.valueOf(namedNodeMap.getNamedItem("expanded").getNodeValue()));
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error("Failed to read/init list-area opened/expanded UWL settings!", (Throwable)exception);
        }
    }

    private static abstract class DelayedInitializationHandler
    implements INormalizedWorklistSelectionModel.IWorklistSelectionListener {
        private static DelayedInitializationHandler ref;

        private DelayedInitializationHandler() {
        }

        public static synchronized void install(INormalizedWorklistProvider iNormalizedWorklistProvider, final String string, final boolean bl, final boolean bl2) {
            final INormalizedWorklistSelectionModel iNormalizedWorklistSelectionModel = iNormalizedWorklistProvider.getSelectionModel();
            if (ref == null && iNormalizedWorklistSelectionModel != null) {
                ref = new DelayedInitializationHandler(){

                    @Override
                    public boolean isWorklistExpanded() {
                        return bl2;
                    }

                    @Override
                    public INormalizedWorklist findWorklist() {
                        for (INormalizedWorklistBundle iNormalizedWorklistBundle : iNormalizedWorklistSelectionModel.getSelectedBundles()) {
                            if (bl) {
                                if (!string.equals(iNormalizedWorklistBundle.getID())) continue;
                                return NormalizedWorklistManager.getWorklistToOpen(iNormalizedWorklistBundle);
                            }
                            for (INormalizedWorklist iNormalizedWorklist : iNormalizedWorklistBundle.getWorklists()) {
                                if (!string.equals(iNormalizedWorklist.getID())) continue;
                                return iNormalizedWorklist;
                            }
                        }
                        return null;
                    }
                };
                iNormalizedWorklistSelectionModel.addSelectionListener(ref, true);
            }
        }

        protected abstract INormalizedWorklist findWorklist();

        protected abstract boolean isWorklistExpanded();

        @Override
        public final void selectionChanged(INormalizedWorklistSelectionModel iNormalizedWorklistSelectionModel) {
            INormalizedWorklist iNormalizedWorklist = this.findWorklist();
            if (iNormalizedWorklist != null && !NormalizedWorklistUtils.isOfType(iNormalizedWorklist, INormalizedWorklist.NormalizedWorklistType.SEARCH.toString())) {
                NormalizedWorklistManager.getInstance().setOpenedWorklist(iNormalizedWorklist, this.isWorklistExpanded(), 3000L);
            }
            DelayedInitializationHandler.checkToUninstall();
        }

        private static void checkToUninstall() {
            if (NormalizedWorklistManager.getInstance().getOpenedWorklist() != null) {
                ref = null;
            }
        }
    }

    private static class DelayedSearchInitializationHandler
    implements INormalizedWorklistSelectionModel.IWorklistSelectionListener {
        private static DelayedSearchInitializationHandler ref;

        private DelayedSearchInitializationHandler() {
        }

        public static synchronized void install() {
            if (ref == null) {
                for (INormalizedWorklistProvider iNormalizedWorklistProvider : NormalizedWorklistProviderFactory.get().getProviders()) {
                    if (!iNormalizedWorklistProvider.isAvailable() || !iNormalizedWorklistProvider.getType().isSearchType()) continue;
                    ref = new DelayedSearchInitializationHandler();
                    iNormalizedWorklistProvider.getSelectionModel().addSelectionListener(ref, true);
                    ref.selectionChanged(iNormalizedWorklistProvider.getSelectionModel());
                    break;
                }
            }
        }

        @Override
        public final void selectionChanged(INormalizedWorklistSelectionModel iNormalizedWorklistSelectionModel) {
            INormalizedWorklist iNormalizedWorklist = NormalizedWorklistManager.findSearchWorklist();
            if (iNormalizedWorklist != null) {
                NormalizedWorklistManager.getInstance().fireSearchWorklistChanged(iNormalizedWorklist);
                if (NormalizedWorklistManager.getInstance().getOpenedWorklist() != null) {
                    ref = null;
                }
            }
        }
    }

    public static interface INormalizedWorklistManagerListener {
        public void searchWorklistChanged(INormalizedWorklist var1);

        public void openedWorklistChanged(INormalizedWorklist var1, boolean var2);
    }

    private class OpenedWorklistEventHandler
    implements IEventListener {
        private int refreshEventId = EventEngineFactory.getInstance().getEventID("LISTAREA_REFRESH_EXPANDED_WORKLIST");
        private int openEventId = EventEngineFactory.getInstance().getEventID("LISTAREA_EXPAND_WORKLIST_REQUEST");
        private int studyStatusChangedEventId = EventEngineFactory.getInstance().getEventID("STUDY_STATUS_CHANGED");
        private int itemSelectionChangedEventId = EventEngineFactory.getInstance().getEventID("DATAINFO_SELECTION_CHANGED");

        private OpenedWorklistEventHandler() {
        }

        public boolean handleEvent(IEvent iEvent) {
            if (iEvent.getEventID() == this.openEventId) {
                try {
                    Object object = iEvent.getPayload();
                    if (object instanceof INormalizedWorklist) {
                        NormalizedWorklistManager.this.setOpenedWorklist((INormalizedWorklist)object, true);
                    } else if (object instanceof INormalizedWorklistBundle) {
                        NormalizedWorklistManager.this.setOpenedWorklistBundle((INormalizedWorklistBundle)object, true);
                    }
                }
                catch (Exception exception) {
                    log.error(null, (Throwable)exception);
                }
            } else if (iEvent.getEventID() == this.refreshEventId) {
                INormalizedWorklist iNormalizedWorklist = NormalizedWorklistManager.this.getOpenedWorklist();
                if (iNormalizedWorklist != null) {
                    try {
                        iNormalizedWorklist.refresh();
                    }
                    catch (Exception exception) {
                        log.error("Failed to refresh worklist!", (Throwable)exception);
                    }
                }
            } else if (iEvent.getEventID() == this.studyStatusChangedEventId) {
                INormalizedWorklist iNormalizedWorklist = NormalizedWorklistManager.this.getOpenedWorklist();
                if (iNormalizedWorklist != null) {
                    IStudyInfo iStudyInfo = (IStudyInfo)iEvent.getPayload();
                    INormalizedWorklistItemWalker iNormalizedWorklistItemWalker = iNormalizedWorklist.createItemWalker();
                    if (iNormalizedWorklistItemWalker != null && iStudyInfo != null) {
                        while (iNormalizedWorklistItemWalker.hasNextItem()) {
                            List list = DataInfoUtilities.getLevel(iNormalizedWorklistItemWalker.getNextItem().getDataInfos(), IStudyInfo.class);
                            for (IStudyInfo iStudyInfo2 : list) {
                                if (!iStudyInfo2.getKey().equals(iStudyInfo.getKey())) continue;
                                iStudyInfo2.getAttributes().setString(3276810, VR.CS, iStudyInfo.getAttributes().getString(3276810));
                            }
                        }
                    }
                }
            } else if (iEvent.getEventID() == this.itemSelectionChangedEventId) {
                NormalizedWorklistManager.this.selectedItems.clear();
                List list = (List)iEvent.getPayload();
                if (list != null) {
                    NormalizedWorklistManager.this.selectedItems.addAll(list);
                }
            }
            return false;
        }

        public IListenerSynchronization getSync() {
            return null;
        }
    }

    private static final class RefreshWorklistService {
        private static RefreshWorklistService instance;
        private ScheduledExecutorService executor;

        private RefreshWorklistService() {
        }

        public static synchronized RefreshWorklistService get() {
            if (instance == null) {
                instance = new RefreshWorklistService();
            }
            return instance;
        }

        public synchronized void scheduleOnce(INormalizedWorklist iNormalizedWorklist, long l) {
            ScheduledExecutorService scheduledExecutorService = this.getExecutor();
            if (l > 0L) {
                scheduledExecutorService.schedule(new RefreshWorklistRunnable(iNormalizedWorklist), l, TimeUnit.MILLISECONDS);
            } else {
                scheduledExecutorService.submit(new RefreshWorklistRunnable(iNormalizedWorklist));
            }
        }

        public synchronized void schedulePeriodically(INormalizedWorklist iNormalizedWorklist) {
            this.shutdown();
            if (iNormalizedWorklist != null) {
                long l = RefreshWorklistService.getConfiguredRefreshPeriodInMinutes();
                this.getExecutor().scheduleAtFixedRate(new RefreshWorklistRunnable(iNormalizedWorklist), l, l, TimeUnit.MINUTES);
            }
        }

        public synchronized void shutdown() {
            if (this.executor != null) {
                this.executor.shutdown();
                this.executor = null;
            }
        }

        private static long getConfiguredRefreshPeriodInMinutes() {
            try {
                return ConfigurationProviderFactory.getConfig().getLong("uwl.Demo.auto-refresh-period-minutes");
            }
            catch (Exception exception) {
                return 5L;
            }
        }

        private synchronized ScheduledExecutorService getExecutor() {
            if (this.executor == null || this.executor.isShutdown()) {
                this.executor = Executors.newSingleThreadScheduledExecutor();
            }
            return this.executor;
        }

        private static final class RefreshWorklistRunnable
        implements Runnable {
            private INormalizedWorklist toRefresh;

            public RefreshWorklistRunnable(INormalizedWorklist iNormalizedWorklist) {
                this.toRefresh = iNormalizedWorklist;
            }

            @Override
            public void run() {
                try {
                    if (this.toRefresh != null) {
                        log.debug("Executing autom. refresh of worklist content...");
                        this.toRefresh.refresh();
                    }
                }
                catch (Exception exception) {
                    log.error("Failed to refresh worklist " + this.toRefresh, (Throwable)exception);
                }
            }
        }
    }
}

