/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.worklists;

import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklist;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistBundle;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistItem;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistItemWalker;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistProvider;
import com.agfa.pacs.listtext.lta.base.worklists.NormalizedWorklistProviderFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class NormalizedWorklistUtils {
    public static void initializeWorklists() {
        Collection<INormalizedWorklistProvider> collection;
        NormalizedWorklistProviderFactory normalizedWorklistProviderFactory = NormalizedWorklistProviderFactory.get();
        Collection<INormalizedWorklistProvider> collection2 = normalizedWorklistProviderFactory.getProviders(INormalizedWorklistProvider.ImplementationType.LEGACY);
        if (collection2 != null && !collection2.isEmpty()) {
            collection2.iterator().next().initialize();
        }
        if ((collection = normalizedWorklistProviderFactory.getProviders(INormalizedWorklistProvider.ImplementationType.UWL)) != null && !collection.isEmpty()) {
            collection.iterator().next().initialize();
        }
    }

    public static boolean isOfImplementationType(INormalizedWorklistProvider iNormalizedWorklistProvider, INormalizedWorklistProvider.ImplementationType implementationType) {
        return iNormalizedWorklistProvider != null && implementationType.equals((Object)iNormalizedWorklistProvider.getImplementationType());
    }

    public static boolean isOfImplementationType(INormalizedWorklistBundle iNormalizedWorklistBundle, INormalizedWorklistProvider.ImplementationType implementationType) {
        return iNormalizedWorklistBundle != null && NormalizedWorklistUtils.isOfImplementationType(iNormalizedWorklistBundle.getProvider(), implementationType);
    }

    public static boolean isOfImplementationType(INormalizedWorklist iNormalizedWorklist, INormalizedWorklistProvider.ImplementationType implementationType) {
        return iNormalizedWorklist != null && NormalizedWorklistUtils.isOfImplementationType(iNormalizedWorklist.getBundle(), implementationType);
    }

    public static boolean isOfType(INormalizedWorklist iNormalizedWorklist, String string) {
        return iNormalizedWorklist != null ? NormalizedWorklistUtils.isOfType(iNormalizedWorklist.getBundle(), string) : false;
    }

    public static boolean isOfType(INormalizedWorklistBundle iNormalizedWorklistBundle, String string) {
        return iNormalizedWorklistBundle != null ? NormalizedWorklistUtils.isOfType(iNormalizedWorklistBundle.getProvider(), string) : false;
    }

    public static boolean isOfType(INormalizedWorklistProvider iNormalizedWorklistProvider, String string) {
        return iNormalizedWorklistProvider != null ? string.equalsIgnoreCase(iNormalizedWorklistProvider.getType().getID()) : false;
    }

    public static boolean isOfScheduledType(INormalizedWorklistProvider iNormalizedWorklistProvider) {
        return iNormalizedWorklistProvider != null && iNormalizedWorklistProvider.getType().isScheduleType();
    }

    public static boolean isOfScheduledType(INormalizedWorklistBundle iNormalizedWorklistBundle) {
        return iNormalizedWorklistBundle != null && NormalizedWorklistUtils.isOfScheduledType(iNormalizedWorklistBundle.getProvider());
    }

    public static boolean isOfScheduledType(INormalizedWorklist iNormalizedWorklist) {
        return iNormalizedWorklist != null && NormalizedWorklistUtils.isOfScheduledType(iNormalizedWorklist.getBundle());
    }

    public static INormalizedWorklistItem findItem(INormalizedWorklist iNormalizedWorklist, String string) {
        INormalizedWorklistItemWalker iNormalizedWorklistItemWalker = iNormalizedWorklist.createItemWalker();
        if (iNormalizedWorklistItemWalker != null) {
            while (iNormalizedWorklistItemWalker.hasNextItem()) {
                INormalizedWorklistItem iNormalizedWorklistItem = iNormalizedWorklistItemWalker.getNextItem();
                if (iNormalizedWorklistItem == null || !iNormalizedWorklistItem.getID().equals(string)) continue;
                return iNormalizedWorklistItem;
            }
        }
        return null;
    }

    public static INormalizedWorklistItem findNextItem(INormalizedWorklist iNormalizedWorklist, String string) {
        INormalizedWorklistItemWalker iNormalizedWorklistItemWalker = iNormalizedWorklist.createItemWalker();
        if (iNormalizedWorklistItemWalker != null) {
            INormalizedWorklistItem iNormalizedWorklistItem = null;
            while (iNormalizedWorklistItemWalker.hasNextItem() && iNormalizedWorklistItem == null) {
                INormalizedWorklistItem iNormalizedWorklistItem2 = iNormalizedWorklistItemWalker.getNextItem();
                if (iNormalizedWorklistItem2 == null || !iNormalizedWorklistItem2.getID().equals(string)) continue;
                iNormalizedWorklistItem = iNormalizedWorklistItem2;
            }
            if (iNormalizedWorklistItem != null) {
                return iNormalizedWorklistItemWalker.getNextItem();
            }
        }
        return null;
    }

    public static INormalizedWorklistItem findPreviousItem(INormalizedWorklist iNormalizedWorklist, String string) {
        INormalizedWorklistItemWalker iNormalizedWorklistItemWalker = iNormalizedWorklist.createItemWalker();
        if (iNormalizedWorklistItemWalker != null) {
            INormalizedWorklistItem iNormalizedWorklistItem = null;
            while (iNormalizedWorklistItemWalker.hasNextItem() && iNormalizedWorklistItem == null) {
                INormalizedWorklistItem iNormalizedWorklistItem2 = iNormalizedWorklistItemWalker.getNextItem();
                if (iNormalizedWorklistItem2 == null || !iNormalizedWorklistItem2.getID().equals(string)) continue;
                iNormalizedWorklistItem = iNormalizedWorklistItem2;
            }
            if (iNormalizedWorklistItem != null) {
                return iNormalizedWorklistItemWalker.getPreviousItem();
            }
        }
        return null;
    }

    public static List<IDataInfo> toDataInfos(List<? extends INormalizedWorklistItem> list) {
        if (list != null) {
            ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
            for (INormalizedWorklistItem iNormalizedWorklistItem : list) {
                List<? extends IDataInfo> list2 = iNormalizedWorklistItem.getDataInfos();
                if (list2 == null) continue;
                arrayList.addAll(list2);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static NormalizedWorklistItemPositionInfo getItemPosition(INormalizedWorklist iNormalizedWorklist, INormalizedWorklistItem iNormalizedWorklistItem) {
        return NormalizedWorklistUtils.getItemPosition(iNormalizedWorklist, iNormalizedWorklistItem.getID());
    }

    public static NormalizedWorklistItemPositionInfo getItemPosition(INormalizedWorklist iNormalizedWorklist, String string) {
        INormalizedWorklistItemWalker iNormalizedWorklistItemWalker;
        if (iNormalizedWorklist != null && (iNormalizedWorklistItemWalker = iNormalizedWorklist.createItemWalker()) != null) {
            while (iNormalizedWorklistItemWalker.hasNextItem()) {
                INormalizedWorklistItem iNormalizedWorklistItem = iNormalizedWorklistItemWalker.getNextItem();
                if (iNormalizedWorklistItem == null || !iNormalizedWorklistItem.getID().equals(string)) continue;
                return NormalizedWorklistItemPositionInfo.currentPosition(iNormalizedWorklist, iNormalizedWorklistItemWalker);
            }
        }
        return null;
    }

    public static NormalizedWorklistItemPositionInfo getItemPositionForData(INormalizedWorklist iNormalizedWorklist, String string) {
        INormalizedWorklistItemWalker iNormalizedWorklistItemWalker;
        if (iNormalizedWorklist != null && (iNormalizedWorklistItemWalker = iNormalizedWorklist.createItemWalker()) != null) {
            while (iNormalizedWorklistItemWalker.hasNextItem()) {
                List<? extends IDataInfo> list;
                INormalizedWorklistItem iNormalizedWorklistItem = iNormalizedWorklistItemWalker.getNextItem();
                if (iNormalizedWorklistItem == null || (list = iNormalizedWorklistItem.getDataInfos()) == null || !list.stream().anyMatch(iDataInfo -> iDataInfo.getKey().equals(string))) continue;
                return NormalizedWorklistItemPositionInfo.currentPosition(iNormalizedWorklist, iNormalizedWorklistItemWalker);
            }
        }
        return null;
    }

    public static class NormalizedWorklistItemPositionInfo {
        private final INormalizedWorklist worklist;
        private final INormalizedWorklistItem previousItem;
        private final INormalizedWorklistItem nextItem;
        private final INormalizedWorklistItem item;
        private final int itemPosition;
        private final int totalItemCount;

        public NormalizedWorklistItemPositionInfo(INormalizedWorklist iNormalizedWorklist, INormalizedWorklistItem iNormalizedWorklistItem, INormalizedWorklistItem iNormalizedWorklistItem2, INormalizedWorklistItem iNormalizedWorklistItem3, int n, int n2) {
            this.worklist = iNormalizedWorklist;
            this.previousItem = iNormalizedWorklistItem;
            this.nextItem = iNormalizedWorklistItem2;
            this.item = iNormalizedWorklistItem3;
            this.itemPosition = n;
            this.totalItemCount = n2;
        }

        public static NormalizedWorklistItemPositionInfo currentPosition(INormalizedWorklist iNormalizedWorklist) {
            return NormalizedWorklistItemPositionInfo.currentPosition(iNormalizedWorklist, iNormalizedWorklist.getDefaultItemWalker());
        }

        public static NormalizedWorklistItemPositionInfo currentPosition(INormalizedWorklist iNormalizedWorklist, INormalizedWorklistItemWalker iNormalizedWorklistItemWalker) {
            if (iNormalizedWorklistItemWalker.getItemPointer() < 0 && iNormalizedWorklistItemWalker.getCurrentItem() == null) {
                return NormalizedWorklistItemPositionInfo.headPosition(iNormalizedWorklist);
            }
            return new NormalizedWorklistItemPositionInfo(iNormalizedWorklist, iNormalizedWorklistItemWalker.getPreviousItem(false), iNormalizedWorklistItemWalker.getNextItem(false), iNormalizedWorklistItemWalker.getCurrentItem(), iNormalizedWorklistItemWalker.getItemPointer(), iNormalizedWorklistItemWalker.getItemCount());
        }

        public static NormalizedWorklistItemPositionInfo headPosition(INormalizedWorklist iNormalizedWorklist) {
            INormalizedWorklistItemWalker iNormalizedWorklistItemWalker = iNormalizedWorklist.createItemWalker();
            iNormalizedWorklistItemWalker.setItemPointerToFirstItem();
            return new NormalizedWorklistItemPositionInfo(iNormalizedWorklist, null, iNormalizedWorklistItemWalker.getCurrentItem(), null, -1, iNormalizedWorklistItemWalker.getItemCount());
        }

        public static NormalizedWorklistItemPositionInfo tailPosition(INormalizedWorklist iNormalizedWorklist) {
            INormalizedWorklistItemWalker iNormalizedWorklistItemWalker = iNormalizedWorklist.createItemWalker();
            iNormalizedWorklistItemWalker.setItemPointerToLastItem();
            return new NormalizedWorklistItemPositionInfo(iNormalizedWorklist, iNormalizedWorklistItemWalker.getCurrentItem(), null, null, Integer.MAX_VALUE, iNormalizedWorklistItemWalker.getItemCount());
        }

        public static NormalizedWorklistItemPositionInfo firstItemPosition(INormalizedWorklist iNormalizedWorklist) {
            INormalizedWorklistItemWalker iNormalizedWorklistItemWalker = iNormalizedWorklist.createItemWalker();
            iNormalizedWorklistItemWalker.setItemPointerToFirstItem();
            return new NormalizedWorklistItemPositionInfo(iNormalizedWorklist, iNormalizedWorklistItemWalker.getPreviousItem(false), iNormalizedWorklistItemWalker.getNextItem(false), iNormalizedWorklistItemWalker.getCurrentItem(), iNormalizedWorklistItemWalker.getItemPointer(), iNormalizedWorklistItemWalker.getItemCount());
        }

        public static NormalizedWorklistItemPositionInfo lastItemPosition(INormalizedWorklist iNormalizedWorklist) {
            INormalizedWorklistItemWalker iNormalizedWorklistItemWalker = iNormalizedWorklist.createItemWalker();
            iNormalizedWorklistItemWalker.setItemPointerToLastItem();
            return new NormalizedWorklistItemPositionInfo(iNormalizedWorklist, iNormalizedWorklistItemWalker.getPreviousItem(false), iNormalizedWorklistItemWalker.getNextItem(false), iNormalizedWorklistItemWalker.getCurrentItem(), iNormalizedWorklistItemWalker.getItemPointer(), iNormalizedWorklistItemWalker.getItemCount());
        }

        public final INormalizedWorklist getWorklist() {
            return this.worklist;
        }

        public final INormalizedWorklistItem getPreviousItem() {
            return this.previousItem;
        }

        public final INormalizedWorklistItem getNextItem() {
            return this.nextItem;
        }

        public final INormalizedWorklistItem getItem() {
            return this.item;
        }

        public final int getItemPosition() {
            return this.itemPosition;
        }

        public final int getTotalItemCount() {
            return this.totalItemCount;
        }

        public final boolean isHeadPosition() {
            return this.itemPosition < 0 && this.item == null;
        }

        public final boolean isTailPosition() {
            return this.itemPosition >= this.totalItemCount && this.item == null;
        }

        public final boolean isFirstItemPosition() {
            return this.itemPosition == 0 && this.item != null;
        }

        public final boolean isLastItemPosition() {
            return this.itemPosition == this.totalItemCount - 1 && this.item != null;
        }

        public final boolean isNext(NormalizedWorklistItemPositionInfo normalizedWorklistItemPositionInfo) {
            return Objects.equals(this.item, normalizedWorklistItemPositionInfo.getNextItem());
        }

        public final boolean isPrevious(NormalizedWorklistItemPositionInfo normalizedWorklistItemPositionInfo) {
            return Objects.equals(this.item, normalizedWorklistItemPositionInfo.getPreviousItem());
        }
    }
}

