/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.editAttribute;

import com.agfa.pacs.base.swing.layout.RowLayout;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.hl7.HL7Utilities;
import com.agfa.pacs.data.hl7.MLLPSender;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.editAttribute.EditValueComponent;
import com.agfa.pacs.listtext.lta.editAttribute.KeywordUtils;
import com.agfa.pacs.listtext.lta.filter.dicom.customfields.DicomCustomFields;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import com.agfa.pacs.listtext.swingx.controls.JSeparator2;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.listtext.swingx.util.layout.SpringUtilities;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.permission.Permissions;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.PersonName;

public abstract class AbstractEditAttributeDialog
extends MessageDialog.ClosingCallback {
    private static final String NOT_AVAILABLE = "NA";
    private final Container parent;
    private final int tag;
    private final IDicomNode source;
    private final IDataInfo dataInfo;
    private final Attributes attributes;
    private EditValueComponent newValueComponent;

    public AbstractEditAttributeDialog(Container container, IDataInfo iDataInfo, int n, IDicomNode iDicomNode) {
        this.parent = container;
        this.dataInfo = iDataInfo;
        this.tag = n;
        this.source = iDicomNode;
        this.attributes = iDataInfo.getDicomObjectMerged();
    }

    public String getText() {
        if (this.newValueComponent != null) {
            return this.newValueComponent.getText();
        }
        return null;
    }

    protected void openEditDialog() {
        String string;
        Object object;
        Object object2;
        String string2;
        Level level;
        JPanel jPanel = new JPanel();
        String string3 = this.parent instanceof JLabel ? ((JLabel)this.parent).getText() : this.attributes.getString(this.tag);
        jPanel.setLayout(new SpringLayout());
        int n = 0;
        IDataInfo iDataInfo = this.dataInfo;
        while (iDataInfo != null) {
            level = iDataInfo.getHierarchyLevel();
            string2 = this.getDataDescription(this.attributes, level);
            object2 = null;
            object = new JLabel(string2);
            if (string2 != null) {
                if (Level.Patient == level) {
                    object2 = new JLabel(String.valueOf(Messages.getString("DataInfoLevel.PATIENT")) + ':');
                } else if (Level.Study == level) {
                    object2 = new JLabel(String.valueOf(Messages.getString("DataInfoLevel.STUDY")) + ':');
                } else if (Level.Series == level) {
                    object2 = new JLabel(String.valueOf(Messages.getString("DataInfoLevel.SERIES")) + ':');
                } else if (Level.Object == level) {
                    object2 = new JLabel(String.valueOf(Messages.getString("DataInfoLevel.OBJECT")) + ':');
                }
                if (object2 != null) {
                    ((JComponent)object).setForeground(((Component)object2).getForeground().darker());
                    jPanel.add((Component)object2, 0);
                    jPanel.add((Component)object, 1);
                    ++n;
                }
            }
            iDataInfo = iDataInfo.getTreeParent();
        }
        SpringUtilities.makeCompactGrid((Container)jPanel, (int)n, (int)2, (int)5, (int)5, (int)5, (int)5);
        level = SwingUtilities2.createSeparator((JSeparator2.SeparatorOrientation)JSeparator2.SeparatorOrientation.HORIZONTAL, (JSeparator2.SeparatorType)JSeparator2.SeparatorType.LINE, null);
        this.newValueComponent = new EditValueComponent(this.tag, string3);
        string2 = null;
        object2 = DicomCustomFields.getDefaultInstance().findField(this.tag);
        if (object2 != null) {
            string2 = object2.getName();
        }
        object = string2 != null ? string2 : DicomTagDictionaryFactory.getLocaleDictionary().getNameForTagWithPrefix(this.tag);
        JLabel jLabel = new JLabel(String.valueOf(object) + ' ' + Messages.getString("EditAttributeDialog.OldSuffix") + ':');
        String string4 = string = string3 != null ? string3 : "";
        if (this.isStudyCommentEditDialog()) {
            string = KeywordUtils.hideUserPrefixes(string);
        }
        JTextField jTextField = new JTextField(string);
        if (!NOT_AVAILABLE.equals(string4)) {
            this.newValueComponent.setText(string4);
        }
        JLabel jLabel2 = new JLabel(String.valueOf(object) + ' ' + Messages.getString("EditAttributeDialog.NewSuffix") + ':');
        jTextField.setEnabled(false);
        jLabel.setForeground(jLabel2.getForeground().darker());
        JButton jButton = SwingUtilities2.createButton((String)Messages.getString("EditKeywords.Text"));
        jButton.setVisible(this.isEditKeywordsButtonVisible());
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -1.0, -2.0}, new double[]{-2.0, -2.0, -2.0});
        tableLayout.setVGap(GUI.getScaledInt((int)4));
        JPanel jPanel2 = SwingUtilities2.createPanel((Boolean)Boolean.FALSE, null);
        jPanel2.setLayout((LayoutManager)tableLayout);
        jPanel2.add((Component)jLabel, "0,0");
        jPanel2.add((Component)jTextField, "1,0,2,0");
        jPanel2.add((Component)jLabel2, "0,1");
        jPanel2.add((Component)this.newValueComponent, "1,1,2,1");
        jPanel2.add((Component)jButton, "2,2");
        JPanel jPanel3 = SwingUtilities2.createPanel((Boolean)Boolean.FALSE, null);
        jPanel3.setLayout((LayoutManager)new RowLayout(10));
        jPanel3.add(jPanel);
        jPanel3.add((Component)level);
        jPanel3.add(jPanel2);
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)this.parent, (String)Messages.getString("EditAttributeDialog.Title"), (Object)jPanel3, (boolean)true, (int)3, (String)"OK_CANCEL_OPTION");
        jButton.addActionListener(actionEvent -> KeywordUtils.showEditKeywordsDialog((Component)messageDialog, this.newValueComponent));
        messageDialog.setClosingCallback((MessageDialog.ClosingCallback)this);
        messageDialog.setMaximumSize(GUI.getScaledDimension((int)1024, (int)600));
        messageDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                AbstractEditAttributeDialog.this.newValueComponent.requestFocusInWindow();
                AbstractEditAttributeDialog.this.newValueComponent.setCaretPosition(0);
                AbstractEditAttributeDialog.this.newValueComponent.selectAll();
            }
        });
        messageDialog.showCenteredInOwner();
    }

    private boolean isStudyCommentEditDialog() {
        return 3293184 == this.tag;
    }

    private boolean isEditKeywordsButtonVisible() {
        return this.isStudyCommentEditDialog() && KeywordUtils.useKeywords() && Permissions.getInstance().isAllowed("EditKeywords");
    }

    private String getDataDescription(Attributes attributes, Level level) {
        if (Level.Object == level) {
            return attributes.getString(524312);
        }
        if (Level.Series == level) {
            String string = attributes.getString(524384);
            String string2 = attributes.getString(528446);
            Date date = attributes.getDate(2251941548130353L);
            return this.getDataDescriptionString(string, string2, date);
        }
        if (Level.Study == level) {
            String string = attributes.getString(524385);
            String string3 = attributes.getString(528432);
            Date date = DateTimeUtils.getStudyDateTime((Attributes)attributes);
            return this.getDataDescriptionString(string, string3, date);
        }
        if (Level.Patient == level) {
            PersonName personName = new PersonName(attributes.getString(0x100010), true);
            return PersonNameUtilities.personNameToHRReverseShort((PersonName)personName);
        }
        return "";
    }

    private String getDataDescriptionString(String string, String string2, Date date) {
        StringBuilder stringBuilder = new StringBuilder();
        if (date != null) {
            stringBuilder.append(DateTimeUtils.dateTime2String((Date)date));
        }
        if (string2 != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append(string2);
        }
        if (string != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public boolean canCloseDialog(MessageDialog messageDialog) {
        boolean bl = super.canCloseDialog(messageDialog);
        if (bl && "OK_OPTION".equals(messageDialog.getSelectedOption())) {
            EventUtil.invokeNotOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (AbstractEditAttributeDialog.this.tag == 3671296) {
                        PersonName personName = new PersonName(AbstractEditAttributeDialog.this.attributes.getString(0x100010), true);
                        String string = AbstractEditAttributeDialog.this.attributes.getString(0x100020);
                        String string2 = AbstractEditAttributeDialog.this.attributes.getString(0x100021);
                        try {
                            String string3 = HL7Utilities.createPatientModificationMessage((PersonName)personName, (String)string, (String)string2, (int)AbstractEditAttributeDialog.this.tag, (Object)AbstractEditAttributeDialog.this.newValueComponent.getText(), (String)(String.valueOf(Product.getProductName()) + " " + Product.getVersionString()));
                            MLLPSender mLLPSender = new MLLPSender(AbstractEditAttributeDialog.this.source.getHost(), 2575);
                            mLLPSender.sendMessage(string3, "ISO-8859-1");
                        }
                        catch (Exception exception) {
                            ALogger.getLogger(AbstractEditAttributeDialog.class).error("Could not store patient state modification", (Throwable)exception);
                            MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)AbstractEditAttributeDialog.this.parent, (String)Messages.getString("EditAttribute.ErrorMessage.Title"), (Object)Messages.getString("EditAttribute.ErrorMessage.Text"), (boolean)true, (int)2, (String)"OK_OPTION");
                            messageDialog.showCenteredInOwner();
                        }
                    } else {
                        AbstractEditAttributeDialog.this.storeModification(AbstractEditAttributeDialog.this.attributes, AbstractEditAttributeDialog.this.tag, AbstractEditAttributeDialog.this.newValueComponent.getText(), AbstractEditAttributeDialog.this.source);
                    }
                    AbstractEditAttributeDialog.this.updateComponents();
                }
            });
        }
        return bl;
    }

    public abstract void storeModification(Attributes var1, int var2, String var3, IDicomNode var4);

    public void updateComponents() {
    }
}

