/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.editAttribute;

import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbstractInputCheckAddAction
extends AbstractAction {
    private Container parent;
    private JTextField field;

    public AbstractInputCheckAddAction(Container container) {
        super(Messages.getString("InputCheckAction.AddNewEntry"));
        this.parent = container;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        InputCheckOptionPane inputCheckOptionPane = new InputCheckOptionPane();
        int n = inputCheckOptionPane.show();
        if (n == 0 && (string = this.field.getText()) != null && !string.isEmpty()) {
            this.processResult(string);
        }
    }

    public abstract void processResult(String var1);

    private class InputCheckOptionPane {
        private final JButton okBtn = new JButton(Messages.getString("Ok"));
        private final JButton cancelBtn;
        private final JPanel panel;

        public InputCheckOptionPane() {
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionPane jOptionPane = InputCheckOptionPane.this.getOptionPane((JComponent)actionEvent.getSource());
                    jOptionPane.setValue(InputCheckOptionPane.this.okBtn);
                }
            });
            this.okBtn.setEnabled(false);
            this.cancelBtn = new JButton(Messages.getString("Cancel"));
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionPane jOptionPane = InputCheckOptionPane.this.getOptionPane((JComponent)actionEvent.getSource());
                    jOptionPane.setValue(InputCheckOptionPane.this.cancelBtn);
                }
            });
            AbstractInputCheckAddAction.this.field = SwingUtilities2.createTextField(null, null, null);
            AbstractInputCheckAddAction.this.field.addAncestorListener(new RequestFocusListener());
            AbstractInputCheckAddAction.this.field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                private void update() {
                    InputCheckOptionPane.this.okBtn.setEnabled(!AbstractInputCheckAddAction.this.field.getText().isEmpty() && !AbstractInputCheckAddAction.this.field.getText().contains(" ") && !AbstractInputCheckAddAction.this.field.getText().contains("|"));
                }
            });
            JLabel jLabel = SwingUtilities2.createLabel((String)(String.valueOf(Messages.getString("InputCheckAction.NewKeyword")) + ':'), null, null, null);
            this.panel = SwingUtilities2.createPanel((Boolean)Boolean.FALSE, null);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)jLabel, "North");
            this.panel.add((Component)AbstractInputCheckAddAction.this.field, "Center");
        }

        private JOptionPane getOptionPane(JComponent jComponent) {
            return jComponent instanceof JOptionPane ? (JOptionPane)jComponent : this.getOptionPane((JComponent)jComponent.getParent());
        }

        int show() {
            return JOptionPane.showOptionDialog(AbstractInputCheckAddAction.this.parent, this.panel, Messages.getString("InputCheckAction.EnterKeyword.Title"), 2, -1, null, new Object[]{this.okBtn, this.cancelBtn}, this.okBtn);
        }
    }

    public static class RequestFocusListener
    implements AncestorListener {
        @Override
        public void ancestorAdded(final AncestorEvent ancestorEvent) {
            final RequestFocusListener requestFocusListener = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JComponent jComponent = ancestorEvent.getComponent();
                    jComponent.requestFocusInWindow();
                    jComponent.removeAncestorListener(requestFocusListener);
                }
            });
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }
}

