/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.editAttribute;

import com.agfa.pacs.base.swing.monitor.MonitorConfiguration;
import com.agfa.pacs.listtext.lta.editAttribute.Keyword;
import com.agfa.pacs.listtext.lta.editAttribute.KeywordCellRenderer;
import com.agfa.pacs.listtext.lta.editAttribute.MultiSelectionDisplayingComboBox;
import com.agfa.pacs.listtext.swingx.controls.CaseInsensitiveComparator;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AutoCompletion
implements DocumentListener {
    private static final ALogger LOGGER = ALogger.getLogger(AutoCompletion.class);
    private JTextField textField;
    private Color foregroundColor;
    private final List<Keyword> keywordList = new ArrayList<Keyword>();
    private JPopupMenu popupMenu;
    private JList<Keyword> menuList;
    private JScrollPane scrollPane;
    private MultiSelectionDisplayingComboBox component;
    private DefaultListModel<Keyword> listModel;

    public AutoCompletion(List<Keyword> list, MultiSelectionDisplayingComboBox multiSelectionDisplayingComboBox) {
        this.keywordList.addAll(list);
        this.component = multiSelectionDisplayingComboBox;
        this.textField = multiSelectionDisplayingComboBox.getTextField();
        this.foregroundColor = this.textField.getForeground();
        this.popupMenu = new JPopupMenu();
        this.listModel = new DefaultListModel();
        this.menuList = SwingUtilities2.createList(this.listModel);
        this.menuList.setOpaque(false);
        this.menuList.setBackground(this.popupMenu.getBackground());
        this.menuList.setVisibleRowCount(13);
        this.menuList.setSelectionMode(0);
        this.menuList.addKeyListener(new MenuKeyListener());
        this.menuList.addMouseListener(new MouseSelectionListener());
        this.menuList.addMouseMotionListener(new MouseSelectionListener());
        this.menuList.setCellRenderer(new KeywordCellRenderer());
        this.scrollPane = SwingUtilities2.createScrollPane(null, (Integer)20, (Integer)31, (Boolean)true, (Boolean)false);
        Collections.sort(list, new CaseInsensitiveComparator());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkKeywords(documentEvent, false);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkKeywords(documentEvent, true);
    }

    void processKeyEvent(KeyEvent keyEvent) {
        if (this.popupMenu != null && this.popupMenu.isVisible()) {
            SwingUtilities.getWindowAncestor(this.menuList).toFront();
            this.menuList.requestFocusInWindow();
            this.menuList.dispatchEvent(keyEvent);
        }
    }

    void hidePopupMenu() {
        if (this.popupMenu != null) {
            this.popupMenu.setVisible(false);
        }
    }

    private void checkKeywords(DocumentEvent documentEvent, boolean bl) {
        if (documentEvent.getLength() != 1) {
            return;
        }
        int n = documentEvent.getOffset();
        String string = null;
        int n2 = bl ? n + 1 : n;
        try {
            string = this.textField.getText(0, n2);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to get text from text field", (Throwable)exception);
        }
        List<Keyword> list = this.searchForMatchingKeywords(string);
        this.showKeywordsAsPopup(list);
    }

    private List<Keyword> searchForMatchingKeywords(String string) {
        ArrayList<Keyword> arrayList = new ArrayList<Keyword>();
        for (Keyword keyword : this.keywordList) {
            if (!this.startsWithIgnoreCase(keyword.getKeyword(), string)) continue;
            arrayList.add(keyword);
        }
        Collections.sort(arrayList, new CaseInsensitiveComparator());
        return arrayList;
    }

    private void showKeywordsAsPopup(List<Keyword> list) {
        this.popupMenu.removeAll();
        this.popupMenu.setVisible(false);
        this.listModel.removeAllElements();
        if (!list.isEmpty() && list.size() < this.keywordList.size()) {
            Object object;
            this.textField.setForeground(this.foregroundColor);
            int n = 0;
            while (n < list.size()) {
                object = list.get(n);
                this.listModel.addElement((Keyword)object);
                ++n;
            }
            if (list.size() > this.menuList.getVisibleRowCount()) {
                this.scrollPane.setViewportView(this.menuList);
                this.popupMenu.add(this.scrollPane);
            } else {
                this.scrollPane.setViewportView(null);
                this.popupMenu.add(this.menuList);
            }
            Point point = this.textField.getLocationOnScreen();
            object = this.popupMenu.getPreferredSize();
            Rectangle rectangle = MonitorConfiguration.getConfiguration().getBoundsOfScreenWithPoint(point);
            if (rectangle.height <= point.y + ((Dimension)object).height) {
                this.popupMenu.setLocation(point.x, this.textField.getLocationOnScreen().y - ((Dimension)object).height);
                this.popupMenu.setVisible(true);
            } else {
                int n2 = (int)this.textField.getPreferredSize().getHeight();
                this.popupMenu.show(this.textField, 0, n2);
            }
        } else if (!this.textField.getText().isEmpty()) {
            this.textField.setForeground(Color.red);
        } else {
            this.textField.setForeground(this.foregroundColor);
        }
        SwingUtilities.getWindowAncestor(this.textField).toFront();
        this.textField.requestFocusInWindow();
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        return string.toUpperCase(Locale.getDefault()).startsWith(string2.toUpperCase(Locale.getDefault()));
    }

    private void addSelectedEntry() {
        Keyword keyword = this.menuList.getSelectedValue();
        if (keyword != null) {
            this.component.addCloseableEntry(keyword.getKeyword(), keyword.getUserPrefix());
            this.popupMenu.setVisible(false);
        }
    }

    private class MenuKeyListener
    extends KeyAdapter {
        private MenuKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                AutoCompletion.this.addSelectedEntry();
            }
        }
    }

    private class MouseSelectionListener
    extends MouseAdapter {
        private MouseSelectionListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            AutoCompletion.this.addSelectedEntry();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = AutoCompletion.this.menuList.locationToIndex(mouseEvent.getPoint());
            if (n > -1) {
                AutoCompletion.this.menuList.setSelectedIndex(n);
            }
        }
    }
}

