/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.editAttribute;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.lta.editAttribute.KeywordUtils;
import com.agfa.pacs.listtext.lta.editAttribute.MultiSelectionDisplayingComboBox;
import com.agfa.pacs.listtext.lta.filter.FilterSelectionSets;
import com.agfa.pacs.listtext.lta.filter.IFilterSelectionSetItem;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class EditValueComponent
extends JPanel {
    private static final int COMPONENT_WIDTH = GUI.getScaledInt((int)200);
    private int tag;
    private Object value;
    private JComponent valueComponent;

    public EditValueComponent(int n, Object object) {
        this.tag = n;
        this.value = object;
        this.valueComponent = this.createEditValueComponent();
        this.setLayout(new BorderLayout());
        this.add((Component)this.valueComponent, "North");
    }

    @Override
    public boolean requestFocusInWindow() {
        JComponent jComponent = this.valueComponent;
        if (jComponent instanceof MultiSelectionDisplayingComboBox) {
            jComponent = ((MultiSelectionDisplayingComboBox)this.valueComponent).getTextField();
        }
        if (jComponent != null) {
            SwingUtilities.getWindowAncestor(jComponent).toFront();
            return jComponent.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    void setCaretPosition(int n) {
        if (this.valueComponent instanceof JTextField) {
            ((JTextField)this.valueComponent).setCaretPosition(n);
        }
    }

    void selectAll() {
        if (this.valueComponent instanceof JTextField) {
            ((JTextField)this.valueComponent).selectAll();
        }
    }

    void setText(String string) {
        if (this.valueComponent instanceof JTextField) {
            ((JTextField)this.valueComponent).setText(string);
        } else if (this.valueComponent instanceof MultiSelectionDisplayingComboBox) {
            ((MultiSelectionDisplayingComboBox)this.valueComponent).setText(string);
        }
    }

    String getText() {
        if (this.valueComponent instanceof JTextField) {
            return ((JTextField)this.valueComponent).getText();
        }
        if (this.valueComponent instanceof JComboBox) {
            return ((IFilterSelectionSetItem)((JComboBox)this.valueComponent).getSelectedItem()).getValue();
        }
        if (this.valueComponent instanceof MultiSelectionDisplayingComboBox) {
            return ((MultiSelectionDisplayingComboBox)this.valueComponent).getText();
        }
        return null;
    }

    private JComponent createEditValueComponent() {
        if (3293184 == this.tag) {
            return this.getStudyCommentsComponent();
        }
        if (1179762 == this.tag) {
            return this.getComboBox();
        }
        return this.getTextField();
    }

    private JComponent getStudyCommentsComponent() {
        if (KeywordUtils.useKeywords()) {
            String string;
            MultiSelectionDisplayingComboBox multiSelectionDisplayingComboBox = new MultiSelectionDisplayingComboBox(KeywordUtils.getAllConfiguredKeywords());
            if (this.valueComponent != null && StringUtils.isNotEmpty((CharSequence)(string = ((MultiSelectionDisplayingComboBox)this.valueComponent).getText()))) {
                multiSelectionDisplayingComboBox.setText(string);
            }
            return multiSelectionDisplayingComboBox;
        }
        return this.getTextField();
    }

    private JComponent getTextField() {
        JTextField jTextField = SwingUtilities2.createTextField((String)(this.value != null ? this.value.toString() : null), null, null);
        this.setPreferredSize(new Dimension(COMPONENT_WIDTH, ((JComponent)jTextField).getPreferredSize().height));
        return jTextField;
    }

    private JComponent getComboBox() {
        JComboBox jComboBox = SwingUtilities2.createComboBox((Object[])FilterSelectionSets.CLINICAL_TRIAL_SERIES_DECRIPTION_SELECTION_SET.getSelectionItems(), null);
        this.setPreferredSize(new Dimension(COMPONENT_WIDTH, jComboBox.getPreferredSize().height));
        return jComboBox;
    }

    void reset() {
        this.remove(this.valueComponent);
        this.valueComponent = this.createEditValueComponent();
        this.add((Component)this.valueComponent, "North");
        this.getParent().revalidate();
        this.getParent().repaint();
    }
}

