/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.editAttribute;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.editAttribute.AbstractInputCheckAddAction;
import com.agfa.pacs.listtext.lta.editAttribute.KeywordUtils;
import com.agfa.pacs.listtext.swingx.controls.CaseInsensitiveComparator;
import com.agfa.pacs.listtext.swingx.layout.RowLayout;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.collections4.CollectionUtils;

public class EditableListComponent
extends JPanel {
    private static final IConfigurationProvider CONFIG_PROVIDER = ConfigurationProviderFactory.getConfig();
    private final String configKey;
    private boolean saveImmediately;
    private boolean considerUserPrefix;
    private JScrollPane scrollPane;
    private JButton addKeywordBtn;
    private JButton deleteKeywordBtn;
    private DefaultListModel<String> listModel;

    public EditableListComponent(String string, Dimension dimension, boolean bl) {
        this(string, dimension, false, bl);
    }

    public EditableListComponent(String string, Dimension dimension, boolean bl, boolean bl2) {
        this.configKey = string;
        this.saveImmediately = bl;
        this.considerUserPrefix = bl2;
        this.createPanel(dimension);
    }

    public JComponent getListScrollPane() {
        return this.scrollPane;
    }

    public JButton getAddButton() {
        return this.addKeywordBtn;
    }

    public JButton getDeleteButton() {
        return this.deleteKeywordBtn;
    }

    private void createPanel(Dimension dimension) {
        if (this.configKey != null) {
            String string = CONFIG_PROVIDER.exists(this.configKey) ? CONFIG_PROVIDER.getString(this.configKey) : null;
            ArrayList<String> arrayList = new ArrayList<String>();
            this.listModel = new DefaultListModel();
            if (string != null) {
                arrayList.addAll(KeywordUtils.convertStringIntoList(string, this.considerUserPrefix));
                Collections.sort(arrayList, new CaseInsensitiveComparator());
                for (String object2 : arrayList) {
                    this.listModel.addElement(object2);
                }
            }
            JList jList = SwingUtilities2.createList(this.listModel);
            this.scrollPane = SwingUtilities2.createScrollPane((Component)jList, (Integer)20, (Integer)30, (Boolean)true, (Boolean)true);
            if (dimension != null) {
                this.scrollPane.setPreferredSize(dimension);
            }
            KeywordInputCheckAddAction keywordInputCheckAddAction = new KeywordInputCheckAddAction(jList, this.listModel);
            DeleteKeywordAction deleteKeywordAction = new DeleteKeywordAction(jList, this.listModel);
            this.addKeywordBtn = SwingUtilities2.createButton((Action)keywordInputCheckAddAction);
            this.deleteKeywordBtn = SwingUtilities2.createButton((Action)deleteKeywordAction);
            JPanel jPanel = SwingUtilities2.createPanel((Boolean)Boolean.FALSE, null);
            jPanel.setLayout((LayoutManager)new RowLayout(2));
            jPanel.add(this.addKeywordBtn);
            jPanel.add(this.deleteKeywordBtn);
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.scrollPane, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.add(Box.createHorizontalStrut(4), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)jPanel, gridBagConstraints);
        }
    }

    public void saveChanges() {
        if (this.configKey != null) {
            String string = KeywordUtils.convertListIntoString(Collections.list(this.listModel.elements()), this.considerUserPrefix);
            CONFIG_PROVIDER.setString(this.configKey, string);
        }
    }

    private class DeleteKeywordAction
    extends AbstractAction {
        private JList<?> list;
        private DefaultListModel<String> listModel;

        public DeleteKeywordAction(JList<?> jList, DefaultListModel<String> defaultListModel) {
            super(Messages.getString("InputCheckAction.DeleteEntry"));
            this.list = jList;
            this.listModel = defaultListModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            List<?> list = this.list.getSelectedValuesList();
            if (!CollectionUtils.isEmpty(list) && (n = JOptionPane.showOptionDialog(this.list, Messages.getString("InputCheckAction.DeleteQuestion"), Messages.getString("InputCheckAction.ConfirmDelete.Title"), 0, 3, null, null, 1)) == 0) {
                for (Object obj : list) {
                    this.listModel.removeElement(obj);
                }
                if (this.listModel.getSize() > 0) {
                    this.list.setSelectedIndex(0);
                }
                if (EditableListComponent.this.saveImmediately) {
                    EditableListComponent.this.saveChanges();
                }
            }
        }
    }

    private class KeywordInputCheckAddAction
    extends AbstractInputCheckAddAction {
        private JList<String> list;
        private DefaultListModel<String> listModel;

        public KeywordInputCheckAddAction(JList<String> jList, DefaultListModel<String> defaultListModel) {
            super(jList);
            this.list = jList;
            this.listModel = defaultListModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            if (EditableListComponent.this.saveImmediately) {
                EditableListComponent.this.saveChanges();
            }
        }

        @Override
        public void processResult(String string) {
            if (string != null) {
                int n = Collections.binarySearch(Collections.list(this.listModel.elements()), string);
                if (n < 0) {
                    n = -n - 1;
                }
                this.listModel.insertElementAt(string, n);
                this.list.setSelectedIndex(n);
            }
        }
    }
}

