/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.editAttribute;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.listtext.lta.base.LTAComponentFactory;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.editAttribute.EditValueComponent;
import com.agfa.pacs.listtext.lta.editAttribute.EditableListComponent;
import com.agfa.pacs.listtext.lta.editAttribute.Keyword;
import com.agfa.pacs.listtext.swingx.controls.CaseInsensitiveComparator;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.login.URLProviderFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;

public class KeywordUtils {
    private static final String USE_KEYWORDS = "listtext.keywords.useKeywords";
    private static final String CONFIGURED_KEYWORDS = "listtext.keywords.configuredKeywords";
    private static final String CONFIGURED_USER_KEYWORDS = "listtext.keywords.configuredUserKeywords";
    private static final String DELIMITER = " ";
    private static final PIconFactory ICON_FACTORY = new PIconFactory((IComponentFactory)LTAComponentFactory.instance, 14);
    private static final PIcon USER_ICON = ICON_FACTORY.loadIcon(KeywordUtils.class, "User.svg");
    private static final PIcon ROLE_ICON = ICON_FACTORY.loadIcon(KeywordUtils.class, "Role.svg");

    public static List<String> convertStringIntoList(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> list = Arrays.asList(string.split(DELIMITER));
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                int n = string2.indexOf(124);
                if (n >= 0 && n < string2.length() - 1) {
                    string2 = string2.substring(n + 1, string2.length());
                }
                arrayList.add(string2);
            }
            return arrayList;
        }
        return list;
    }

    public static void showEditKeywordsDialog(Component component) {
        KeywordUtils.showEditKeywordsDialog(component, null);
    }

    public static void showEditKeywordsDialog(Component component, EditValueComponent editValueComponent) {
        boolean bl = ConfigurationProviderFactory.getConfig().getRole() == null;
        String string = bl ? CONFIGURED_USER_KEYWORDS : CONFIGURED_KEYWORDS;
        Dimension dimension = new Dimension(GUI.getScaledDiagnosticInt((int)350), GUI.getScaledInt((int)240));
        EditableListComponent editableListComponent = new EditableListComponent(string, dimension, bl);
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)component, (String)Messages.getString("EditKeywords.Title"), (Object)editableListComponent, (boolean)true, (int)3, (String)"OK_CANCEL_OPTION");
        messageDialog.showCenteredInOwner();
        if ("OK_OPTION".equals(messageDialog.getSelectedOption())) {
            editableListComponent.saveChanges();
            if (editValueComponent != null) {
                editValueComponent.reset();
            }
        }
    }

    public static String hideUserPrefixes(String string) {
        List<String> list = Arrays.asList(string.split(DELIMITER));
        String string2 = KeywordUtils.getEncodedUserId();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : list) {
            int n = string3.indexOf(124);
            if (n >= 0 && n < string3.length() - 1) {
                String string4 = string3.substring(0, n);
                if (!string2.equals(string4)) continue;
                string3 = string3.substring(n + 1, string3.length());
                arrayList.add(string3);
                continue;
            }
            arrayList.add(string3);
        }
        return KeywordUtils.convertListIntoString(arrayList);
    }

    public static List<Keyword> getAllConfiguredKeywords() {
        PIcon pIcon;
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        IConfigurationList iConfigurationList = iConfigurationProvider.getList(CONFIGURED_KEYWORDS);
        String string = iConfigurationProvider.getString(CONFIGURED_USER_KEYWORDS);
        ArrayList<Keyword> arrayList = new ArrayList<Keyword>();
        boolean bl = false;
        if (iConfigurationList != null && !iConfigurationList.isEmpty()) {
            bl = string != null && !string.isEmpty();
            pIcon = bl ? ROLE_ICON : null;
            for (PIcon pIcon2 : iConfigurationList) {
                String string2 = pIcon2.getString("name");
                arrayList.add(new Keyword(string2, pIcon, null));
            }
        }
        if (string != null) {
            PIcon pIcon2;
            pIcon = KeywordUtils.convertStringIntoList(string, true);
            pIcon2 = bl ? USER_ICON : null;
            String string3 = KeywordUtils.getEncodedUserId();
            for (String string2 : pIcon) {
                arrayList.add(new Keyword(string2, pIcon2, string3));
            }
        }
        Collections.sort(arrayList, new CaseInsensitiveComparator());
        return arrayList;
    }

    public static boolean useKeywords() {
        return ConfigurationProviderFactory.getConfig().getBoolean(USE_KEYWORDS);
    }

    public static boolean showIcons() {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        IConfigurationList iConfigurationList = iConfigurationProvider.getList(CONFIGURED_KEYWORDS);
        String string = iConfigurationProvider.getString(CONFIGURED_USER_KEYWORDS);
        if (iConfigurationList != null && !iConfigurationList.isEmpty()) {
            return string != null && !string.isEmpty();
        }
        return false;
    }

    public static Keyword getMatchingKeyword(String string, boolean bl) {
        Keyword keyword = null;
        if (string != null) {
            String string2 = string.trim();
            String string3 = null;
            List<Keyword> list = KeywordUtils.getAllConfiguredKeywords();
            for (Keyword keyword2 : list) {
                if (!string2.equalsIgnoreCase(keyword2.getKeyword())) continue;
                string3 = keyword2.getUserPrefix();
                keyword = keyword2;
                if (bl && !string3.isEmpty() || !bl && string3.isEmpty()) break;
            }
        }
        return keyword;
    }

    static String getKeywordUserPrefix(String string) {
        int n;
        if (string != null && (n = string.indexOf(124)) >= 0 && n < string.length() - 1) {
            return string.substring(0, n);
        }
        return null;
    }

    static String getKeyword(String string) {
        int n;
        if (string != null && (n = string.indexOf(124)) >= 0 && n < string.length() - 1) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    static String convertListIntoString(List<String> list) {
        return KeywordUtils.convertListIntoString(list, false);
    }

    static String convertListIntoString(List<String> list, boolean bl) {
        if (list != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : list) {
                if (bl) {
                    stringBuilder.append(KeywordUtils.getEncodedUserId());
                    stringBuilder.append('|');
                }
                stringBuilder.append(string);
                stringBuilder.append(DELIMITER);
            }
            return stringBuilder.toString().trim();
        }
        return "";
    }

    static String getEncodedUserId() {
        String string = URLProviderFactory.getProvider().getLoginInformation().getUserID();
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        String string2 = Base64.getEncoder().encodeToString(BigInteger.valueOf(cRC32.getValue()).toByteArray());
        if (string2.length() > 6) {
            string2 = string2.substring(0, 6);
        }
        return string2;
    }
}

