/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.editAttribute;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.monitor.MonitorConfiguration;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.lta.base.LTAComponentFactory;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.editAttribute.AutoCompletion;
import com.agfa.pacs.listtext.lta.editAttribute.Keyword;
import com.agfa.pacs.listtext.lta.editAttribute.KeywordCellRenderer;
import com.agfa.pacs.listtext.lta.editAttribute.KeywordUtils;
import com.agfa.pacs.listtext.swingx.controls.ArrowIcon;
import com.agfa.pacs.listtext.swingx.controls.CaseInsensitiveComparator;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class MultiSelectionDisplayingComboBox
extends JPanel {
    private static final PIconFactory ICON_FACTORY = new PIconFactory((IComponentFactory)LTAComponentFactory.instance, 14);
    private static final PIcon REMOVE_ICON = ICON_FACTORY.loadIcon(MultiSelectionDisplayingComboBox.class, "CloseEntry.svg");
    private static final Icon ARROW_ICON = ArrowIcon.getDownArrowIcon((Color)Color.white);
    private static final int LINE_WIDTH = GUI.getScaledInt((int)400);
    private static final short DEFAULT_LINES = 3;
    private List<Keyword> keywordList;
    private int lineHeight;
    private Color textColor;
    private JPopupMenu popupMenu;
    private JList<Keyword> menuList;
    private JScrollPane popupScrollPane;
    private JPanel textPanel;
    private JTextField textField;
    private List<ClosableEntry> visibleClosableEntries;
    private List<ClosableEntry> allClosableEntries;
    private AutoCompletion autoCompletion;
    private Dimension selectionPanelDimension = new Dimension(0, 0);
    private Dimension defaultTfDimension;
    private int textFieldLines = 1;
    private int accumulatedEntryWidth = 0;
    private JPopupMenu contextMenu;
    private JList<String> contextMenuList;
    private String cmRemoveEntry;

    public MultiSelectionDisplayingComboBox(List<Keyword> list) {
        this.keywordList = list;
        this.createComponents();
    }

    private void createComponents() {
        this.removeAll();
        Collections.sort(this.keywordList, new CaseInsensitiveComparator());
        this.visibleClosableEntries = new ArrayList<ClosableEntry>();
        this.allClosableEntries = new ArrayList<ClosableEntry>();
        this.textField = SwingUtilities2.createTextField(null, null, null);
        this.textField.addKeyListener(new EntryKeyListener());
        Dimension dimension = this.textField.getPreferredSize();
        this.lineHeight = (int)(dimension.getHeight() + (double)GUI.getScaledDiagnosticInt((int)4));
        this.defaultTfDimension = new Dimension(LINE_WIDTH, this.lineHeight);
        this.textField.setPreferredSize(this.defaultTfDimension);
        this.textField.setBorder(BorderFactory.createEmptyBorder(0, GUI.getScaledInt((int)5), 0, GUI.getScaledInt((int)5)));
        this.textColor = new Color(this.textField.getForeground().getRGB());
        this.textPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.textPanel.setBackground(new Color(this.textField.getBackground().getRGB()));
        this.textPanel.add(this.textField);
        Dimension dimension2 = new Dimension(LINE_WIDTH, this.lineHeight * 3);
        this.textPanel.setPreferredSize(dimension2);
        JScrollPane jScrollPane = SwingUtilities2.createScrollPane((Component)this.textPanel, (Integer)20, (Integer)31, (Boolean)true, (Boolean)true);
        jScrollPane.setPreferredSize(new Dimension(LINE_WIDTH, (this.lineHeight + GUI.getScaledInt((int)2)) * 3 + GUI.getScaledInt((int)6)));
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(GUI.getScaledInt((int)3), GUI.getScaledInt((int)2), GUI.getScaledInt((int)3), 0));
        DefaultListModel<Keyword> defaultListModel = new DefaultListModel<Keyword>();
        for (Keyword object2 : this.keywordList) {
            defaultListModel.addElement(object2);
        }
        this.popupMenu = new JPopupMenu();
        this.menuList = SwingUtilities2.createList(defaultListModel);
        this.menuList.setOpaque(false);
        this.menuList.setBackground(this.popupMenu.getBackground());
        this.menuList.setSelectionMode(0);
        this.menuList.setCellRenderer(new KeywordCellRenderer());
        if (!defaultListModel.isEmpty()) {
            this.menuList.addMouseListener(new MouseSelectionListener());
            this.menuList.addMouseMotionListener(new MouseSelectionListener());
            this.menuList.addKeyListener(new MenuKeyListener());
        }
        this.popupScrollPane = SwingUtilities2.createScrollPane(null, (Integer)20, (Integer)31, (Boolean)true, (Boolean)false);
        this.popupScrollPane.setViewportView(this.menuList);
        this.popupMenu.add(this.popupScrollPane);
        JButton jButton = new JButton(ARROW_ICON);
        jButton.addActionListener(new ArrowButtonActionListener(jButton));
        this.autoCompletion = new AutoCompletion(this.keywordList, this);
        this.textField.getDocument().addDocumentListener(this.autoCompletion);
        this.initContextMenuComponents();
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jButton, "After");
        this.setBorder(BorderFactory.createEmptyBorder(0, GUI.getScaledInt((int)-3), 0, GUI.getScaledDiagnosticInt((int)-1)));
        this.textField.requestFocusInWindow();
    }

    public String getText() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        Collections.sort(this.allClosableEntries, new CaseInsensitiveComparator());
        Object object2 = this.allClosableEntries.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            String string = ((ClosableEntry)object).getUserPrefix();
            if (StringUtils.isNotBlank((CharSequence)string)) {
                stringBuilder.append(string);
                stringBuilder.append('|');
            }
            stringBuilder.append(((ClosableEntry)object).getText());
            stringBuilder.append(' ');
        }
        object = KeywordUtils.getMatchingKeyword(this.textField.getText().trim(), true);
        if (object != null) {
            if (StringUtils.isNotBlank((CharSequence)((Keyword)object).getUserPrefix())) {
                stringBuilder.append(((Keyword)object).getUserPrefix());
                stringBuilder.append('|');
            }
            stringBuilder.append(((Keyword)object).getKeyword());
        }
        if (((String)(object2 = stringBuilder.toString())).isEmpty()) {
            return "";
        }
        return ((String)object2).trim();
    }

    void setText(String string) {
        String string2 = KeywordUtils.getEncodedUserId();
        String[] stringArray = string.split(" ");
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].trim().isEmpty()) {
                String string3 = stringArray[n].trim();
                String string4 = KeywordUtils.getKeywordUserPrefix(string3);
                String string5 = KeywordUtils.getKeyword(string3);
                boolean bl = true;
                if (string4 != null && !string4.isEmpty() && !string2.equals(string4)) {
                    bl = false;
                }
                this.addCloseableEntry(string5, string4, bl);
            }
            ++n;
        }
        this.autoCompletion.hidePopupMenu();
    }

    JTextField getTextField() {
        return this.textField;
    }

    private void initContextMenuComponents() {
        this.contextMenu = new JPopupMenu();
        this.cmRemoveEntry = Messages.getString("EditAttributeDialog.Remove");
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(this.cmRemoveEntry);
        this.contextMenuList = new JList(defaultListModel);
        this.contextMenuList.setBackground(this.contextMenu.getBackground());
        this.contextMenu.add(this.contextMenuList);
    }

    private void resetSizes(ClosableEntry closableEntry, boolean bl) {
        Dimension dimension = closableEntry.getPreferredSize();
        int n = (int)dimension.getWidth();
        int n2 = 1;
        if (!bl) {
            n2 = -1;
        }
        Dimension dimension2 = new Dimension((int)this.selectionPanelDimension.getWidth() + n * n2, this.lineHeight);
        this.selectionPanelDimension.setSize(dimension2);
        this.setTextPanelSize();
    }

    private void setTextPanelSize() {
        int n = 1;
        int n2 = (int)this.textField.getPreferredSize().getWidth();
        for (ClosableEntry closableEntry : this.visibleClosableEntries) {
            if ((n2 = (int)((double)n2 + closableEntry.getPreferredSize().getWidth())) <= LINE_WIDTH) continue;
            ++n;
            n2 = closableEntry.getPreferredSize().width;
        }
        int n3 = n > 3 ? n : 3;
        Dimension dimension = new Dimension(LINE_WIDTH, this.lineHeight * n3);
        this.textPanel.setPreferredSize(dimension);
    }

    private void setTextFieldSize(ClosableEntry closableEntry) {
        int n = LINE_WIDTH - this.accumulatedEntryWidth;
        if (this.textFieldLines > 3) {
            Dimension dimension = new Dimension(LINE_WIDTH, this.lineHeight * this.textFieldLines);
            this.textPanel.setPreferredSize(dimension);
        }
        if (n <= 0) {
            this.accumulatedEntryWidth = (int)closableEntry.getPreferredSize().getWidth();
            n = LINE_WIDTH - this.accumulatedEntryWidth;
        }
        if (n > 80) {
            this.textField.setPreferredSize(new Dimension(n, (int)this.textField.getPreferredSize().getHeight()));
        } else {
            this.textField.setPreferredSize(this.defaultTfDimension);
            this.accumulatedEntryWidth = 0;
        }
    }

    private void addCloseableEntry(String string, String string2, boolean bl) {
        ClosableEntry closableEntry = new ClosableEntry(string, string2, bl);
        this.allClosableEntries.add(closableEntry);
        if (closableEntry.isEntryVisible()) {
            this.visibleClosableEntries.add(closableEntry);
            this.resetSizes(closableEntry, true);
            this.accumulatedEntryWidth = (int)((double)this.accumulatedEntryWidth + closableEntry.getPreferredSize().getWidth());
            this.setTextFieldSize(closableEntry);
            this.textPanel.remove(this.textField);
            this.textPanel.add(closableEntry);
            this.textPanel.add(this.textField);
            this.textField.setText("");
            this.textField.setForeground(this.textColor);
            this.textField.requestFocus();
            this.revalidate();
            this.repaint();
        }
    }

    void addCloseableEntry(String string, String string2) {
        this.addCloseableEntry(string, string2, true);
    }

    private void removeClosableEntry(ClosableEntry closableEntry) {
        this.textPanel.remove(closableEntry);
        this.visibleClosableEntries.remove(closableEntry);
        this.allClosableEntries.remove(closableEntry);
        this.accumulatedEntryWidth = (int)((double)this.accumulatedEntryWidth - closableEntry.getPreferredSize().getWidth());
        if (this.accumulatedEntryWidth < 0) {
            this.accumulatedEntryWidth = 0;
        }
        this.setTextFieldSize(closableEntry);
        this.resetSizes(closableEntry, false);
        this.textField.requestFocus();
        this.revalidate();
        this.repaint();
    }

    private class ArrowButtonActionListener
    implements ActionListener {
        private JButton button;
        private Dimension preferredMenuSize;

        public ArrowButtonActionListener(JButton jButton) {
            this.button = jButton;
            this.preferredMenuSize = MultiSelectionDisplayingComboBox.this.menuList.getPreferredSize();
            Dimension dimension = MultiSelectionDisplayingComboBox.this.textPanel.getPreferredSize();
            if (this.preferredMenuSize.getWidth() < dimension.getWidth()) {
                Dimension dimension2 = new Dimension(dimension.width + jButton.getPreferredSize().width - GUI.getScaledInt((int)4), this.preferredMenuSize.height);
                MultiSelectionDisplayingComboBox.this.popupScrollPane.setPreferredSize(dimension2);
                this.preferredMenuSize = dimension2;
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MultiSelectionDisplayingComboBox.this.popupMenu.setVisible(false);
            Point point = this.button.getLocationOnScreen();
            Rectangle rectangle = MonitorConfiguration.getConfiguration().getBoundsOfScreenWithPoint(point);
            int n = point.y + (int)MultiSelectionDisplayingComboBox.this.textPanel.getPreferredSize().getHeight();
            int n2 = rectangle.height - n;
            if (n2 < this.preferredMenuSize.height) {
                MultiSelectionDisplayingComboBox.this.popupScrollPane.setPreferredSize(new Dimension(this.preferredMenuSize.width, n2 - GUI.getScaledInt((int)9)));
            } else {
                MultiSelectionDisplayingComboBox.this.popupScrollPane.setPreferredSize(this.preferredMenuSize);
            }
            MultiSelectionDisplayingComboBox.this.popupMenu.show(MultiSelectionDisplayingComboBox.this, 0, (int)MultiSelectionDisplayingComboBox.this.getPreferredSize().getHeight());
        }
    }

    private class ClosableEntry
    extends JPanel {
        private String text;
        private String userPrefix;
        private boolean isVisible;

        public ClosableEntry(String string, String string2, boolean bl) {
            this.text = string;
            this.userPrefix = string2;
            this.isVisible = bl;
            JLabel jLabel = SwingUtilities2.createLabel((String)string, null, null, null);
            jLabel.setForeground(MultiSelectionDisplayingComboBox.this.textColor);
            JButton jButton = SwingUtilities2.createButton((Icon)REMOVE_ICON);
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
            jButton.setFocusPainted(false);
            jButton.setOpaque(false);
            jButton.setPreferredSize(new Dimension(ARROW_ICON.getIconWidth() + GUI.getScaledInt((int)4), ARROW_ICON.getIconHeight() + GUI.getScaledInt((int)4)));
            this.setOpaque(false);
            this.add(jLabel);
            this.add(jButton);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(new Color(170, 170, 170))));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultiSelectionDisplayingComboBox.this.removeClosableEntry(ClosableEntry.this);
                }
            });
            this.addMouseListener(new EntryMouseListener(this));
        }

        @Override
        public String toString() {
            return this.text;
        }

        String getText() {
            return this.text;
        }

        String getUserPrefix() {
            return this.userPrefix;
        }

        boolean isEntryVisible() {
            return this.isVisible;
        }
    }

    private class ContextMenuListener
    extends MouseAdapter
    implements KeyListener {
        private ClosableEntry entry;

        public ContextMenuListener(ClosableEntry closableEntry) {
            this.entry = closableEntry;
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.removeEntry();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeEntry();
            }
        }

        private void removeEntry() {
            String string = (String)MultiSelectionDisplayingComboBox.this.contextMenuList.getSelectedValue();
            if (string != null && string.equals(MultiSelectionDisplayingComboBox.this.cmRemoveEntry)) {
                MultiSelectionDisplayingComboBox.this.removeClosableEntry(this.entry);
            }
            MultiSelectionDisplayingComboBox.this.contextMenu.setVisible(false);
            MultiSelectionDisplayingComboBox.this.contextMenuList.removeKeyListener(this);
            MultiSelectionDisplayingComboBox.this.contextMenuList.removeMouseListener(this);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }
    }

    private class EntryKeyListener
    implements KeyListener {
        private EntryKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '|') {
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                this.reset(keyEvent);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!(keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 32 || MultiSelectionDisplayingComboBox.this.textField.getText().isEmpty())) {
                Keyword keyword;
                String string = MultiSelectionDisplayingComboBox.this.textField.getText().trim();
                if (!string.isEmpty() && (keyword = KeywordUtils.getMatchingKeyword(string, true)) != null) {
                    MultiSelectionDisplayingComboBox.this.addCloseableEntry(keyword.getKeyword(), keyword.getUserPrefix());
                    MultiSelectionDisplayingComboBox.this.autoCompletion.hidePopupMenu();
                    this.reset(keyEvent);
                }
            } else if ((keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38) && MultiSelectionDisplayingComboBox.this.autoCompletion != null) {
                MultiSelectionDisplayingComboBox.this.autoCompletion.processKeyEvent(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                this.reset(keyEvent);
            }
        }

        private void reset(KeyEvent keyEvent) {
            keyEvent.consume();
            MultiSelectionDisplayingComboBox.this.textField.setText("");
            MultiSelectionDisplayingComboBox.this.textField.setForeground(MultiSelectionDisplayingComboBox.this.textColor);
        }
    }

    private class EntryMouseListener
    extends MouseAdapter {
        private ClosableEntry entry;

        public EntryMouseListener(ClosableEntry closableEntry) {
            this.entry = closableEntry;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                MultiSelectionDisplayingComboBox.this.contextMenu.show(this.entry, mouseEvent.getX(), mouseEvent.getY());
                SwingUtilities.getWindowAncestor(MultiSelectionDisplayingComboBox.this.contextMenuList).toFront();
                MultiSelectionDisplayingComboBox.this.contextMenuList.requestFocusInWindow();
                MultiSelectionDisplayingComboBox.this.contextMenuList.addKeyListener(new ContextMenuListener(this.entry));
                MultiSelectionDisplayingComboBox.this.contextMenuList.addMouseListener(new ContextMenuListener(this.entry));
            }
        }
    }

    private class MenuKeyListener
    extends KeyAdapter {
        private MenuKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            Keyword keyword;
            if (keyEvent.getKeyCode() == 10 && (keyword = (Keyword)MultiSelectionDisplayingComboBox.this.menuList.getSelectedValue()) != null) {
                MultiSelectionDisplayingComboBox.this.addCloseableEntry(keyword.getKeyword(), keyword.getUserPrefix());
                MultiSelectionDisplayingComboBox.this.popupMenu.setVisible(false);
            }
        }
    }

    private class MouseSelectionListener
    extends MouseAdapter {
        private MouseSelectionListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Keyword keyword = (Keyword)MultiSelectionDisplayingComboBox.this.menuList.getSelectedValue();
            if (keyword != null) {
                MultiSelectionDisplayingComboBox.this.addCloseableEntry(keyword.getKeyword(), keyword.getUserPrefix());
                MultiSelectionDisplayingComboBox.this.popupMenu.setVisible(false);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = MultiSelectionDisplayingComboBox.this.menuList.locationToIndex(mouseEvent.getPoint());
            if (n > -1) {
                MultiSelectionDisplayingComboBox.this.menuList.setSelectedIndex(n);
            }
        }
    }
}

