/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.inputverifier;

import com.agfa.pacs.listtext.lta.filter.FilterEntryCriterion;
import com.agfa.pacs.listtext.lta.inputverifier.IDateInputVerifier;
import java.text.ParseException;
import java.util.Date;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.commons.lang3.time.FastDateFormat;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.util.DateUtils;

public class DateTimeInputVerifier
extends InputVerifier
implements IDateInputVerifier {
    private static final DatePrecision PERFECT_PRECISION = new DatePrecision();
    private FilterEntryCriterion fec = null;
    private static FastDateFormat shortFormat = FastDateFormat.getDateTimeInstance((int)3, (int)3);

    public DateTimeInputVerifier(FilterEntryCriterion filterEntryCriterion) {
        this.fec = filterEntryCriterion;
    }

    @Override
    public String dateToFormatString(Date date) {
        return shortFormat.format(date);
    }

    @Override
    public String dateToDicomString(Date date) {
        return DateUtils.formatDT(null, (Date)date);
    }

    @Override
    public String dicomStringToFormatString(String string) throws ParseException {
        return this.dateToFormatString(this.dicomStringToDate(string));
    }

    @Override
    public Date dicomStringToDate(String string) throws ParseException {
        return DateUtils.parseDT(null, (String)string, (boolean)false, (DatePrecision)PERFECT_PRECISION);
    }

    public String formatStringToDicomString(String string) throws ParseException {
        return this.dateToDicomString(this.formatStringToDate(string));
    }

    @Override
    public Date formatStringToDate(String string) throws ParseException {
        return shortFormat.parse(string);
    }

    @Override
    public boolean verify(JComponent jComponent) {
        String string = ((JTextField)jComponent).getText();
        try {
            Date date = this.formatStringToDate(string);
            this.dateToDicomString(date);
            return this.fec != null ? this.fec.isValid((Object)date) : true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

