/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports;

import com.agfa.hap.pacs.impaxee.reports.ReportType;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.logging.ALogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class CDAReportViewUtil {
    protected static final ALogger log = ALogger.getLogger(CDAReportViewUtil.class);
    public static final String CDA_VIEW_TYPE = "CDA";
    private static final ReportType[] SUPPORTED_CDA_REPORT_TYPES = new ReportType[]{ReportType.CDAReport};

    public static String getReportViewType() {
        return CDA_VIEW_TYPE;
    }

    public static boolean isReportTypeSupported(ReportType reportType) {
        return CDAReportViewUtil.supportsReport(reportType);
    }

    public static boolean supportsReport(ReportType reportType) {
        return Arrays.asList(SUPPORTED_CDA_REPORT_TYPES).contains(reportType);
    }

    public static String convertSRToHTML(IReport iReport) {
        try {
            byte[] byArray = iReport.getReportObject().getBytes(4325393);
            InputStream inputStream = CDAReportViewUtil.class.getResourceAsStream("/CDAToHtml.xsl");
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(inputStream));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32768);
            transformer.transform(new StreamSource(new ByteArrayInputStream(byArray)), new StreamResult(byteArrayOutputStream));
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            log.error("CDA report to HTML conversion failed!", (Throwable)exception);
            return null;
        }
    }
}

