/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports;

import com.agfa.hap.pacs.impaxee.reports.IReportMetaData;
import com.agfa.hap.pacs.impaxee.reports.ReportType;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.SingleObjectDataListener;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.dicomobject.type.CompletionFlag;
import com.agfa.pacs.listtext.dicomobject.type.VerificationFlag;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.listtext.lta.reports.IReportListener;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dcm4che3.data.Attributes;

public class Report
implements IReport,
IReportMetaData.IReportFieldTranslator {
    protected IObjectInfo reportInfo;
    protected Attributes reportObject;
    private final IReportMetaData reportMetaData;
    private int loadingAttempts = 0;
    private Map<IReport.ReportFlag, Boolean> flags;
    private static int maxLoadingAttempts = 2;
    private List<IReportListener> listeners;

    protected Report(IObjectInfo iObjectInfo, Attributes attributes, IReportMetaData iReportMetaData) {
        this.reportInfo = iObjectInfo;
        this.reportObject = attributes;
        this.reportMetaData = iReportMetaData;
        this.flags = new EnumMap<IReport.ReportFlag, Boolean>(IReport.ReportFlag.class);
        this.listeners = new CopyOnWriteArrayList<IReportListener>();
    }

    public ReportType getType() {
        return this.reportMetaData.getType();
    }

    public String getTitle() {
        return this.reportMetaData.getTitle((IReportMetaData.IReportFieldTranslator)this);
    }

    public Date getCreationDate() {
        return this.reportMetaData.getCreationDate();
    }

    public Date getCreationTime() {
        return this.reportMetaData.getCreationTime();
    }

    public Date getCreationDateTime() {
        return this.reportMetaData.getCreationDateTime();
    }

    public CompletionFlag getCompletionFlag() {
        return this.reportMetaData.getCompletionFlag();
    }

    @Override
    public IReport.CompletionState getCompletionState() {
        return IReport.CompletionState.valueOf(this.getCompletionFlag());
    }

    public VerificationFlag getVerificationFlag() {
        return this.reportMetaData.getVerificationFlag();
    }

    @Override
    public IReport.VerificationState getVerificationState() {
        return IReport.VerificationState.valueOf(this.getVerificationFlag());
    }

    public boolean isInvalid() {
        return this.reportMetaData.isInvalid();
    }

    @Override
    public Boolean getReportFlag(IReport.ReportFlag reportFlag) {
        return this.flags.get((Object)reportFlag);
    }

    @Override
    public void setReportFlag(IReport.ReportFlag reportFlag, Boolean bl) {
        this.flags.put(reportFlag, bl);
    }

    @Override
    public String getHtmlDigest() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        stringBuilder.append(this.toString());
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    @Override
    public IObjectInfo getReportInfo() {
        return this.reportInfo;
    }

    @Override
    public synchronized Attributes getReportObject() {
        if (this.reportObject == null && this.loadingAttempts < maxLoadingAttempts) {
            this.fireLoadingReportObjectStarted();
            ++this.loadingAttempts;
            this.reportObject = this.loadReportObject(this.reportInfo);
            this.fireLoadingReportObjectFinished();
        }
        return this.reportObject;
    }

    public Attributes getReportAttributes() {
        return this.reportMetaData.getReportAttributes();
    }

    @Override
    public void addReportListener(IReportListener iReportListener) {
        if (iReportListener != null && !this.listeners.contains(iReportListener)) {
            this.listeners.add(iReportListener);
        }
    }

    @Override
    public void removeReportListener(IReportListener iReportListener) {
        if (iReportListener != null && this.listeners.contains(iReportListener)) {
            this.listeners.remove(iReportListener);
        }
    }

    public String toString() {
        return this.reportMetaData.toString((IReportMetaData.IReportFieldTranslator)this);
    }

    private void fireLoadingReportObjectStarted() {
        for (IReportListener iReportListener : this.listeners) {
            iReportListener.loadingReportObjectStarted(this);
        }
    }

    private void fireLoadingReportObjectFinished() {
        for (IReportListener iReportListener : this.listeners) {
            iReportListener.loadingReportObjectFinished(this);
        }
    }

    protected Attributes loadReportObject(IObjectInfo iObjectInfo) {
        if (iObjectInfo != null) {
            SingleObjectDataListener singleObjectDataListener = new SingleObjectDataListener(iObjectInfo.getSOPInstanceUID());
            IDicomDataRequest iDicomDataRequest = DicomDataRequester.getInstance().createDicomDataRequest(iObjectInfo, (byte)0);
            iDicomDataRequest.setListener((IDicomDataListener)singleObjectDataListener);
            iDicomDataRequest.setFromCache(false);
            DicomDataRequester.getInstance().addRequest(iDicomDataRequest);
            iDicomDataRequest.waitUntilFinished();
            return singleObjectDataListener.getDataset();
        }
        return null;
    }

    public String getDefaultTitle() {
        switch (this.reportMetaData.getType()) {
            case PDFReport: {
                return Messages.getString("PDFReport.DefaultTitle");
            }
            case DoseReport: 
            case OrbisReport: 
            case MammoPreprocessingReport: 
            case CDAReport: 
            case StructuredReport: 
            case ElectronicFilmPresentation: {
                return Messages.getString("StructuredReport.DefaultTitle");
            }
        }
        return null;
    }

    public String formatDate(Date date) {
        return DateTimeUtils.date2String((Date)date);
    }

    public String formatDateTime(Date date) {
        return DateTimeUtils.dateTime2String((Date)date);
    }

    public String translateCompletionFlag(CompletionFlag completionFlag) {
        return String.valueOf((Object)IReport.CompletionState.valueOf(completionFlag));
    }

    public String translateVerificationFlag(VerificationFlag verificationFlag) {
        return String.valueOf((Object)IReport.VerificationState.valueOf(verificationFlag));
    }
}

