/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports.ui;

import com.agfa.hap.pacs.impaxee.reports.ReportType;
import com.agfa.pacs.listtext.lta.base.mimeview.IComponentMimeView;
import com.agfa.pacs.listtext.lta.base.mimeview.IMimeView;
import com.agfa.pacs.listtext.lta.base.mimeview.IMimeViewProvider;
import com.agfa.pacs.listtext.lta.base.mimeview.MimeViewProviderFactory;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.listtext.lta.reports.ui.IReportView;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.OpenLink;
import com.agfa.pacs.tools.StreamUtil;
import com.agfa.pacs.tools.TempDirectoryProvider;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.JComponent;
import org.dcm4che3.data.Attributes;

public class PDFReportView
implements IReportView {
    public static final String VIEW_TYPE = "PDF";
    public static final ReportType[] SUPPORTED_REPORT_TYPES = new ReportType[]{ReportType.PDFReport};
    private static final ALogger log = ALogger.getLogger(PDFReportView.class);
    private static final String tmpFileSuffix = ".pdf";
    private static final String tmpFilePrefix = "report";
    private IReport report = null;
    private File pdfFile = null;
    private IComponentMimeView pdfComponent = null;
    private CountDownLatch loading = null;

    public PDFReportView(IReport iReport) {
        this.createComponents();
        this.init(iReport);
    }

    public PDFReportView() {
        this(null);
    }

    @Override
    public String getReportViewType() {
        return VIEW_TYPE;
    }

    @Override
    public Component getAWTRootComponent() {
        return this.pdfComponent != null ? this.pdfComponent.getAWTRootComponent() : null;
    }

    @Override
    public JComponent getPrintComponent() {
        return null;
    }

    @Override
    public boolean isReportTypeSupported(ReportType reportType) {
        return PDFReportView.supportsReport(reportType);
    }

    @Override
    public IReport getReport() {
        return this.report;
    }

    public static boolean supportsReport(ReportType reportType) {
        return Arrays.asList(SUPPORTED_REPORT_TYPES).contains(reportType);
    }

    @Override
    public void init(IReport iReport) {
        this.report = iReport;
        this.loading = new CountDownLatch(1);
        this.initPDFView(iReport);
    }

    protected void createComponents() {
        IMimeViewProvider iMimeViewProvider = MimeViewProviderFactory.getInstance().getMimeViewProvider("application/pdf");
        if (iMimeViewProvider != null) {
            try {
                IMimeView iMimeView = iMimeViewProvider.createView();
                this.pdfComponent = (IComponentMimeView)iMimeView;
            }
            catch (Exception exception) {
                log.error("Creating PDF view component failed!");
            }
        }
    }

    protected void initPDFView(IReport iReport) {
        block7: {
            if (iReport != null) {
                try {
                    try {
                        Attributes attributes = iReport.getReportObject();
                        this.deleteTempFile(this.pdfFile);
                        this.pdfFile = this.createTempFile(attributes);
                        if (this.pdfComponent != null) {
                            this.pdfComponent.showFile(this.pdfFile);
                            break block7;
                        }
                        OpenLink.openFile((File)this.pdfFile);
                    }
                    catch (Exception exception) {
                        log.error("PDF document creation or view initialization failed!", (Throwable)exception);
                        this.loading.countDown();
                    }
                }
                finally {
                    this.loading.countDown();
                }
            }
        }
    }

    private void deleteTempFile(File file) {
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    private File createTempFile(Attributes attributes) throws Exception {
        if (attributes != null) {
            int n = ThreadLocalRandom.current().nextInt();
            File file = TempDirectoryProvider.createTemporaryFile((String)(tmpFilePrefix + Integer.toString(n)), (String)tmpFileSuffix);
            file.deleteOnExit();
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                StreamUtil.writeStream((byte[])attributes.getBytes(4325393), (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return file;
        }
        return null;
    }

    @Override
    public void postInit() {
    }

    @Override
    public void waitUntilRendered() throws InterruptedException {
        if (this.loading != null) {
            this.loading.await();
        }
    }
}

