/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports.ui;

import com.agfa.hap.pacs.impaxee.reports.ReportType;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.listtext.lta.base.LTAUtil;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.listtext.lta.reports.IReportViewProvider;
import com.agfa.pacs.listtext.lta.reports.ReportViewProviderFactory;
import com.agfa.pacs.listtext.lta.reports.ui.IReportView;
import com.agfa.pacs.listtext.lta.reports.ui.IReportsView;
import com.agfa.pacs.listtext.lta.reports.ui.NotFastLoadableReportView;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Window;
import java.util.List;
import javax.swing.JDialog;
import org.dcm4che3.data.PersonName;

public class ReportViewFactory {
    public static IReportView createView(IReportsView iReportsView, IReport iReport) throws IllegalArgumentException {
        if (iReport == null) {
            throw new IllegalArgumentException("Creating report view failed: Report is null!");
        }
        if (iReport.getReportInfo().getAvailability().isSlow()) {
            return new NotFastLoadableReportView(iReport);
        }
        ReportType reportType = iReport.getType();
        List<IReportViewProvider> list = ReportViewProviderFactory.getInstance().getReportProviders(reportType);
        if (list != null) {
            for (IReportViewProvider iReportViewProvider : list) {
                List<ReportType> list2 = iReportViewProvider.getSupportedTypes();
                if (list2 == null || !list2.contains(reportType)) continue;
                return iReportViewProvider.createReportView(iReport, iReportsView);
            }
        }
        throw new IllegalArgumentException("Creating report view failed: Report type is not supported!");
    }

    public static JDialog openReportInDialog(IReport iReport) {
        IReportView iReportView = ReportViewFactory.createView(null, iReport);
        JDialog jDialog = new JDialog(LTAUtil.getMainWindow());
        jDialog.setDefaultCloseOperation(2);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add(iReportView.getAWTRootComponent(), "Center");
        jDialog.setSize(GUI.getScaledInt((int)1024), GUI.getScaledInt((int)800));
        String string = PersonNameUtilities.personNameToHRShort((PersonName)new PersonName(iReport.getReportInfo().getString(0x100010), true));
        string = String.valueOf(string) + " - " + iReport.getTitle();
        jDialog.setTitle(string);
        SwingUtilities2.centerOnWindow((Window)LTAUtil.getMainWindow(), (Window)jDialog);
        jDialog.setVisible(true);
        return jDialog;
    }
}

