/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.uiconfig;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.listtext.lta.uiconfig.ILTAUIConfiguration;
import com.agfa.pacs.logging.ALogger;

public class LTAUIConfiguration
implements ILTAUIConfiguration {
    private static final ALogger log = ALogger.getLogger(LTAUIConfiguration.class);
    private static final String ROOT = "listtext.lta";
    private boolean fontScalingEnabled;
    private double fontScalingCorrection;
    private IConfigurationProvider configProvider = ConfigurationProviderFactory.getConfig();

    public LTAUIConfiguration() {
        this.createConfigurationData();
    }

    public void createConfigurationData() {
        if (this.configProvider == null) {
            return;
        }
        this.fontScalingEnabled = this.createFontScaling(this.configProvider);
        this.fontScalingCorrection = this.createFontScalingCorrection(this.configProvider);
    }

    @Override
    public boolean getFontScaling() {
        return this.fontScalingEnabled;
    }

    @Override
    public double getFontScalingCorrection() {
        return this.fontScalingCorrection;
    }

    protected boolean createFontScaling(IConfigurationProvider iConfigurationProvider) {
        try {
            return iConfigurationProvider.getBoolean("listtext.lta.ui.font.scaling");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Config Error", (Throwable)illegalArgumentException);
            return false;
        }
    }

    protected double createFontScalingCorrection(IConfigurationProvider iConfigurationProvider) {
        try {
            return iConfigurationProvider.getDouble("listtext.lta.ui.font.scale_correction");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Config Error", (Throwable)illegalArgumentException);
            return 1.0;
        }
    }
}

