/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.pixeldata.jai;

import com.agfa.pacs.base.util.ProcessorUtilities;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.ImageIOUtils;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.data.shared.pixel.decoder.IPixelDataDecoder;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.thirdparty.jai.JAITools;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class JAIPixelDataDecoder
implements IPixelDataDecoder {
    private static final ALogger log = ALogger.getLogger(JAIPixelDataDecoder.class);
    private final Map<String, String> supportedTransferSyntaxUIDs = new HashMap<String, String>();

    public JAIPixelDataDecoder() {
        try {
            JAITools.init();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ImageIO.setUseCache(false);
        }
        if (Product.isCDViewer()) {
            this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.50", "image/jpeg");
            try {
                Class<?> clazz = JAIPixelDataDecoder.class.getClassLoader().loadClass("com.pixelmed.imageio.JPEGLosslessImageReaderSpi");
                IIORegistry.getDefaultInstance().registerServiceProvider((ImageReaderSpi)clazz.newInstance(), ImageReaderSpi.class);
                this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.70", "image/jpeg");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                log.error("Could not load lossless decoder", (Throwable)reflectiveOperationException);
            }
        } else if (!ProcessorUtilities.isAmd64onWindows()) {
            if (ImageIO.getImageReadersByMIMEType("image/jpeg") != null) {
                this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.51", "image/jpeg");
                this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.50", "image/jpeg");
                this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.70", "image/jpeg");
                this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.57", "image/jpeg");
                this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.80", "image/jpeg");
                this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.81", "image/jpeg");
            }
            if (ImageIO.getImageReadersByMIMEType("image/jp2") != null) {
                this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.90", "image/jp2");
                this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.91", "image/jp2");
            } else {
                log.warn("JAI JPEG2000 Problem");
            }
        }
    }

    public List<String> getSupportedTransferSyntaxUIDs() {
        if (Product.isCDViewer()) {
            return new ArrayList<String>(this.supportedTransferSyntaxUIDs.keySet());
        }
        if (ProcessorUtilities.isAmd64onWindows()) {
            return Collections.emptyList();
        }
        if (System.getProperty("os.arch").toUpperCase().contains("MAC")) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.supportedTransferSyntaxUIDs.keySet());
    }

    public String getType() {
        return "JAI";
    }

    /*
     * Loose catch block
     */
    protected BufferedImage readPixels(Object object, String string) {
        block11: {
            try {
                ImageIOUtils.acquireJAI();
                Optional<ImageReader> optional = this.selectImageReader(string);
                if (!optional.isPresent()) break block11;
                ImageReader imageReader = optional.get();
                try {
                    BufferedImage bufferedImage;
                    ByteArrayInputStream byteArrayInputStream;
                    Object object2;
                    if (object instanceof ByteArrayContainer) {
                        object2 = (ByteArrayContainer)object;
                        byteArrayInputStream = new ByteArrayInputStream(object2.data, object2.offset, object2.length);
                    } else {
                        byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                    }
                    object2 = new MemoryCacheImageInputStream(byteArrayInputStream);
                    imageReader.setInput(object2);
                    BufferedImage bufferedImage2 = bufferedImage = imageReader.read(0, imageReader.getDefaultReadParam());
                    return bufferedImage2;
                }
                catch (IOException iOException) {
                    log.error("IO Error", (Throwable)iOException);
                    break block11;
                }
                finally {
                    imageReader.dispose();
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                ImageIOUtils.releaseJAI();
            }
        }
        return null;
    }

    private Optional<ImageReader> selectImageReader(String string) {
        Iterator<ImageReader> iterator;
        String string2 = this.supportedTransferSyntaxUIDs.get(string);
        if (string2 == null) {
            return Optional.empty();
        }
        if ("image/jpeg".equals(string2) && "1.2.840.10008.1.2.4.70".equals(string) && (iterator = ImageIO.getImageReadersByFormatName("jpeg-lossless")).hasNext()) {
            return Optional.of(iterator.next());
        }
        iterator = ImageIO.getImageReadersByMIMEType(string2);
        if (iterator.hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    public Object decode(IImagePixel iImagePixel, byte[] byArray, String string) throws PixelDataException {
        return this.decodeImpl(iImagePixel, byArray, string);
    }

    public Object decode(IImagePixel iImagePixel, ByteArrayContainer byteArrayContainer, String string) throws PixelDataException {
        try {
            return this.decodeImpl(iImagePixel, byteArrayContainer, string);
        }
        catch (Exception exception) {
            log.error("Could not decode images", (Throwable)exception);
            return null;
        }
    }

    private Object decodeImpl(IImagePixel iImagePixel, Object object, String string) {
        int n = iImagePixel.getRows();
        int n2 = iImagePixel.getColumns();
        PhotometricInterpretation photometricInterpretation = iImagePixel.getPhotometricInterpretation();
        BufferedImage bufferedImage = this.readPixels(object, string);
        if (PhotometricInterpretation.InverseMonochrome.equals((Object)photometricInterpretation) || PhotometricInterpretation.Monochrome.equals((Object)photometricInterpretation)) {
            Object object2;
            WritableRaster writableRaster = bufferedImage.getRaster();
            SampleModel sampleModel = writableRaster.getSampleModel();
            int n3 = -1;
            if (sampleModel instanceof SinglePixelPackedSampleModel) {
                object2 = (SinglePixelPackedSampleModel)sampleModel;
                n3 = ((SinglePixelPackedSampleModel)object2).getScanlineStride();
            }
            if (sampleModel instanceof PixelInterleavedSampleModel) {
                object2 = (PixelInterleavedSampleModel)sampleModel;
                n3 = ((ComponentSampleModel)object2).getScanlineStride();
            }
            if (n3 == sampleModel.getWidth()) {
                object2 = writableRaster.getDataBuffer();
                Object[] objectArray = null;
                if (object2 instanceof DataBufferByte) {
                    objectArray = ((DataBufferByte)object2).getData();
                } else if (object2 instanceof DataBufferUShort) {
                    objectArray = ((DataBufferUShort)object2).getData();
                } else if (object2 instanceof DataBufferShort) {
                    objectArray = ((DataBufferShort)object2).getData();
                } else if (object2 instanceof DataBufferInt) {
                    objectArray = ((DataBufferInt)object2).getData();
                }
                if (objectArray instanceof byte[] && iImagePixel.getBitsAllocated() == 16) {
                    int n4 = sampleModel.getHeight() * sampleModel.getWidth();
                    short[] sArray = DataCacheProviderFactory.getMemoryPool().allocShorts((long)n4);
                    Object[] objectArray2 = objectArray;
                    int n5 = 0;
                    while (n5 < n4) {
                        sArray[n5] = objectArray2[n5];
                        ++n5;
                    }
                    objectArray2 = null;
                    log.warn("JAI returned byte array, instead of short array. Correcting.");
                    return sArray;
                }
                return objectArray;
            }
            return bufferedImage.getRaster().getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        }
        if (PhotometricInterpretation.RGBColor.equals((Object)photometricInterpretation)) {
            int[] nArray = bufferedImage.getRGB(0, 0, n2, n, null, 0, n2);
            return this.clearAlpha(nArray);
        }
        if (PhotometricInterpretation.YBRFull.equals((Object)photometricInterpretation)) {
            int[] nArray = bufferedImage.getRGB(0, 0, n2, n, null, 0, n2);
            return this.clearAlpha(nArray);
        }
        if (PhotometricInterpretation.YBRFull422.equals((Object)photometricInterpretation)) {
            int[] nArray = bufferedImage.getRGB(0, 0, n2, n, null, 0, n2);
            return this.clearAlpha(nArray);
        }
        if (PhotometricInterpretation.IndexedColor.equals((Object)photometricInterpretation)) {
            return bufferedImage.getRaster().getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        }
        return null;
    }

    private int[] clearAlpha(int[] nArray) {
        return nArray;
    }
}

