/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.pixeldata.jai;

import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.ImageIOUtils;
import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.data.shared.pixel.encoder.IPixelDataEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.ByteArrayOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class JAIPixelDataEncoder
implements IPixelDataEncoder {
    private ImageWriteParam imageWriteParam;
    private ImageWriter imageWriter;
    private boolean lossless;
    private float compressionRate;

    public JAIPixelDataEncoder(ImageWriteParam imageWriteParam, ImageWriter imageWriter, boolean bl) {
        this.imageWriteParam = imageWriteParam;
        this.imageWriter = imageWriter;
        this.lossless = bl;
        this.compressionRate = 1.0f;
    }

    protected void finalize() throws Throwable {
        this.imageWriter.dispose();
        super.finalize();
    }

    public byte[] encode(IImagePixel iImagePixel, Object object) throws PixelDataException {
        try {
            Object object2;
            this.imageWriteParam.setCompressionQuality(this.lossless ? 1.0f : this.compressionRate);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0x8000000);
            int n = iImagePixel.getColumns();
            int n2 = iImagePixel.getRows();
            BufferedImage bufferedImage = null;
            switch (iImagePixel.getPhotometricInterpretation()) {
                case RGBColor: {
                    if (!(object instanceof int[])) break;
                    object2 = (int[])object;
                    bufferedImage = new BufferedImage(n, n2, 1);
                    System.arraycopy(object2, 0, ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData(), 0, ((int[])object2).length);
                    break;
                }
                default: {
                    if (object instanceof byte[]) {
                        object2 = (byte[])object;
                        bufferedImage = new BufferedImage(n, n2, 10);
                        System.arraycopy(object2, 0, ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData(), 0, ((int[])object2).length);
                    }
                    if (!(object instanceof short[])) break;
                    bufferedImage = new BufferedImage(n, n2, 11);
                    object2 = (short[])object;
                    System.arraycopy(object2, 0, ((DataBufferUShort)bufferedImage.getRaster().getDataBuffer()).getData(), 0, ((int[])object2).length);
                }
            }
            if (bufferedImage != null) {
                try {
                    ImageIOUtils.acquireJAI();
                    this.imageWriter.reset();
                    object2 = new MemoryCacheImageOutputStream(byteArrayOutputStream);
                    this.imageWriter.setOutput(object2);
                    IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
                    this.imageWriter.write(null, iIOImage, this.imageWriteParam);
                    object2.flush();
                    object2.close();
                }
                finally {
                    ImageIOUtils.releaseJAI();
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new PixelDataException((Throwable)exception);
        }
    }

    public void setCompressionRate(float f) {
        this.compressionRate = f;
    }

    public boolean isEncapsulated() {
        return true;
    }

    public String getDescription() {
        return String.valueOf(this.imageWriteParam.getCompressionType()) + " " + this.imageWriteParam.getLocalizedCompressionTypeName();
    }

    public float getBitRate() {
        return this.imageWriteParam.getBitRate(this.compressionRate);
    }
}

