/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.pixeldata.jai;

import com.agfa.pacs.base.util.ProcessorUtilities;
import com.agfa.pacs.data.pixeldata.jai.JAIPixelDataEncoder;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.encoder.IPixelDataEncoder;
import com.agfa.pacs.data.shared.pixel.encoder.IPixelDataEncoderProvider;
import com.agfa.pacs.thirdparty.jai.JAITools;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;

public class JAIPixelDataEncoderProvider
implements IPixelDataEncoderProvider {
    private final Hashtable<String, PixelDataEncoderInfo> supportedTransferSyntaxUIDs = new Hashtable();

    public JAIPixelDataEncoderProvider() {
        String string;
        int n;
        int n2;
        String[] stringArray;
        ImageWriteParam imageWriteParam;
        ImageWriter imageWriter;
        if (ProcessorUtilities.isAmd64onWindows()) {
            return;
        }
        Iterator<ImageWriter> iterator = null;
        try {
            JAITools.init();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ImageIO.setUseCache(false);
        }
        iterator = ImageIO.getImageWritersByMIMEType("image/jpeg");
        while (iterator.hasNext()) {
            imageWriter = iterator.next();
            imageWriteParam = imageWriter.getDefaultWriteParam();
            stringArray = imageWriteParam.getCompressionTypes();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                if ("JPEG".equals(string)) {
                    this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.50", new PixelDataEncoderInfo(false, "image/jpeg", string));
                    this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.51", new PixelDataEncoderInfo(false, "image/jpeg", string));
                }
                if ("JPEG-LOSSLESS".equals(string)) {
                    this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.70", new PixelDataEncoderInfo(true, "image/jpeg", string));
                    this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.57", new PixelDataEncoderInfo(true, "image/jpeg", string));
                }
                ++n;
            }
            imageWriter.dispose();
        }
        iterator = ImageIO.getImageWritersByMIMEType("image/jp2");
        while (iterator.hasNext()) {
            imageWriter = iterator.next();
            imageWriteParam = imageWriter.getDefaultWriteParam();
            stringArray = imageWriteParam.getCompressionTypes();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                if ("JPEG2000".equals(string)) {
                    this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.90", new PixelDataEncoderInfo(true, "image/jp2", string));
                    this.supportedTransferSyntaxUIDs.put("1.2.840.10008.1.2.4.91", new PixelDataEncoderInfo(false, "image/jp2", string));
                }
                ++n;
            }
            imageWriter.dispose();
        }
    }

    public List<String> getSupportedTransferSyntaxUIDs() {
        if (ProcessorUtilities.isAmd64onWindows()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.supportedTransferSyntaxUIDs.keySet());
    }

    public IPixelDataEncoder createPixelDataEncoder(String string) {
        PixelDataEncoderInfo pixelDataEncoderInfo = this.supportedTransferSyntaxUIDs.get(string);
        if (pixelDataEncoderInfo == null) {
            return null;
        }
        return pixelDataEncoderInfo.createPixelDataEncoder(string);
    }

    public boolean canEncode(IImagePixel iImagePixel, String string) {
        if ("1.2.840.10008.1.2.4.50".equals(string)) {
            return iImagePixel.getBitsStored() <= 8;
        }
        if ("1.2.840.10008.1.2.4.51".equals(string)) {
            return iImagePixel.getBitsStored() <= 12;
        }
        return true;
    }

    public String getType() {
        return "JAI";
    }

    private static class PixelDataEncoderInfo {
        public boolean lossless;
        public ImageWriter iw;
        private String mimeType;
        private String compressionType;

        public PixelDataEncoderInfo(boolean bl, String string, String string2) {
            this.lossless = bl;
            this.mimeType = string;
            this.compressionType = string2;
        }

        protected void finalize() throws Throwable {
            this.iw.dispose();
            super.finalize();
        }

        public IPixelDataEncoder createPixelDataEncoder(String string) {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(this.mimeType);
            while (iterator.hasNext()) {
                this.iw = iterator.next();
                ImageWriteParam imageWriteParam = this.iw.getDefaultWriteParam();
                String[] stringArray = imageWriteParam.getCompressionTypes();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray[n2];
                    if (this.compressionType.equals(string2)) {
                        imageWriteParam.setCompressionMode(2);
                        imageWriteParam.setCompressionType(string2);
                        Class<?> clazz = imageWriteParam.getClass();
                        if (clazz.getSimpleName().equalsIgnoreCase("J2KImageWriteParam")) {
                            try {
                                Method method = clazz.getMethod("setLossless", Boolean.TYPE);
                                method.invoke((Object)imageWriteParam, this.lossless);
                            }
                            catch (Exception exception) {}
                        }
                        return new JAIPixelDataEncoder(imageWriteParam, this.iw, this.lossless);
                    }
                    ++n2;
                }
                this.iw.dispose();
            }
            return null;
        }
    }
}

