/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.pixeldata.frame;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.data.shared.pixel.CacheStorageDecisionFactory;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.data.shared.pixel.decoder.PixelDataDecoderFactory;
import com.agfa.pacs.logging.ALogger;

public abstract class AbstractPixelDataFrame<U>
implements IPixelDataFrame<U> {
    private static final ALogger log = ALogger.getLogger(AbstractPixelDataFrame.class);
    protected static final IDataCacheProvider cache = DataCacheProviderFactory.getCache();
    protected static final PixelDataDecoderFactory decoder = PixelDataDecoderFactory.getInstance();
    protected final IImagePixel imagePixel;
    protected CacheID encodedDataID;
    protected volatile CacheID pixelDataID;
    protected PhotometricInterpretation photometricInterpretation;
    protected String transferSyntaxUID;
    protected volatile boolean initialized = false;
    protected boolean isPersistant = true;
    private U temporaryData = null;

    private AbstractPixelDataFrame(IImagePixel iImagePixel) {
        this.imagePixel = iImagePixel;
        this.photometricInterpretation = this.imagePixel.getPhotometricInterpretation();
    }

    public AbstractPixelDataFrame(IImagePixel iImagePixel, CacheID cacheID, String string) {
        this(iImagePixel);
        this.transferSyntaxUID = string;
        if (string != null) {
            this.encodedDataID = cacheID;
        } else {
            this.initialized = true;
            this.pixelDataID = cacheID;
        }
    }

    public AbstractPixelDataFrame(AbstractPixelDataFrame<U> abstractPixelDataFrame) {
        this(abstractPixelDataFrame.getImagePixel());
        this.photometricInterpretation = abstractPixelDataFrame.getPhotometricInterpretation();
        abstractPixelDataFrame.initialize();
        this.pixelDataID = abstractPixelDataFrame.pixelDataID;
    }

    protected abstract void initFields(U var1);

    protected boolean isPermanentCaching() {
        return CacheStorageDecisionFactory.getInstance().cacheDecompressedImages(this.imagePixel);
    }

    private U decodeDataImpl() throws PixelDataException {
        if (this.encodedDataID == null) {
            return null;
        }
        ByteArrayContainer byteArrayContainer = (ByteArrayContainer)cache.referencePersistentObject(this.encodedDataID, ByteArrayContainer.class);
        try {
            Object object = decoder.decode(this.imagePixel, byteArrayContainer, this.transferSyntaxUID);
            if (object == null) {
                throw new IllegalArgumentException("Unable to decode data");
            }
            this.initFields(object);
            Object object2 = object;
            return (U)object2;
        }
        finally {
            if (byteArrayContainer != null) {
                cache.releaseReference(this.encodedDataID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initialize() {
        if (!this.initialized) {
            AbstractPixelDataFrame abstractPixelDataFrame = this;
            synchronized (abstractPixelDataFrame) {
                try {
                    if (this.initialized) {
                        return;
                    }
                    this.pixelDataID = cache.createID();
                    this.isPersistant = this.isPermanentCaching();
                    if (this.isPersistant) {
                        U u = this.decodeDataImpl();
                        if (u instanceof short[]) {
                            cache.addPersistentShorts((short[])u, this.pixelDataID);
                        } else if (u instanceof byte[]) {
                            cache.addPersistentBytes((byte[])u, this.pixelDataID);
                        } else if (u instanceof int[]) {
                            cache.addPersistentInts((int[])u, this.pixelDataID);
                        }
                    }
                }
                catch (PixelDataException pixelDataException) {
                    log.error("Could not decode data", (Throwable)pixelDataException);
                }
                this.initialized = true;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.pixelDataID != null) {
            cache.remove(this.pixelDataID);
        }
        super.finalize();
    }

    public final boolean hasSameMetrics(IPixelDataFrame<?> iPixelDataFrame) {
        if (iPixelDataFrame.getWidth() != this.getWidth()) {
            return false;
        }
        if (iPixelDataFrame.getHeight() != this.getHeight()) {
            return false;
        }
        if (iPixelDataFrame.getBitsPerPixel() != this.getBitsPerPixel()) {
            return false;
        }
        return iPixelDataFrame.getHighBit() == this.getHighBit();
    }

    public final IImagePixel getImagePixel() {
        return this.imagePixel;
    }

    public final int getWidth() {
        return this.imagePixel.getColumns();
    }

    public final int getHeight() {
        return this.imagePixel.getRows();
    }

    public final int getNumPixels() {
        return this.getWidth() * this.getHeight();
    }

    public final int getBitsPerPixel() {
        return this.imagePixel.getBitsStored();
    }

    public final PhotometricInterpretation getPhotometricInterpretation() {
        return this.photometricInterpretation;
    }

    public final void setPhotometricInterpretation(PhotometricInterpretation photometricInterpretation) {
        this.photometricInterpretation = photometricInterpretation;
    }

    public final int getHighBit() {
        return this.imagePixel.getHighBit();
    }

    protected final int getSignBitTest() {
        return 1 << this.getHighBit();
    }

    protected final int getSignBitExtend() {
        return ~((1 << this.getHighBit()) - 1);
    }

    protected final int getMask() {
        if (this.isSigned()) {
            return (1 << this.imagePixel.getBitsAllocated()) - 1;
        }
        return (1 << this.imagePixel.getBitsStored()) - 1;
    }

    public void decodeData() {
        if (this.pixelDataID == null) {
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected U getData() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.isPersistant) {
            if (this.getPixelDataClass() == short[].class) {
                return (U)cache.referencePersistentShorts(this.pixelDataID);
            }
            if (this.getPixelDataClass() == byte[].class) {
                return (U)cache.referencePersistentBytes(this.pixelDataID);
            }
            if (this.getPixelDataClass() == int[].class) {
                return (U)cache.referencePersistentInts(this.pixelDataID);
            }
        } else {
            IImagePixel iImagePixel = this.imagePixel;
            synchronized (iImagePixel) {
                if (this.temporaryData == null) {
                    if (this.getPixelDataClass() == short[].class) {
                        this.temporaryData = (U)cache.getContentShorts(this.pixelDataID);
                    } else if (this.getPixelDataClass() == byte[].class) {
                        this.temporaryData = (U)cache.getContentBytes(this.pixelDataID);
                    } else if (this.getPixelDataClass() == int[].class) {
                        this.temporaryData = (U)cache.getContentInts(this.pixelDataID);
                    }
                }
                if (this.temporaryData == null) {
                    try {
                        this.temporaryData = this.decodeDataImpl();
                    }
                    catch (PixelDataException pixelDataException) {
                        log.error("Could not get decoded pixel data:" + this.encodedDataID.getID());
                    }
                }
                return this.temporaryData;
            }
        }
        return null;
    }

    protected void releaseData() {
        if (this.isPersistant) {
            cache.releaseReference(this.pixelDataID);
        } else {
            if (this.temporaryData instanceof short[]) {
                cache.putContentShorts((short[])this.temporaryData, this.pixelDataID);
            } else if (this.temporaryData instanceof byte[]) {
                cache.putContentBytes((byte[])this.temporaryData, this.pixelDataID);
            } else if (this.temporaryData instanceof int[]) {
                cache.putContentInts((int[])this.temporaryData, this.pixelDataID);
            }
            this.temporaryData = null;
        }
    }

    public U getOriginalData() {
        if (this.encodedDataID != null) {
            ByteArrayContainer byteArrayContainer = (ByteArrayContainer)cache.referencePersistentObject(this.encodedDataID, ByteArrayContainer.class);
            try {
                Object object = decoder.decode(this.imagePixel, byteArrayContainer, this.transferSyntaxUID);
                return (U)object;
            }
            catch (PixelDataException pixelDataException) {
                log.error("Decoding problem", (Throwable)pixelDataException);
                return null;
            }
            finally {
                if (byteArrayContainer != null) {
                    cache.releaseReference(this.encodedDataID);
                }
            }
        }
        if (this.getPixelDataClass() == short[].class) {
            return (U)cache.referencePersistentShorts(this.pixelDataID);
        }
        if (this.getPixelDataClass() == byte[].class) {
            return (U)cache.referencePersistentBytes(this.pixelDataID);
        }
        if (this.getPixelDataClass() == int[].class) {
            return (U)cache.referencePersistentInts(this.pixelDataID);
        }
        return null;
    }

    public void releaseOriginalData(Object object) {
        if (this.encodedDataID != null) {
            if (this.getPixelDataClass() == short[].class) {
                cache.free((short[])object);
            } else if (this.getPixelDataClass() == byte[].class) {
                cache.free((byte[])object);
            } else if (this.getPixelDataClass() == int[].class) {
                cache.free((int[])object);
            }
        } else {
            cache.releaseReference(this.pixelDataID);
        }
    }

    public CacheID getEncodedDataCacheID() {
        return this.encodedDataID;
    }

    public String getEncodedDataTransferSyntaxUID() {
        return this.transferSyntaxUID;
    }

    public boolean isInMemory() {
        return cache.isInMemory(this.transferSyntaxUID != null ? this.encodedDataID : this.pixelDataID);
    }

    protected abstract class AbstractPixelAccessor
    implements IPixelAccessor<U> {
        protected U data;
        private volatile boolean released = false;

        public AbstractPixelAccessor() {
            this.data = AbstractPixelDataFrame.this.getData();
        }

        protected abstract void freeData();

        public final synchronized void release() {
            if (this.released) {
                return;
            }
            this.released = true;
            AbstractPixelDataFrame.this.releaseData();
            this.data = null;
        }

        public void close() {
            this.release();
        }

        public final U getData() {
            return this.data;
        }

        public int getMask() {
            return AbstractPixelDataFrame.this.getMask();
        }
    }
}

