/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomstoragecommitment;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class ReferencedInstance
extends AbstractDatasetSource {
    private String sopInstanceUID;
    private String sopClassUID;

    private ReferencedInstance(Attributes attributes) {
        this.sopClassUID = attributes.getString(528720);
        this.sopInstanceUID = attributes.getString(528725);
    }

    public ReferencedInstance(String string, String string2) {
        this.sopClassUID = string;
        this.sopInstanceUID = string2;
    }

    public static ReferencedInstance create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(528720) && attributes.contains(528725)) {
            return new ReferencedInstance(attributes);
        }
        return null;
    }

    public static ReferencedInstance createRef(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        String string = attributes.getString(524310);
        String string2 = attributes.getString(524312);
        if (string != null && string2 != null) {
            return new ReferencedInstance(string, string2);
        }
        return null;
    }

    public static List<ReferencedInstance> createRefs(Collection<? extends Attributes> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ReferencedInstance> arrayList = new ArrayList<ReferencedInstance>(collection.size());
        for (Attributes attributes : collection) {
            ReferencedInstance referencedInstance = ReferencedInstance.createRef(attributes);
            if (referencedInstance == null) continue;
            arrayList.add(referencedInstance);
        }
        return arrayList;
    }

    public static List<ReferencedInstance> createList(Attributes attributes, int n) {
        ArrayList<ReferencedInstance> arrayList = new ArrayList<ReferencedInstance>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            ReferencedInstance referencedInstance = ReferencedInstance.create((Attributes)sequence.get(n2));
            if (referencedInstance != null) {
                arrayList.add(referencedInstance);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public void setSOPClassUID(String string) {
        this.sopClassUID = string;
    }

    public void setSOPInstanceUID(String string) {
        this.sopInstanceUID = string;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.sopClassUID, attributes, 528720, DatasetAccessor.Type.Mandatory);
        this.set(this.sopInstanceUID, attributes, 528725, DatasetAccessor.Type.Mandatory);
        return attributes;
    }
}

