/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomstoragecommitment.service;

import com.agfa.pacs.data.dicom.device.IDicomService;
import com.agfa.pacs.data.dicom.transfercapability.ITransferCapabilityProvider;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.listtext.dicomstoragecommitment.service.StorageCommitmentSCU;
import com.agfa.pacs.logging.ALogger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceRegistry;

public class StorageCommitmentDicomService
implements IDicomService {
    private ALogger log = ALogger.getLogger(StorageCommitmentDicomService.class);
    private StorageCommitmentSCU scu = new StorageCommitmentSCU();

    public String getInfo() {
        return "Storage Commitment SCU";
    }

    public void registerIn(DicomServiceRegistry dicomServiceRegistry) {
        dicomServiceRegistry.addDicomService((DicomService)this.scu);
        this.log.info(String.valueOf(this.getInfo()) + " registered");
    }

    public void unregisterIn(DicomServiceRegistry dicomServiceRegistry) {
        dicomServiceRegistry.removeDicomService((DicomService)this.scu);
        this.log.info(String.valueOf(this.getInfo()) + " unregistered");
    }

    public static class StorageCommitTransferCapabilityProvider
    implements ITransferCapabilityProvider {
        public List<TransferCapability> getTransferCapabilities() {
            UIDMap uIDMap = new UIDMap();
            uIDMap.addTransferSyntaxUIDs("1.2.840.10008.1.20.1", (Collection)UIDUtilities.getDefaultTransferSyntaxUIDs());
            return uIDMap.getTransferCapabilitiesSCP();
        }

        public List<ExtendedNegotiation> getExtendedNegotiation() {
            return Collections.emptyList();
        }
    }
}

