/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.export.ImageObjectDicomDataListener;
import com.agfa.pacs.data.export.ProcessingExceptionMessageFactory;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.data.shared.export.ProcessingWarning;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.hw.IDicomDataRequester;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.IDisposable;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DataInfoProcessor
implements IProcessingElement {
    private static final ALogger log = ALogger.getLogger(DataInfoProcessor.class);
    private final IDicomDataRequester ddm = DicomDataRequester.getInstance();
    private Set<String> usedStudies = new HashSet<String>();
    public static final String ONLY_WARN_ON_FAILURE = "DATAINFOPROCESSOR_ONLY_WARN_ON_FAILURE";
    private boolean onlyWarnOnFailure = false;

    public void finishProcessing() {
    }

    public void cleanUp() {
        for (String string : this.usedStudies) {
            DicomCacheFactory.getInstance().getDicomCache().unregisterStudyUsage(string, null);
        }
    }

    public String getErrorMessage() {
        return null;
    }

    public void prepareProcessing(Properties properties, List<? extends Object> list) {
        if (properties.containsKey(ONLY_WARN_ON_FAILURE)) {
            this.onlyWarnOnFailure = (Boolean)properties.get(ONLY_WARN_ON_FAILURE);
        }
        UIDMap uIDMap = new UIDMap();
        if (list != null) {
            for (Object object : list) {
                String string;
                if (!(object instanceof IObjectInfo)) continue;
                IObjectInfo iObjectInfo = (IObjectInfo)object;
                String string2 = iObjectInfo.getSeries().getStudyUID();
                if (this.usedStudies.add(string2)) {
                    DicomCacheFactory.getInstance().getDicomCache().registerStudyUsage(string2, (IDisposable)iObjectInfo.getSeries().getStudy());
                }
                if ((string = iObjectInfo.getString(131088)) != null) {
                    uIDMap.addTransferSyntaxUID(iObjectInfo.getSOPClassUID(), string);
                    continue;
                }
                uIDMap.addClassUID(iObjectInfo.getSOPClassUID());
            }
            properties.put("UID_MAP", uIDMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(Object object) throws ProcessingException {
        if (!(object instanceof IObjectInfo)) {
            throw new IllegalArgumentException("Wrong input type");
        }
        IObjectInfo iObjectInfo = (IObjectInfo)object;
        ImageObject imageObject = new ImageObject();
        imageObject.setObjectInfo(iObjectInfo);
        IDicomDataRequest iDicomDataRequest = this.ddm.createDicomDataRequest(iObjectInfo);
        iDicomDataRequest.setListener((IDicomDataListener)new ImageObjectDicomDataListener(imageObject));
        this.ddm.addRequest(iDicomDataRequest);
        ImageObject imageObject2 = imageObject;
        synchronized (imageObject2) {
            while (!imageObject.isFinished() && !imageObject.isFailed()) {
                try {
                    imageObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (imageObject.isFailed()) {
            log.error("Error retrieving object " + iObjectInfo.getSOPInstanceUID());
            if (this.onlyWarnOnFailure) {
                throw new ProcessingWarning("Error retrieving object " + iObjectInfo.getSOPInstanceUID(), ProcessingExceptionMessageFactory.getProcessingExceptionMessage("export.errorLoadingData", iObjectInfo));
            }
            throw new ProcessingException("Error retrieving object " + iObjectInfo.getSOPInstanceUID(), ProcessingExceptionMessageFactory.getProcessingExceptionMessage("export.errorLoadingData", iObjectInfo));
        }
        return imageObject;
    }

    public ProcessingProperty[] queryProperties() {
        return null;
    }

    public boolean supportsConcurrentProcessing() {
        return true;
    }
}

