/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.base.ProgressState;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.ICMoveSCUListener;
import com.agfa.pacs.data.dicom.QueryRetrieveLevel;
import com.agfa.pacs.data.dicom.comm.DicomCompositeCMoveSCU;
import com.agfa.pacs.data.export.Messages;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.util.WaitCancelable;
import com.agfa.pacs.logging.ALogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class DicomCMove {
    private static final ALogger log = ALogger.getLogger(DicomCMove.class);
    private static final int AET_TITLE_NOT_FOUND_STATUS = 272;
    private static final int AET_TITLE_NOT_FOUND_STATUS2 = 43009;

    private DicomCMove() {
    }

    public static WaitCancelable moveInstances(IDicomNode iDicomNode, IDicomNode iDicomNode2, List<? extends IDataInfo> list, ProgressState progressState) throws DicomException {
        return DicomCMove.moveInstancesImpl(iDicomNode, iDicomNode2, list, progressState);
    }

    private static CombinedCMoveHelper moveInstancesImpl(IDicomNode iDicomNode, IDicomNode iDicomNode2, List<? extends IDataInfo> list, ProgressState progressState) throws DicomException {
        String string = iDicomNode2.getCalledAET();
        Audit.getInstance().logBeginSendDICOMInstances(iDicomNode2.toString(), iDicomNode2.getHost(), string, iDicomNode.toString(), iDicomNode.getHost(), iDicomNode.getCalledAET(), DataInfoUtilities.forAuditing(list));
        list = DicomCMove.reduceDataset(list);
        try {
            int n = list.size();
            CombinedCMoveHelper combinedCMoveHelper = new CombinedCMoveHelper(progressState, n, iDicomNode, DicomCompositeCMoveSCU.DefaultRetrieveClassUIDs);
            if (progressState != null) {
                progressState.setState(JobState.PROGRESSING);
                progressState.setProgressTitle(MessageFormat.format(Messages.getString("CMove.TaskInfo"), iDicomNode, string));
                progressState.setStateMessage("");
            }
            int n2 = 0;
            while (n2 < n) {
                if (combinedCMoveHelper.getLastError() != 0 || combinedCMoveHelper.isCanceled()) break;
                IDataInfo iDataInfo = list.get(n2);
                SingleCMoveHelper singleCMoveHelper = combinedCMoveHelper.getSingleCMoveHelper(n2);
                if (iDataInfo instanceof IStudyInfo) {
                    DicomCMove.sendStudy(singleCMoveHelper, string, iDataInfo);
                } else if (iDataInfo instanceof ISeriesInfo) {
                    DicomCMove.sendSerie(singleCMoveHelper, string, iDataInfo);
                } else if (iDataInfo instanceof IObjectInfo) {
                    DicomCMove.sendObject(singleCMoveHelper, string, iDataInfo);
                }
                ++n2;
            }
            return combinedCMoveHelper;
        }
        catch (DicomException dicomException) {
            if (progressState != null) {
                progressState.setState(JobState.FAILED);
            }
            throw dicomException;
        }
    }

    public static MoveResult moveInstancesSync(IDicomNode iDicomNode, IDicomNode iDicomNode2, List<? extends IDataInfo> list, ProgressState progressState) {
        CombinedCMoveHelper combinedCMoveHelper;
        long l = System.currentTimeMillis();
        try {
            combinedCMoveHelper = DicomCMove.moveInstancesImpl(iDicomNode, iDicomNode2, list, progressState);
        }
        catch (DicomException dicomException) {
            log.error("Move failed", (Throwable)dicomException);
            return MoveResult.MOVE_FAILED;
        }
        combinedCMoveHelper.waitUntilFinished();
        long l2 = System.currentTimeMillis() - l;
        List list2 = DataInfoUtilities.forAuditing(list);
        int n = combinedCMoveHelper.getLastError();
        DicomCMove.logAuditMessageForSentDICOMInstances(iDicomNode, iDicomNode2, list2, l2, n == 0);
        if (n == 272 || n == 43009) {
            return MoveResult.MOVE_NOT_CONFIGURED;
        }
        if (n != 0) {
            return MoveResult.MOVE_FAILED;
        }
        return MoveResult.MOVE_SUCCESSFUL;
    }

    public static boolean moveInstancesSync(IDicomNode iDicomNode, IDicomNode iDicomNode2, String string, String string2) {
        try {
            Attributes attributes;
            Object object;
            List<Object> list;
            String string3 = iDicomNode2.getCalledAET();
            if (string == null) {
                list = Collections.emptyList();
            } else {
                object = new Attributes();
                object.setString(0x20000D, VR.UI, string);
                list = Collections.singletonList(object);
            }
            Audit.getInstance().logBeginSendDICOMInstances(iDicomNode2.toString(), iDicomNode2.getHost(), iDicomNode2.getCalledAET(), iDicomNode.toString(), iDicomNode.getHost(), iDicomNode.getCalledAET(), list);
            object = new CombinedCMoveHelper(null, 1, iDicomNode, DicomCompositeCMoveSCU.DefaultRetrieveClassUIDs);
            SingleCMoveHelper singleCMoveHelper = ((CombinedCMoveHelper)object).getSingleCMoveHelper(0);
            long l = System.currentTimeMillis();
            if (string2 == null) {
                attributes = new Attributes();
                attributes.setString(0x20000D, VR.UI, string);
                singleCMoveHelper.move(string3, attributes, QueryRetrieveLevel.Study);
            } else {
                attributes = new Attributes();
                if (string != null) {
                    attributes.setString(0x20000D, VR.UI, string);
                }
                attributes.setString(0x20000E, VR.UI, string2);
                singleCMoveHelper.move(string3, attributes, QueryRetrieveLevel.Series);
            }
            ((CombinedCMoveHelper)object).waitUntilFinished();
            long l2 = System.currentTimeMillis() - l;
            boolean bl = ((CombinedCMoveHelper)object).getLastError() == 0;
            DicomCMove.logAuditMessageForSentDICOMInstances(iDicomNode, iDicomNode2, list, l2, bl);
            return bl;
        }
        catch (DicomException dicomException) {
            log.error("C-MOVE failed", (Throwable)dicomException);
            return false;
        }
    }

    public static List<IDataInfo> reduceDataset(List<? extends IDataInfo> list) {
        HashMap<String, IDataInfo> hashMap = new HashMap<String, IDataInfo>();
        HashMap<String, IDataInfo> hashMap2 = new HashMap<String, IDataInfo>();
        for (IDataInfo object2 : list) {
            hashMap.put(object2.getKey(), object2);
        }
        while (hashMap.size() > 0) {
            int n;
            IDataInfo iDataInfo = (IDataInfo)hashMap.values().iterator().next();
            if (iDataInfo.getHierarchyLevel() == Level.Study || iDataInfo.getHierarchyLevel() == Level.Patient) {
                hashMap2.put(iDataInfo.getKey(), iDataInfo);
                hashMap.remove(iDataInfo.getKey());
                continue;
            }
            IDataInfo iDataInfo2 = iDataInfo.getTreeParent();
            if (hashMap2.containsKey(iDataInfo2.getKey()) || hashMap.containsKey(iDataInfo2.getKey())) {
                hashMap.remove(iDataInfo.getKey());
                continue;
            }
            List list2 = iDataInfo2.children();
            int n2 = 0;
            for (IDataInfo iDataInfo3 : list2) {
                if (!hashMap2.containsKey(iDataInfo3.getKey()) && !hashMap.containsKey(iDataInfo3.getKey())) break;
                ++n2;
            }
            if ((n = Math.max(DicomCMove.getDicomChildrenCount(iDataInfo2), list2.size())) == n2 && n > 1) {
                hashMap2.put(iDataInfo2.getKey(), iDataInfo2);
                for (IDataInfo iDataInfo4 : list2) {
                    hashMap2.remove(iDataInfo4.getKey());
                    hashMap.remove(iDataInfo4.getKey());
                }
                continue;
            }
            hashMap.remove(iDataInfo.getKey());
            hashMap2.put(iDataInfo.getKey(), iDataInfo);
        }
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
        arrayList.addAll(hashMap2.values());
        return arrayList;
    }

    private static int getDicomChildrenCount(IDataInfo iDataInfo) {
        if (iDataInfo.getHierarchyLevel() == Level.Series) {
            return iDataInfo.getInt(2101769);
        }
        if (iDataInfo.getHierarchyLevel() == Level.Study) {
            return iDataInfo.getInt(2101766);
        }
        return 0;
    }

    private static void sendObject(SingleCMoveHelper singleCMoveHelper, String string, IDataInfo iDataInfo) throws DicomException {
        Attributes attributes = new Attributes();
        attributes.setString(524312, VR.UI, iDataInfo.getString(524312));
        attributes.setString(0x20000E, VR.UI, iDataInfo.getTreeParent().getString(0x20000E));
        attributes.setString(0x20000D, VR.UI, iDataInfo.getTreeParent().getTreeParent().getString(0x20000D));
        singleCMoveHelper.move(string, attributes, QueryRetrieveLevel.Image);
    }

    private static void sendSerie(SingleCMoveHelper singleCMoveHelper, String string, IDataInfo iDataInfo) throws DicomException {
        Attributes attributes = new Attributes();
        attributes.setString(0x20000E, VR.UI, iDataInfo.getString(0x20000E));
        attributes.setString(0x20000D, VR.UI, iDataInfo.getTreeParent().getString(0x20000D));
        singleCMoveHelper.move(string, attributes, QueryRetrieveLevel.Series);
    }

    private static void sendStudy(SingleCMoveHelper singleCMoveHelper, String string, IDataInfo iDataInfo) throws DicomException {
        Attributes attributes = new Attributes();
        attributes.setString(0x20000D, VR.UI, iDataInfo.getString(0x20000D));
        singleCMoveHelper.move(string, attributes, QueryRetrieveLevel.Study);
    }

    private static void logAuditMessageForSentDICOMInstances(IDicomNode iDicomNode, IDicomNode iDicomNode2, List<? extends Attributes> list, long l, boolean bl) {
        AuditMessage auditMessage = Audit.getInstance().logSendedDICOMInstances(iDicomNode2.toString(), iDicomNode2.getHost(), iDicomNode2.getCalledAET(), iDicomNode.toString(), iDicomNode.getHost(), iDicomNode.getCalledAET(), list, bl ? Long.valueOf(l) : null);
        Audit.getInstance().logAuditMessage(auditMessage, bl ? "0" : "8");
    }

    private static class CombinedCMoveHelper
    implements WaitCancelable {
        private final SingleCMoveHelper[] cMoveOperations;
        private final CountDownLatch mutex;
        private int lastError = 0;
        private boolean canceled = false;
        private final ProgressState ps;

        CombinedCMoveHelper(ProgressState progressState, int n, IDicomNode iDicomNode, String ... stringArray) {
            this.cMoveOperations = this.createCMoveOperations(n, iDicomNode, stringArray);
            this.mutex = new CountDownLatch(n);
            this.ps = progressState;
        }

        private SingleCMoveHelper[] createCMoveOperations(int n, IDicomNode iDicomNode, String ... stringArray) {
            SingleCMoveHelper[] singleCMoveHelperArray = new SingleCMoveHelper[n];
            int n2 = 0;
            while (n2 < singleCMoveHelperArray.length) {
                singleCMoveHelperArray[n2] = new SingleCMoveHelper(this, iDicomNode, stringArray);
                ++n2;
            }
            return singleCMoveHelperArray;
        }

        SingleCMoveHelper getSingleCMoveHelper(int n) {
            return this.cMoveOperations[n];
        }

        void updateProgress() {
            if (this.ps != null) {
                this.ps.setProgress((float)Arrays.stream(this.cMoveOperations).mapToDouble(SingleCMoveHelper::getProgress).sum() / (float)this.cMoveOperations.length);
            }
        }

        void notifyFinished() {
            this.mutex.countDown();
            if (this.mutex.getCount() == 0L && this.ps != null) {
                this.ps.setProgress(1.0f);
                this.ps.setState(JobState.FINISHED);
            }
        }

        void notifyFailure(int n) {
            this.lastError = n;
        }

        public int getLastError() {
            return this.lastError;
        }

        public void waitUntilFinished() {
            while (true) {
                try {
                    this.mutex.await();
                }
                catch (InterruptedException interruptedException) {
                    log.error("Interrupted while waiting for C-MOVE", (Throwable)interruptedException);
                    continue;
                }
                break;
            }
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void cancel() {
            this.canceled = true;
            while (this.isRunning()) {
                this.mutex.countDown();
            }
        }

        public boolean isRunning() {
            return this.mutex.getCount() > 0L;
        }
    }

    public static enum MoveResult {
        MOVE_SUCCESSFUL,
        MOVE_FAILED,
        MOVE_NOT_CONFIGURED;

    }

    private static class SingleCMoveHelper
    implements ICMoveSCUListener {
        private final CombinedCMoveHelper parent;
        private int count = -1;
        private int allCount = -1;
        private double progress;
        private DicomCompositeCMoveSCU cmove = null;

        SingleCMoveHelper(CombinedCMoveHelper combinedCMoveHelper, IDicomNode iDicomNode, String ... stringArray) {
            this.parent = combinedCMoveHelper;
            this.cmove = new DicomCompositeCMoveSCU(iDicomNode, stringArray);
        }

        void move(String string, Attributes attributes, QueryRetrieveLevel queryRetrieveLevel) throws DicomException {
            this.cmove.connect();
            this.cmove.move(string, attributes, queryRetrieveLevel, (ICMoveSCUListener)this);
        }

        public void cmoveFinished(int n, Integer n2, Integer n3) {
            if (n != 0 && n != 65280) {
                this.parent.notifyFailure(n);
                this.count = 0;
            } else {
                if (n == 0) {
                    this.count = 0;
                }
                if (n2 != null && this.allCount == -1 && n3 != null) {
                    this.allCount = n3 + n2;
                }
                if (n2 != null) {
                    this.count = n2;
                }
            }
            if (this.allCount > 0 && this.count > 0) {
                this.progress = (double)(this.allCount - this.count) / (double)this.allCount;
                this.parent.updateProgress();
            }
            if (this.count <= 0) {
                this.parent.notifyFinished();
                this.closeCMoveSCU();
            }
        }

        double getProgress() {
            return this.progress;
        }

        private void closeCMoveSCU() {
            if (this.cmove != null) {
                try {
                    this.cmove.close();
                    this.cmove = null;
                }
                catch (DicomException dicomException) {
                    log.warn("Closing C-MOVE SCU failed", (Throwable)dicomException);
                }
            }
        }
    }
}

