/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.util.OverlayUtils;
import com.agfa.pacs.logging.ALogger;
import org.dcm4che3.data.Attributes;

public class ImageObject {
    private static final ALogger log = ALogger.getLogger(ImageObject.class);
    private Attributes dataset;
    private IObjectInfo objectInfo;
    private Attributes postPixelDataset;
    private IPixelDataInfo[] frames;
    private boolean finishReceived = false;
    private boolean finished = false;
    private boolean failed = false;

    public IPixelDataInfo getFrame(int n) {
        return this.frames[n];
    }

    public int getFrameCount() {
        return this.frames.length;
    }

    public Attributes getPostPixelDataset() {
        return this.postPixelDataset;
    }

    public void setPostPixelDataset(Attributes attributes) {
        this.postPixelDataset = attributes;
    }

    public Attributes getDataset() {
        return this.dataset;
    }

    public void setNumberOfFrames(int n) {
        this.frames = new IPixelDataInfo[n];
    }

    public IObjectInfo getObjectInfo() {
        return this.objectInfo;
    }

    public void setDatasetAndFinish(Attributes attributes) {
        this.setDataset(attributes);
        if (this.frames == null) {
            this.frames = new IPixelDataInfo[0];
        }
        if (this.finishReceived && !this.finished) {
            this.finished();
        }
    }

    public void setDataset(Attributes attributes) {
        Attributes attributes2 = new Attributes(attributes);
        OverlayUtils.addCachedOverlayData((Attributes)attributes2);
        this.dataset = attributes2;
    }

    public void setObjectInfo(IObjectInfo iObjectInfo) {
        this.objectInfo = iObjectInfo;
    }

    public void setFrame(IPixelDataInfo iPixelDataInfo, int n) {
        if (this.frames == null) {
            if (this.dataset == null) {
                throw new IllegalArgumentException("Set Frame received before dicomDataAvailable");
            }
            int n2 = ImageObject.extractNumberOfFrames(iPixelDataInfo.getTransferSyntaxUID(), this.dataset);
            if (n2 == 0) {
                log.warn("Received a frame for SOP Instance {}, although dataset expects no frames!", (Object)this.dataset.getString(524312));
            }
            this.frames = new IPixelDataInfo[n2];
        }
        if (this.frames.length > n) {
            this.frames[n] = iPixelDataInfo;
        } else {
            log.error("Received frame no {} (zero-based), but only {} frames expected for SOP Instance {}", new Object[]{n, this.frames.length, this.dataset.getString(524312)});
        }
        if (this.finishReceived && !this.finished) {
            this.finished();
        }
    }

    private static int extractNumberOfFrames(String string, Attributes attributes) {
        boolean bl = UIDUtilities.isTransferSyntaxType((String)string, (UIDType)UIDType.Video);
        if (!bl && attributes.containsValue(0x280008)) {
            return attributes.getInt(0x280008, 0);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        ImageObject imageObject;
        this.finishReceived = true;
        if (this.dataset == null) {
            return;
        }
        IPixelDataInfo[] iPixelDataInfoArray = this.frames;
        int n = this.frames.length;
        int n2 = 0;
        while (n2 < n) {
            imageObject = iPixelDataInfoArray[n2];
            if (imageObject == null) {
                return;
            }
            ++n2;
        }
        imageObject = this;
        synchronized (imageObject) {
            this.notifyAll();
            this.finished = true;
        }
    }

    boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed() {
        ImageObject imageObject = this;
        synchronized (imageObject) {
            this.notifyAll();
            this.failed = true;
        }
    }

    boolean isFailed() {
        return this.failed;
    }
}

