/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.shared.data.FileMetaInformationUtils;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.OutputStreamDicomDataWriter;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import java.io.InputStream;
import java.io.OutputStream;
import org.dcm4che3.data.Attributes;

public class ImageObjectWriter {
    public static final String STREAM_LENGTH = "STREAM_LENGTH";
    private final ImageObject imageObject;
    private final boolean writeMetaInfo;

    public ImageObjectWriter(ImageObject imageObject, boolean bl) {
        this.imageObject = imageObject;
        this.writeMetaInfo = bl;
    }

    public void writeTo(OutputStream outputStream) {
        Attributes attributes = this.imageObject.getDataset();
        String string = FileMetaInformationUtils.getTransferSyntaxUID((Attributes)attributes);
        FileMetaInformationUtils.removeFileMetaInformation((Attributes)attributes);
        OutputStreamDicomDataWriter outputStreamDicomDataWriter = new OutputStreamDicomDataWriter(outputStream, this.writeMetaInfo);
        outputStreamDicomDataWriter.setTransferSyntaxUID(string);
        String string2 = attributes.getString(524312);
        outputStreamDicomDataWriter.dicomDataAvailable(string2, attributes, this.imageObject.getFrameCount() > 0);
        int n = 0;
        while (n < this.imageObject.getFrameCount()) {
            IPixelDataInfo iPixelDataInfo = this.imageObject.getFrame(n);
            if (iPixelDataInfo.getDataClass() == InputStream.class) {
                long l = (Long)iPixelDataInfo.getDescription().getProperty(STREAM_LENGTH, (Object)0L);
                outputStreamDicomDataWriter.streamEncapsulatedPixelData((InputStream)iPixelDataInfo.getData(), (int)l);
            } else {
                outputStreamDicomDataWriter.pixelDataAvailable(string2, this.imageObject.getFrame(n), n);
            }
            ++n;
        }
        outputStreamDicomDataWriter.dicomDataFinished(string2, IDicomDataListener.Status.Success, this.imageObject.getPostPixelDataset());
    }
}

