/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.IDicomWebNode;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingElementFactory;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class StoreProcessor
implements IProcessingElement {
    private static final String CSTORE_PROCESSOR = "CStore";
    private static final String CMOVE_PROCESSOR = "CMove";
    private static final String STOWRS_PROCESSOR = "StowRS";
    public static final String PREFER_CMOVE_OVER_CSTORE = "preferCMoveOverCStore";
    public static final String SEND_IN_ONE_STOW_REQUEST = "SEND_IN_ONE_STOW_REQUEST";
    public static final String CONNECTION_AUTHENTICATOR = "ConnectionAuthenticator";
    private IProcessingElement storeDelegate;

    public void prepareProcessing(Properties properties, List<? extends Object> list) throws ProcessingException {
        String string = null;
        try {
            string = StoreProcessor.determineStoreProcessor(properties);
            this.storeDelegate = ProcessingElementFactory.getProcessingElement((String)string);
        }
        catch (Exception exception) {
            throw new ProcessingException("Failed to store objects. Store processor not found: " + string, null, (Throwable)exception);
        }
        this.storeDelegate.prepareProcessing(properties, list);
    }

    public void finishProcessing() throws ProcessingException {
        this.storeDelegate.finishProcessing();
    }

    public void cleanUp() {
        this.storeDelegate.cleanUp();
        this.storeDelegate = null;
    }

    public Object process(Object object) throws ProcessingException {
        return this.storeDelegate.process(object);
    }

    public ProcessingProperty[] queryProperties() {
        return this.storeDelegate.queryProperties();
    }

    public String getErrorMessage() {
        return this.storeDelegate.getErrorMessage();
    }

    public boolean supportsConcurrentProcessing() {
        return this.storeDelegate.supportsConcurrentProcessing();
    }

    private static String determineStoreProcessor(Properties properties) {
        IDicomNode iDicomNode = (IDicomNode)properties.get("DICOM_STORE_TARGET");
        if (iDicomNode instanceof IDicomWebNode && ((IDicomWebNode)iDicomNode).isServiceSupported(IDicomWebNode.ServiceType.StowRS)) {
            return STOWRS_PROCESSOR;
        }
        Boolean bl = (Boolean)properties.getOrDefault((Object)PREFER_CMOVE_OVER_CSTORE, Boolean.FALSE);
        return Objects.equals(Boolean.TRUE, bl) ? CMOVE_PROCESSOR : CSTORE_PROCESSOR;
    }
}

