/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.export.Messages;
import com.agfa.pacs.data.export.ProcessingExceptionMessageFactory;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.data.shared.export.ProcessingWarning;
import com.agfa.pacs.data.shared.pixel.DatasetImagePixel;
import com.agfa.pacs.data.shared.pixel.EncodedPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.data.shared.pixel.PixelDataInfoUtilities;
import com.agfa.pacs.data.shared.pixel.PixelDataReader;
import com.agfa.pacs.data.shared.pixel.decoder.PixelDataDecoderFactory;
import com.agfa.pacs.data.shared.pixel.encoder.IPixelDataEncoder;
import com.agfa.pacs.data.shared.pixel.encoder.PixelDataEncoderFactory;
import com.agfa.pacs.logging.ALogger;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class Transcoder
implements IProcessingElement {
    private static final ALogger log = ALogger.getLogger(Transcoder.class);
    public static final String ALLOWED_TRANSFER_SYNTAXES = "ALLOWED_TRANSFER_SYNTAXES";
    public static final String ALLOW_ALL_TRANSFER_SYNTAXES = "ALLOW_ALL_TRANSFER_SYNTAXES";
    public static final String UID_MAP = "UID_MAP";
    private boolean allowAllTransferSyntaxes = false;
    private Set<String> allowedTransferSyntaxes = null;
    private final Map<String, IPixelDataEncoder> encoders = new HashMap<String, IPixelDataEncoder>();
    private UIDMap uidMap = null;

    public void finishProcessing() {
    }

    public void cleanUp() {
        this.encoders.clear();
        this.allowedTransferSyntaxes = null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void prepareProcessing(Properties properties, List<? extends Object> list) {
        if (properties.containsKey(ALLOW_ALL_TRANSFER_SYNTAXES)) {
            this.allowAllTransferSyntaxes = (Boolean)properties.get(ALLOW_ALL_TRANSFER_SYNTAXES);
        }
        if (properties.containsKey(ALLOWED_TRANSFER_SYNTAXES)) {
            this.allowedTransferSyntaxes = (Set)properties.get(ALLOWED_TRANSFER_SYNTAXES);
        }
        if (properties.containsKey(UID_MAP)) {
            this.uidMap = (UIDMap)properties.get(UID_MAP);
            for (String string : this.uidMap.getClassUIDs()) {
                Set set;
                if (this.allowedTransferSyntaxes != null) {
                    this.uidMap.setTransferSyntaxUIDs(string, new LinkedHashSet<String>(this.allowedTransferSyntaxes));
                    continue;
                }
                if (UIDUtilities.getBaseType((String)string) == UIDType.Image) {
                    set = this.uidMap.getTransferSyntaxUIDs(string);
                    set.addAll(PixelDataEncoderFactory.getInstance().getSupportedTransferSyntaxUIDs());
                    if (!string.equals("1.2.840.10008.5.1.4.1.1.77.1.1")) continue;
                    set.addAll(UIDUtilities.getVideoTransferSyntaxUIDs());
                    continue;
                }
                if (UIDUtilities.getBaseType((String)string) == UIDType.Video) {
                    set = this.uidMap.getTransferSyntaxUIDs(string);
                    set.addAll(UIDUtilities.getVideoTransferSyntaxUIDs());
                    continue;
                }
                set = this.uidMap.getTransferSyntaxUIDs(string);
                set.add("1.2.840.10008.1.2");
            }
        }
    }

    public Object process(Object object) throws ProcessingException {
        if (!(object instanceof ImageObject)) {
            throw new IllegalArgumentException("Incorrect input");
        }
        ImageObject imageObject = (ImageObject)object;
        String string = imageObject.getDataset().getString(524310);
        Set set = this.uidMap.getTransferSyntaxUIDs(string);
        if (set == null) {
            throw new NotAcceptedObjects(imageObject);
        }
        if (set.isEmpty() && this.allowedTransferSyntaxes != null) {
            set.addAll(this.allowedTransferSyntaxes);
        }
        if (set.isEmpty() && !this.allowAllTransferSyntaxes) {
            throw new NotAcceptedObjects(imageObject);
        }
        if (this.isTranscodingRequired(imageObject, set)) {
            try {
                String string2 = imageObject.getDataset().getString(131088);
                String string3 = UIDUtilities.selectTransferSyntaxUID((Collection)set, (String)string2);
                log.info("Transcoding image {} from {} to {}", new Object[]{imageObject.getDataset().getString(524312), string2, string3});
                return this.transcode(imageObject, string3);
            }
            catch (PixelDataException | RuntimeException throwable) {
                log.error("Transcoding error", throwable);
                throw new ProcessingException("Transcoding error", ProcessingExceptionMessageFactory.getProcessingExceptionMessage("export.errorTranscoding", imageObject), throwable);
            }
        }
        return imageObject;
    }

    private boolean isTranscodingRequired(ImageObject imageObject, Set<String> set) {
        String string = imageObject.getDataset().getString(131088);
        if (string == null) {
            throw new IllegalArgumentException("Source transfer syntax for SOPInstanceUID " + imageObject.getDataset().getString(524312) + " is null");
        }
        if (this.signCorrectionNeeded(imageObject.getDataset())) {
            return true;
        }
        boolean bl = this.allowAllTransferSyntaxes || set.contains(string);
        return !bl;
    }

    private boolean signCorrectionNeeded(Attributes attributes) {
        return attributes.getInt("AgilityRuntime", 2686992, 0) != 0;
    }

    private ImageObject transcode(ImageObject imageObject, String string) throws PixelDataException {
        PhotometricInterpretation photometricInterpretation;
        ImageObject imageObject2 = new ImageObject();
        Attributes attributes = imageObject.getDataset();
        Attributes attributes2 = new Attributes(attributes);
        attributes2.setString(131088, VR.UI, string);
        int n = imageObject.getFrameCount();
        if (n > 0 && (photometricInterpretation = PhotometricInterpretation.get((String)attributes.getString(2621444))).isColor() && photometricInterpretation != PhotometricInterpretation.IndexedColor) {
            attributes2.setInt(2621446, VR.US, new int[]{0});
            if (photometricInterpretation != PhotometricInterpretation.RGBColor) {
                attributes2.setString(2621444, VR.CS, PhotometricInterpretation.RGBColor.dicom());
            }
        }
        this.removeAgilitySignCorrectionFromDataset(attributes2);
        if (n == 0) {
            imageObject2.setDatasetAndFinish(attributes2);
        } else {
            imageObject2.setDataset(attributes2);
            if (n == 1) {
                imageObject2.setFrame(this.eagerTranscodeFrame(imageObject.getFrame(0), attributes, attributes2, string), 0);
            } else {
                int n2 = 0;
                while (n2 < n) {
                    imageObject2.setFrame(this.lazyTranscodeFrame(imageObject.getFrame(n2), attributes, attributes2, string), n2);
                    ++n2;
                }
            }
        }
        imageObject2.setPostPixelDataset(imageObject.getPostPixelDataset());
        imageObject2.setObjectInfo(imageObject.getObjectInfo());
        return imageObject2;
    }

    private int removeAgilitySignCorrectionFromDataset(Attributes attributes) {
        int n = attributes.getInt("AgilityRuntime", 2686992, 0);
        if (n != 0) {
            int n2;
            attributes.remove("AgilityRuntime", 2686992);
            if (attributes.contains("AgilityRuntime", 2686996)) {
                n2 = attributes.getInt("AgilityRuntime", 2686996, 0);
                attributes.remove("AgilityRuntime", 2686996);
                attributes.setInt(2621699, VR.US, new int[]{n2});
            }
            if (attributes.contains("AgilityRuntime", 2686995)) {
                n2 = attributes.getInt("AgilityRuntime", 2686995, 0);
                attributes.remove("AgilityRuntime", 2686995);
                attributes.setInt(2621698, VR.US, new int[]{n2});
            }
        }
        return n;
    }

    private IPixelDataInfo eagerTranscodeFrame(IPixelDataInfo iPixelDataInfo, Attributes attributes, Attributes attributes2, String string) throws PixelDataException {
        return new EncodedPixelDataInfo(string, (Object)this.transcodeFrame(iPixelDataInfo, attributes, attributes2, string), attributes2);
    }

    private IPixelDataInfo lazyTranscodeFrame(IPixelDataInfo iPixelDataInfo, Attributes attributes, Attributes attributes2, String string) throws PixelDataException {
        return new LazyTranscodingPixelDataInfo(iPixelDataInfo, attributes, attributes2, string);
    }

    private ByteArrayContainer transcodeFrame(IPixelDataInfo iPixelDataInfo, Attributes attributes, Attributes attributes2, String string) throws PixelDataException {
        String string2 = iPixelDataInfo.getTransferSyntaxUID();
        PixelDataReader pixelDataReader = new PixelDataReader(iPixelDataInfo);
        try {
            if (string2 != null) {
                DatasetImagePixel datasetImagePixel = new DatasetImagePixel(attributes);
                ByteArrayContainer byteArrayContainer = (ByteArrayContainer)pixelDataReader.getData();
                Object object = PixelDataDecoderFactory.getInstance().decode((IImagePixel)datasetImagePixel, byteArrayContainer, string2);
                DatasetImagePixel datasetImagePixel2 = new DatasetImagePixel(attributes2);
                IPixelDataEncoder iPixelDataEncoder = this.getEncoder(string);
                byte[] byArray = iPixelDataEncoder.encode((IImagePixel)datasetImagePixel2, object);
                ByteArrayContainer byteArrayContainer2 = new ByteArrayContainer(byArray);
                return byteArrayContainer2;
            }
            DatasetImagePixel datasetImagePixel = new DatasetImagePixel(attributes2);
            Object object = pixelDataReader.getData();
            IPixelDataEncoder iPixelDataEncoder = this.getEncoder(string);
            byte[] byArray = iPixelDataEncoder.encode((IImagePixel)datasetImagePixel, object);
            ByteArrayContainer byteArrayContainer = new ByteArrayContainer(byArray, 0, byArray.length);
            return byteArrayContainer;
        }
        finally {
            pixelDataReader.releaseData();
        }
    }

    private synchronized IPixelDataEncoder getEncoder(String string) {
        if (!this.encoders.containsKey(string)) {
            try {
                this.encoders.put(string, PixelDataEncoderFactory.getInstance().createPixelDataEncoder(string));
            }
            catch (PixelDataException pixelDataException) {
                log.error("Could not find Encoder", (Throwable)pixelDataException);
            }
        }
        return this.encoders.get(string);
    }

    public ProcessingProperty[] queryProperties() {
        ProcessingProperty[] processingPropertyArray = new ProcessingProperty[]{new ProcessingProperty(ALLOWED_TRANSFER_SYNTAXES, Set.class, null)};
        return processingPropertyArray;
    }

    public boolean supportsConcurrentProcessing() {
        return true;
    }

    private class LazyTranscodingPixelDataInfo
    implements IPixelDataInfo {
        private final Attributes description;
        private final String transferSyntaxUID;
        private final IPixelDataInfo sourceFrame;
        private final Attributes sourceDescription;

        public LazyTranscodingPixelDataInfo(IPixelDataInfo iPixelDataInfo, Attributes attributes, Attributes attributes2, String string) {
            this.description = attributes2;
            this.transferSyntaxUID = string;
            this.sourceFrame = iPixelDataInfo;
            this.sourceDescription = attributes;
        }

        public CacheID getCacheID() {
            return null;
        }

        public Object getData() {
            ByteArrayContainer byteArrayContainer = null;
            try {
                byteArrayContainer = Transcoder.this.transcodeFrame(this.sourceFrame, this.sourceDescription, this.description, this.transferSyntaxUID);
            }
            catch (PixelDataException pixelDataException) {
                throw new RuntimeException(pixelDataException);
            }
            return byteArrayContainer;
        }

        public Class<?> getDataClass() {
            return ByteArrayContainer.class;
        }

        public Attributes getDescription() {
            return this.description;
        }

        public String getTransferSyntaxUID() {
            return this.transferSyntaxUID;
        }

        public boolean isLossless() {
            return PixelDataInfoUtilities.isLossless((IPixelDataInfo)this, (String)this.transferSyntaxUID);
        }
    }

    private static class NotAcceptedObjects
    extends ProcessingWarning {
        public NotAcceptedObjects(ImageObject imageObject) {
            super("Not accepted dicom object", MessageFormat.format(Messages.getString("Transcoder.NotAcceptedObject"), imageObject.getDataset().getString(524310), imageObject.getDataset().getString(131088)));
        }
    }
}

